% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predictions}
\alias{predictions}
\title{Adjusted Predictions}
\usage{
predictions(
  model,
  variables = NULL,
  newdata = NULL,
  conf.level = 0.95,
  type = "response",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{variables}{Character vector. Compute Adjusted Predictions for
combinations of each of these variables. Factor levels are considered at
each of their levels. Numeric variables variables are considered at Tukey's
Five-Number Summaries. \code{NULL} uses the original data used to fit the model.}

\item{newdata}{A dataset over which to compute adjusted predictions. \code{NULL} uses
the original data used to fit the model.}

\item{conf.level}{The confidence level to use for the confidence interval.
No interval is computed if \code{conf.int=NULL}.  Must be strictly greater than 0
and less than 1. Defaults to 0.95, which corresponds to a 95 percent
confidence interval.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A \code{data.frame} with one row per observation and several columns:
\itemize{
\item \code{rowid}: row number of the \code{newdata} data frame
\item \code{type}: prediction type, as defined by the \code{type} argument
\item \code{group}: (optional) value of the grouped outcome (e.g., categorical outcome models)
\item \code{predicted}: predicted outcome
\item \code{std.error}: standard errors computed by the \code{insight::get_predicted} function or, if unavailable, via \code{marginaleffects} delta method functionality.
\item \code{conf.low}: lower bound of the confidence or highest density interval (for bayesian models)
\item \code{conf.high}: upper bound of the confidence or highest density interval (for bayesian models)
}
}
\description{
Compute model-adjusted predictions (fitted values) for a "grid" of regressor values.
}
\examples{
# Predicted outcomes for every row of the original dataset
mod <- lm(mpg ~ hp + factor(cyl), data = mtcars)
pred <- predictions(mod)
head(pred)

# Predicted outcomes for user-specified values of the regressors
predictions(mod, newdata = datagrid(hp = c(100, 120), cyl = 4))

# Plot of predicted outcomes for different values of the regressor
plot_cap(mod, condition = "hp")
}
