% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRI.R
\name{mri}
\alias{mri}
\title{mri}
\usage{
mri(rst.r = NULL, rst.file = NULL, pts.shp = NULL, pts.spdf = NULL,
  pts.df = NULL, pts.txt = NULL, pts.attr = NULL, pts.x = "x",
  pts.y = "y", pts.dec = ".", pts.sep = "\\t", area.spdf = NULL,
  area.shp = NULL, epsg, md = "Sph", rg = NULL, ng = 0.1,
  out.folder = NULL, out.prefix = NULL, out.dec = ".", out.sep = "\\t",
  rst.res = NULL, rst.data.type = "INT1U", b = NULL)
}
\arguments{
\item{rst.r}{raster layer. At least one of the arguments 'rst.r' or 'rst.file'
must be specified.}

\item{rst.file}{Path to raster file (for example .tif). At least one of the
arguments 'rst.r' or 'rst.file' must be specified.}

\item{pts.shp}{Path to point shapefile with observed soil property data.
The coordinate system shall be the same as for the raster. At least one of
the arguments 'pts.shp', 'pts.df', 'pts.txt' or 'pts.spdf' must be specified.}

\item{pts.spdf}{SpatialPointsDataframe The coordinate system shall be the same
as for the raster. At least one of the arguments 'pts.shp', 'pts.df',
'pts.txt' or 'pts.spdf' must be specified.}

\item{pts.df}{Data.frame with spatial coordinates (same coordinates as for
the raster layer) and attribure data. At least one of the arguments 'pts.shp',
pts.df', 'pts.txt' or 'pts.spdf' must be specified.}

\item{pts.txt}{Path to text file with spatial coordinates (same coordinates
as for the raster layer) and attribure data. At least one of the arguments
'pts.shp', 'pts.df', 'pts.txt' or 'pts.spdf' must be specified.}

\item{pts.attr}{Name of the attribute column in pts.sp, pts.df or pts.txt.
Required. The data must be numerical.}

\item{pts.x}{Name of the x coordinate column in pts.df. Requiredif pts.df
is specified.}

\item{pts.y}{Name of the y coordinate column in pts.df. Requiredif pts.df
is specified.}

\item{pts.dec}{Decimal delimiter in pts.txt. Default is period.}

\item{pts.sep}{Separation in pts.txt. Default is tab.}

\item{area.spdf}{SpatialPolygonsDataframe delineating the area to be mapped
Optional. The coordinate system shall be the same as for the rasters. If not
completely overlapping, the itersection of x and area will be used.}

\item{area.shp}{Path to polygon shapefile delineating the area to be mapped
Optional. The coordinate system shall be the same as for the rasters. If not
ompletely overlapping, the itersection of x and area will be used.}

\item{epsg}{Epsg code (numeric) for the orthognonal spatial reference system
onto which input data are projected, see e.g.
http://spatialreference.org/ref/epsg/}

\item{md}{variogram model type for the stadardized variograms used for
ordinary kriging interpolation of observed data or residuals. Varigrams
are  generated by gstat::vgm. Default is "Sph" (spherical model).}

\item{rg}{range of the stadardized variograms used for ordinary kriging
interpolation of observed data or residuals. Varigrams are  generated by
gstat::vgm. If no rg is specified it will be set to half of the square root
of the mapping area.}

\item{ng}{nugget of the stadardized variograms used for ordinary kriging
interpolation of observed data or residuals. Varigrams are  generated by
gstat::vgm. Default is "Sph" (spherical model). The nugget is expressed as a
fraction of the sill. An ng = 0.1 means that the nugget is 10 % of
the sill. The sill is by default equal to the variace of the data to be
krigied (i.e the point observations or the residuals).}

\item{out.folder}{Output folder (path) to which the output files shall be
exported. Optional. Data will only be exported if an out_folder path is
defined.}

\item{out.prefix}{Prefix (character) for the output filenames.}

\item{out.dec}{Decimal delimiter in exported text files. Default is period.}

\item{out.sep}{Separation in pts.txt. Default is tab.}

\item{rst.res}{Resolution to which the imported raster shall be
resampled before adaptation. See raster::dataType for details.}

\item{rst.data.type}{Data type for exported rasters. Default is 'INT1U'.}

\item{b}{Width of buffer zone
around point observations to which the area to be mapped shall be delineated.
Default = 1 000 000 in the same unit as for the projected spatial reference
system.}
}
\value{
A list with:

1) 'all_maps.r'  a raster stack with the original raster map ('map'), the map,
created by ordinary kriging of observed data ('ordkrig'), by residual kriging
('reskrig') and by regression kriging ('regkrig').

2) 'mapped.area.sp' a SpatialPolygonsDataFrame with a polygon delineating the
mapped area. The mapped area is the intersection between the original raster
map, the input area polygon ('area.sp') and the buffered (1.5*max dist between
one point and its neares neighbour) point locations.
adapted map and a map created by ordinary kriging using an standardized
variogram, 2) a data.frame with validation sratistics of the three maps.

3) 'used.pts.sp' a SpatialPointsDataFrame with the pints used for mapping,
i.e points falling within the mapped area and with no NA values in among the
observed values and the values extacted from the original map.

4) 'evaluation' a data.frame with evaluation statistics for the original map
and the eave-one out cross validation of the three other mapping methods.

5) 'feedback' a data.frame with feedback on inputted and used data.
}
\description{
Local adaptation and evaluation of digital soil maps in raster format by use
of point location soil property data.
}
\details{
Maps.R.Interactive is intended for local adaptation and or/evaluation
of large extent digital soil maps. A raster map and point location soil
property data projected onto the same projected cartesian coordinate systenm
are required from the Four maps are (created and) evaluated: the original
raster map, a map created solely based on the soil samples data (ordinary
kriging using a standardized variogram), two maps based on a combination of the
two (regression kriging and residual kriging, both using standardized variograms).
The maps are evaluated by leave-one-out cross validation and a number of evaluation
measures are computed: the Nash-Sutcliffe modelling efficiency (E),
the mean absolute error (MAE; Janssen & Heuberger, 1995), the coefficient of
determination of a linear regression between predicted and measured values (r2).
Maps.R.Interactive was used by Piikki et al.(2017) and Nijbroek et al. (2018)
(before it was made available as an R package). More details can be found in
these publications. It is also implemented in the open Swedish web application
for precision agriculture markdata.se.
}
\examples{
##retrieve example point location data
data('CLAYs')
##create path to example raster dataset
rst.path<-  system.file("extdata/CLAYr.tif", package="mapsRinteractive")
##run local adaptation and evaluation
mri.out<-mri(
 rst.file = rst.path,
 pts.df = CLAYs,
 pts.attr ='clay_percent',
 pts.x= 'POINT_X',
 pts.y= 'POINT_Y',
 epsg = 3006
 )
##check evaluation metasures
print(mri.out$evaluation)
}
\references{
Nijbroek, R., Piikki, K., Söderström, M., Kempen, B., Turner,
K. G., Hengari, S., & Mutua, J. (2018). Soil Organic Carbon Baselines for
Land Degradation Neutrality: Map Accuracy and Cost Tradeoffs with Respect to
Complexity in Otjozondjupa, Namibia. Sustainability, 10(5), 1610.
doi:10.3390/su10051610

Piikki, K.,Söderström, M., Stadig, H. 2017. Local adaptation of a national digital
soil map for use in precision agriculture. Adv. Anim. Biosci. 8, 430–432.

Janssen, P.H.M.; Heuberger, P.S.C.1995. Calibration of process-oriented models.
Ecol. Model., 831, 55–66.

Nash, J.E.; Sutcliffe, J.V. River flow forecasting through conceptual models
part I—A discussion of principles. J. Hydrol. 1970, 103, 282–290.
}
\author{
Kristin Piikki & Mats Söderström ,  \email{kristin.piikki@slu.se}
}
