context("Map reestimation")
test_that("reestimate genetic maps correctly correctly", {
  x1 <- get_submap(solcap.dose.map[[1]], 1:5, reestimate.rf = F)
  s<-make_seq_mappoly(x1)
  tpt<-est_pairwise_rf(s)
  m <- rf_list_to_matrix(tpt)
  x2 <- reest_rf(x1)
  expect_equivalent(mean(x2$maps[[1]]$seq.rf), 0.00973, tolerance = 1e-4)
  x3 <- reest_rf(x1, input.mat = m, method = "ols")
  expect_equivalent(mean(x3$maps[[1]]$seq.rf), 0.0248, tolerance = 1e-4)
  x4 <- est_full_hmm_with_global_error(x1)
  expect_equivalent(mean(x4$maps[[1]]$seq.rf), 0.00993, tolerance = 1e-4)
  expect_error(x5 <- est_full_hmm_with_prior_prob(x1))
  x5 <- get_submap(solcap.prior.map[[1]], 1:10, reestimate.rf = FALSE)
  x6 <- est_full_hmm_with_prior_prob(x5, tol = 10e-3)
  expect_equivalent(mean(x6$maps[[1]]$seq.rf), 0.008775, tolerance = 1e-4)
})