% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_qtlpoly.R
\name{export_qtlpoly}
\alias{export_qtlpoly}
\title{Export to QTLpoly}
\usage{
export_qtlpoly(input.genoprobs, verbose = TRUE)
}
\arguments{
\item{input.genoprobs}{an object of class \code{mappoly.genoprob}}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\description{
Compute homolog probabilities for all individuals in the full-sib
population given a map and conditional genotype probabilities, and exports
the results to be used for QTL mapping in the QTLpoly package.
}
\examples{
   \donttest{
     ## tetraploid example
     w1 <- calc_genoprob(solcap.dose.map[[1]])
     h.prob <- export_qtlpoly(w1)
  }

}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
