% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homolog_probs.R
\name{calc_homologprob}
\alias{calc_homologprob}
\title{Homolog probabilities}
\usage{
calc_homologprob(input.genoprobs, verbose = TRUE)
}
\arguments{
\item{input.genoprobs}{an object of class \code{mappoly.genoprob}}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\description{
Compute homolog probabilities for all individuals in the full-sib
population given a map and conditional genotype probabilities.
}
\examples{
   \donttest{
     ## tetraploid example
     w1 <- calc_genoprob(solcap.dose.map[[1]])
     h.prob <- calc_homologprob(w1)
     print(h.prob)
     plot(h.prob, ind = 5, use.plotly = FALSE)
     ## using error modeling (removing noise)
     w2 <- calc_genoprob_error(solcap.err.map[[1]])
     h.prob2 <- calc_homologprob(w2)
     print(h.prob2)
     plot(h.prob2, ind = 5, use.plotly = FALSE)
  }

}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
