# crsLL = CRS("+init=epsg:4326")
if(requireNamespace("rgdal", quietly=TRUE)) {

crsLL = CRS("+init=epsg:4326")
crsMerc = CRS("+init=epsg:3857")

} else {
crsLL = CRS("+proj=longlat +datum=WGS84 +no_defs")


crsMerc = CRS(
      "+proj=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +k=1 +units=m +nadgrids=@null +wktext +no_defs")

}
crsModis <- sp::CRS("+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")

bboxLL = as(raster::extent(-180,180,-90,90), 'SpatialPolygons')
eps = 0.1    
bboxLLsafe = as(raster::extent(-180,180,-90+eps,90-eps), 'SpatialPolygons')
bboxLLsafe@proj4string = bboxLL@proj4string = crsLL



polyhedron = new(
  "SpatialPoints",
  coords = structure(
    c(
      -119.999286255401,
      -141.816495096945,-119.999301607951,-98.1821421474731,-92.2441966643566,
      -119.999256423558,-147.754431090525,-158.384373409798,
      179.804478614883,
      -171.000427127452,-152.557017161569,-138.014098253048,-166.851448611261,
      -119.999309658622,-135.39569425213,-119.999313417216,-104.602951438291,
      -101.984545117919,-81.6143680293094,-87.4416988662312,-68.9984171850191,
      -59.8033971210922,-73.1473363485156,-60.068825928253,-46.7934819565284,
      -27.8322085436695,-38.3006045270358,-81.8745045902868,-119.999190478018,
      -60.0952432919551,-119.99898033518,-179.903438905768,-158.124117889708,
      -179.930045862115,
      158.301537097259,
      147.832967674514,
      166.79444284322,
      -0.000131991452665303,
      21.7431546036455,
      27.8319277915436,-0.000214042274641243,
      -21.7433395731943,-8.55937954108419e-05,
      38.0133384896222,
      31.7764706010597,
      50.108085359453,
      59.8033753033267,
      46.7933479620109,
      17.745751521451,
      60.0686540910692,
      73.1473287244358,
      92.2442479135526,
      81.8743347923351,
      38.3001662338005,-0.000387405123226903,
      60.0945580271623,-0.000930421293640134,
      -38.0134350178678,-17.7458747919108,-50.1081044869816,-31.7765363028632,
      -5.63177860855642e-05,-14.8898269801826,-3.62484555639006e-05,
      14.8897460943736,
      119.999580319674,
      119.999641991352,
      141.816983992883,
      147.754927538302,
      119.999470008053,
      98.1823075832756,
      119.999680886386,
      104.603230906758,
      119.999708089947,
      135.396189160726,
      138.014588355916,
      101.984778709229,
      158.385001405112,
      152.557626681089,
      171.001153923971,
      -179.803713873703,
      166.85211292283,
      179.930783901266,-166.793615841895,
      -147.832039006717,-158.300638122358,
      158.124652788233,
      119.999233616228,
      179.904160400144,
      119.998484569757,
      81.6144631830692,
      68.9984771794597,
      87.4418627509767,-119.999540007934,-98.2560213722387,-92.1671275882308,
      -119.999574048378,-141.743072583037,-119.999518947544,-81.9857366997505,
      -88.2226772662398,-69.8909569895784,-60.1955988570515,-73.2056243820514,
      -102.253496465565,-59.9301690303686,-46.8515699732094,-27.7545875642572,
      -38.1242813719308,-81.6986606603057,-119.999642868649,-59.9037504756483,
      -119.999854688433,-158.013412570408,-137.745550353469,-170.108253141869,
      -151.7764092371,-119.999503507035,-134.889463038566,-119.999490496764,
      -105.109548418499,
      0.000548062917435327,
      21.8177116373725,
      27.755727775415,
      0.000621501244621865,-21.8166624584997,
      0.000512229476143603,
      38.3855233103769,
      32.5581537152742,
      51.0015196568637,
      60.1966209803923,
      46.8526355301338,
      18.0152781946159,
      59.9313168102065,
      73.206685197715,
      92.1682265347654,
      81.6999124350397,
      38.1255967725635,
      0.000788497618438803,
      59.9053965357739,
      0.00132762061225494,-38.3845079781962,-18.0142754528685,
      -51.0005235029116,-32.5571648987345,
      0.000495108380620794,-15.3958776428048,
      0.000488367763450713,
      15.3968592247511,
      120.000557444814,
      120.00065649282,
      98.2570538259009,
      120.000509512085,
      141.744010632549,
      120.000884515601,
      120.001628400634,
      81.9867551000931,
      102.25450044424,
      69.8919576920066,
      88.2236776304897,
      120.000486333124,
      137.746497758919,
      105.110543326595,
      120.000476271633,
      134.890422881646,
      158.014288375496,
      151.777319236651,
      170.109084276791,
      0.000487622065661181,-13.4988640674431,-12.0711112883205,
      0.000490239350153441,
      12.0720890957447,
      13.4998393988643,-28.3538097529457,
      -25.2085828791813,-44.28925262776,-39.2451667247332,-22.7833197533558,
      -35.3541040286466,-32.2806043683773,-20.8637888371826,-10.9630034480083,
      0.00049447628480496,-10.079802252885,
      0.000499095685911616,
      10.0807962337082,
      10.9639884169595,
      22.7843023689615,
      25.2095602740289,
      20.8647795788933,
      32.2815934838587,
      35.3550864282912,
      28.354787844149,
      39.2461461336859,
      44.2902355495537,-40.7362715305168,-51.9805851435915,
      -48.3242058021675,-37.8851398473661,-29.7981644211831,-44.1949618906488,
      -63.3446483828354,-68.6486993065212,-74.607588041054,-69.5462893815483,
      -58.9321538339761,-56.4043196613113,-55.2043401028468,-65.2373546543017,
      -61.5160081928496,-52.0031153358012,-45.2479444645147,-35.4876406694835,
      -42.6117251311044,-33.4303460814994,-26.021128098075,-27.7491926861861,
      -19.3077268951693,-18.0170023168162,-9.3584281025239,-48.4736313045334,
      -53.8699513293002,-61.8469704294648,-31.6280348495245,-38.259807725422,
      -30.0151373349126,-23.2186283335487,-24.5315712474069,-40.3095488545864,
      -44.4768740839827,-52.732253983887,-50.3277381473105,-42.4082396889517,
      -36.398174482981,-46.7233083967129,-28.5396221587691,-34.6723183033218,
      -27.1584357853379,-20.9401570686018,-22.0343685754905,-15.1250033200463,
      -14.3543208478051,-7.37869680466752,-7.78579808587566,-15.9706534189783,
      -16.9217292129126,-8.23869055435169,-8.755168841161,-49.2073806386185,
      -58.2545414090462,-55.3530762640055,
      0.000503174624195919,
      7.00409116129509,
      7.37970667536222,
      0.000506327479821725,-7.00309001993158,
      0.000497688744243825,
      13.6344029734016,
      12.9407811218571,
      19.9040418455875,
      20.9411560900976,
      14.3553262152041,
      6.64769326369938,
      15.126015383602,
      22.0353770741046,
      23.2196417644916,
      15.9716676987393,
      7.78681207104562,
      0.000507221087795138,
      8.23970431541342,
      0.000506058799617404,-13.6334089386486,-6.64670549376822,
      -19.9030568983249,-12.939802978214,
      0.000489918550944617,-6.29792743786262,
      0.000480031066163523,
      6.29889740367741,
      31.6290494464862,
      40.3105651078775,
      33.4313602076776,
      24.5325853499698,
      30.0161484369677,
      38.2608215554296,
      49.2083997154433,
      55.3540985431576,
      58.2555650351255,
      52.0041328949081,
      42.6127401930698,
      46.7243257511219,
      35.4886510088385,
      45.2489554634988,
      37.8861439978005,
      27.7501977587518,
      26.0221391458556,
      16.9227416361999,
      18.0180094893391,
      8.75617858221587,
      28.5406253964535,
      36.3991817667869,
      27.1594266129708,
      34.673314629703,
      44.477885887353,
      42.4092417306678,
      50.3287467185907,
      52.7332713945556,
      40.7372682857322,
      29.7991617028985,
      48.3252108531699,
      51.9815835876592,
      44.1959515338618,
      19.3087264003992,
      9.35943086182053,
      55.2053537056693,
      58.9331620488763,
      61.5170302784853,
      65.2383731257445,
      63.3456509516447,
      56.4053122685445,
      69.5473031283442,
      74.6085969860368,
      68.6496972063572,
      48.474615893184,
      61.847959491923,
      53.8709349074362,-160.736150742543,-171.98050225976,-168.324111860364,
      -157.885010037007,-149.798011679711,-152.280458366673,-164.194851200212,
      176.655393908885,
      171.351328804889,
      165.392414823949,
      170.453724765638,
      -178.93209947638,-176.404249739162,-175.20427484892,
      174.762669645501,
      178.484025983766,-172.003039298251,-165.247840172161,-155.487501700123,
      -162.611610079153,-153.430196795783,-146.020960567671,-147.749033117467,
      -139.307550279961,-138.01682051433,-129.358236521798,-130.079613030466,
      -140.863616158859,-142.783150767046,-155.353965904758,-130.962815194711,
      -132.070923571755,-145.20841849934,-168.473533071935,-159.245038911567,
      -173.869869001389,
      178.153083605432,-151.627873308444,-158.259666466994,
      -150.014961073227,-143.218438430552,-144.531393798522,-160.309421709696,
      -164.476757716493,-172.732183619018,-170.327651556387,-162.408105378998,
      -156.398016653373,-166.723207467795,-148.539428441102,-154.672141254983,
      -147.158221853154,-140.939933578967,-142.034163353196,-135.124791444424,
      -134.354092896102,-127.378469156932,-127.785584226831,-135.970454466123,
      -136.921540162485,-128.23848714774,-128.754972730195,-169.207292968144,
      -178.254496748847,-175.353019741254,-119.999258976441,-112.995665412536,
      -112.620066712727,-119.999270915529,-127.002845285256,-119.999246068707,
      -106.365351507588,-107.058951455197,-100.095712808109,-99.0586198690578,
      -105.6444471719,-113.352043306848,-104.873773603347,-97.9644171021678,
      -96.7801674114787,-104.028133472587,-112.212974682726,-119.999281642097,
      -111.760092298829,-119.999290990475,-133.633161856195,-126.646440629693,
      -139.902812347273,-132.939534032698,-119.999232521394,-126.297639870184,
      -119.999218749243,-113.700816433847,-88.3707849400777,-79.6893000837417,
      -86.5684868944844,-95.4672356888098,-89.9836706702997,-81.739026956523,
      -70.7915024774077,-64.6458239615063,-61.7443808317433,-67.9957881229403,
      -77.3871399953601,-73.2755570774994,-84.5112068351294,-74.7509389576444,
      -82.1137235507762,-92.2496391116094,-93.9776909308892,-103.077068402946,
      -101.981806421331,-111.243624535276,-91.4591755537532,-83.6006477978237,
      -92.8403532222026,-85.3264934041261,-75.5219761704256,-77.5905975868108,
      -69.6711271732802,-67.26662738237,-79.2626093377183,-87.7182543771807,
      -90.2006806341355,-71.6746983951915,-68.0183430554596,-75.8039386324642,
      -97.2155204885024,-94.7902658854631,-107.927717120091,-109.035818757024,
      -99.1350416603998,-84.6447691132295,-100.691092953353,-109.919011461922,
      -110.64037575764,-64.7945868518441,-61.0668005302341,-58.4829396992172,
      -54.7616232308519,-56.6543386050819,-63.5946372087316,-50.4527239194402,
      -45.391467799753,-51.3503277458204,-71.5252924584182,-58.1520224770441,
      -66.1290021952876,-80.7537225352479,-119.999314306296,-119.999313031197,
      -106.49996710335,-133.498677565354,-119.999309938664,-119.99930519035,
      -91.645046422727,-75.7096571022459,-148.353652112907,-164.28913865615,
      79.262824765657,
      68.0185033863415,
      71.6748951609939,
      82.1139744887978,
      90.2009591281674,
      87.7184990487968,
      75.8041176552608,
      56.6544532161907,
      51.3504058814636,
      45.3915468290294,
      50.4528370352621,
      61.0669511294143,
      63.5947601234371,
      64.7947738152268,
      54.7617713917922,
      58.4831243399702,
      67.9960125410129,
      74.7511723175756,
      84.5114935902622,
      77.3874109416888,
      86.5688105828125,
      93.9780371496426,
      92.2499511031828,
      100.691440669832,
      101.982184923689,
      110.64079689443,
      109.919406234126,
      99.1353591086478,
      97.2158069607426,
      84.6449780423251,
      109.036187809224,
      107.928059885991,
      94.79051876429,
      71.5254324789998,
      80.7538914249952,
      66.1290982889183,
      58.1521055446482,
      88.3711471723476,
      81.7393780305578,
      89.9840732937923,
      96.7805866161355,
      95.4676175255399,
      79.6896101643277,
      75.5223237465439,
      67.2669334324647,
      69.6714781104545,
      77.5909902805928,
      83.6010418221605,
      73.2758615713817,
      91.4596204362897,
      85.3269322483237,
      92.8408420712777,
      99.05911932403,
      97.9648755410537,
      104.87425366824,
      105.644964810279,
      112.620610442409,
      112.213484783792,
      104.028577839989,
      103.077478976563,
      111.760570787508,
      111.244073433108,
      70.791765963822,
      61.7446037879117,
      64.6460873442911,
      119.999867994161,
      127.003519989442,
      127.379115210091,
      119.99984868102,
      112.996244613061,
      119.999888082525,
      133.63390142799,
      132.940300857016,
      139.90361480004,
      140.940712960388,
      134.354806567291,
      126.647145561306,
      135.125481040502,
      142.034921257722,
      143.219176885319,
      135.971122204028,
      127.78620361266,
      119.999830203971,
      128.239082154354,
      119.999812570319,
      106.365908392224,
      113.352659498385,
      100.096254810042,
      107.059548907842,
      119.99990884615,
      113.701470683787,
      119.999930151353,
      126.298376092054,
      151.628664257342,
      160.310266678956,
      153.430975227675,
      144.532115209353,
      150.015767038569,
      158.260522493914,
      169.208191086445,
      175.353973327052,
      178.255444676853,
      172.003931747319,
      162.612446432955,
      166.724113445342,
      155.488270466088,
      165.248670681479,
      157.885772360877,
      147.749729014179,
      146.021667682416,
      136.922188579346,
      138.01745241115,
      128.755545850576,
      148.540251562729,
      156.398885858534,
      147.159063882684,
      154.673025425532,
      164.477673487608,
      162.409032615975,
      170.328620985436,
      172.733144429618,
      160.73691028362,
      152.281142565568,
      149.798699791792,
      168.324939656844,
      171.981330899289,
      164.195612177234,
      142.783752265364,
      145.209017315277,
      132.071435008962,
      130.963338279975,
      140.864224337544,
      155.354650677375,
      139.308168687404,
      130.080150208414,
      129.35879035883,
      175.205164080654,
      178.932988224357,-178.483081983053,-174.761727682695,
      -176.654502597787,
      176.405083304587,-170.452782793881,-165.391470644593,
      -171.350431536296,
      168.474300479769,-178.152240357748,
      173.870648969763,
      159.245729702801,
      119.999729113674,
      119.999746968307,
      133.499179645309,
      106.500281077857,
      119.999763396625,
      119.999779437279,
      148.354253061038,
      164.289842514188,
      91.645260078256,
      75.7097781105788,
      55.8586695453022,
      48.0870830380979,
      53.4720837717296,
      61.1087247846571,
      63.7482975178481,
      58.3920218534306,
      40.4684783759449,
      45.9625713458806,
      33.0388184141447,
      38.6122712262135,
      51.1917686070945,
      43.9147499083591,
      48.9812747190438,
      56.1907096945716,
      58.601164359457,
      66.1154377884392,
      63.5081782843418,
      70.9108453930047,
      73.7101951398677,
      68.8428910608586,
      71.7225754334725,
      66.5587703851754,
      76.6476108373293,
      79.7506539120224,
      74.789612861283,
      61.1183354978463,
      69.5841641312683,
      64.091591924435,
      46.8069393997205,
      39.9022959492384,
      44.6370711141832,
      51.5359523863937,
      53.8454880155689,
      41.9064407445733,
      33.1632547572404,
      28.2914524803702,
      26.6286501229096,
      31.2601711922258,
      37.868007832027,
      34.9974353181071,
      42.4416974810342,
      35.7704758647215,
      40.19297625013,
      46.9153559132564,
      49.2344824838755,
      56.1241978630957,
      53.7240758027849,
      60.5998614634234,
      63.0902738349098,
      58.5388396530264,
      60.9917131851767,
      65.6243895241605,
      68.2236609032582,
      36.8011818718122,
      31.4559003118948,
      29.8864646909566,
      64.9888683151129,
      62.4859487375789,
      69.3151853253129,
      71.8706108058709,
      67.5262072078468,
      58.1328531485527,
      60.0001777345013,
      53.1931824725057,
      57.5144057006831,
      64.3303332782832,
      66.8071742382161,
      55.670021129826,
      73.6010867916328,
      71.1194535385818,
      77.8674400531625,
      80.368972739138,
      76.1450923936867,
      78.7658130925014,
      82.9640277199905,
      85.6638069746814,
      81.476088071561,
      74.4889817967187,
      70.115510218702,
      77.1854294945862,
      72.7747924471029,
      51.3164039710916,
      44.5550782152546,
      48.8809033562632,
      92.5558953690026,
      99.4360697213508,
      95.4846601422419,
      88.4773471397488,
      89.761865319694,
      96.5310590414184,
      106.301851818224,
      109.975389637387,
      113.154810992537,
      109.497480298104,
      102.492355053507,
      103.268169116827,
      98.5511422662772,
      105.697795169125,
      101.758256504284,
      94.4764186506133,
      91.412441271993,
      84.287806679584,
      87.2124605153302,
      79.9750445442033,
      87.0985422359652,
      93.7793635206694,
      84.5594465916798,
      91.1811074774834,
      100.404954470447,
      97.7207012229425,
      104.172872924826,
      106.975585056987,
      105.109247316721,
      108.607482672263,
      101.020136267993,
      97.6765763441217,
      109.051173644566,
      112.552381749107,
      112.255658090117,
      120.000372038807,
      116.054419314212,
      108.161704479764,
      104.513642004037,
      116.201996793465,
      96.7787570447097,
      100.268121440111,
      92.3775124171518,
      89.0584830069339,
      93.4465501317904,
      90.2615285163864,
      85.8956432531073,
      82.8731881501582,
      112.848312270489,
      116.349985383458,
      116.499731958842,
      120.000282837242,
      120.000330486495,
      123.650630760897,
      127.44828477691,
      123.798708715646,
      87.8057573026665,
      84.4990772529355,
      95.8670898989228,
      91.3046171733334,
      83.0482800177247,
      81.3639924552448,
      78.3789844714675,
      103.921624821475,
      99.538034117326,
      111.964964504935,
      107.740437063386,
      95.0132110221023,
      86.5701157782555,
      103.394115942409,
      98.9424552190803,
      90.3450435525556,
      78.0825840951267,
      81.6437796259082,
      72.8750146847381,-105.108185517537,-108.606400631719,
      -112.551299308406,-109.050113771212,-101.757219320261,-97.6755361364222,
      -101.01907399356,-112.254560400585,-108.16061115127,-116.053310760297,
      -119.999258816073,-116.200896477409,-104.512561977743,-119.99922929073,
      -123.79759264992,-127.447167665725,-123.64953040551,-116.348904161832,
      -112.847255766956,-119.999204425564,-116.498680232756,-109.4964528692,
      -105.696762253605,-98.5501338303696,-102.491353164249,-95.4836843255744,
      -91.4114574671268,-94.4754046623351,-90.2605099993221,-87.2114694888058,
      -82.872190712866,-85.8946212360714,-93.4455081436239,-96.7776957220652,
      -89.0574404560503,-92.3764534219358,-100.26704500172,-92.5549557598321,
      -89.7609652022964,-85.6628945345401,-88.4763972661064,-99.4351025865679,
      -96.5301300336519,-87.0976845700196,-91.1802633718154,-84.5586339919437,
      -80.3681445313407,-82.9631559386518,-93.778475646074,-78.7649269325825,
      -76.1442478826279,-71.8697496074296,-74.4880812257655,-81.4751634343793,
      -84.2868470099477,-77.18449294329,-79.9740756417028,-106.300857410405,
      -103.26721124852,-113.15379021341,-109.974403556396,-100.404036222489,
      -106.974636893959,-104.171965365794,-97.7198252436946,-64.9880304424547,
      -58.1320367585252,-60.5990042934745,-67.5253291962217,-69.3143666036843,
      -62.4851540135732,-51.3156071072882,-48.8801504830162,-44.554298878044,
      -46.9145349643698,-53.7232376577924,-55.6692483988584,-56.1233215203746,
      -49.2336228182529,-51.535057260054,-58.5379285253289,-63.0893791098424,
      -70.1145953922242,-65.6234607616756,-72.7738443896259,-73.600286782811,
      -66.8064007576942,-77.8666579868935,-71.1187005195997,-59.9994288005785,
      -64.3296074100853,-57.5137047770667,-53.1924558840445,-46.8060261461129,
      -48.9803325687351,-53.8445610067351,-44.6361904845526,-39.9013952344822,
      -41.9055102908084,-51.1908015559514,-45.9615932852274,-53.4710960030463,
      -58.6001853325832,-56.1897546515607,-43.9137935826827,-60.9907709630927,
      -63.5072088756506,-68.2227018570783,-42.4408528765129,-37.8671403827617,
      -40.1921707106588,-35.7696448291849,-33.162365646446,-34.9965157113832,
      -31.2593158075837,-26.6277719526927,-28.2905432353112,-36.8002354128232,
      -29.8855276765249,-31.4549392952915,-38.6113019200814,-55.8576653267436,
      -63.7472830448242,-61.1077259417907,-48.0860875482076,-58.3910054149329,
      -71.7215489565899,-74.7885754308549,-79.7496137019104,-76.6465848587223,
      -68.8418795054502,-66.5577443731155,-66.1144452470629,-73.709187415785,
      -70.9098599908389,-40.4674904954574,-33.0378375422609,-61.1173108936877,
      -64.090562883211,-69.5831304535947,-87.8047019338253,-84.4980353136164,
      -83.047229473757,-91.3035522877174,-95.8660185454503,-81.3629679568557,
      -78.3779814613272,-78.0815394507931,-86.5690585905079,-72.8739768677912,
      -81.642731174068,-95.0121403713361,-99.5369544407852,-90.3439831229333,
      -98.9413823320008,-103.393031878186,-103.920537532397,-107.739343196321,
      -111.963862427589,-64.1412135505286,-71.9127642848744,-66.52776895288,
      -58.8911641608976,-56.2516243771637,-61.6078902003859,-79.5313359197239,
      -74.0372474228809,-86.9609654170905,-81.3875156677116,-68.8080520484033,
      -76.0850382146063,-71.0185120595029,-63.8091096305504,-61.3986904839085,
      -53.8844531048191,-56.4916748846284,-49.0890431635545,-46.2897339883609,
      -51.1570366625699,-48.277388603924,-53.4411837361064,-43.3523585626756,
      -40.2493558956088,-45.2103874926485,-58.88160458119,-50.4158221022724,
      -55.908375949615,-73.192811740882,-80.0974250156558,-75.3626428153525,
      -68.4637913607931,-66.1542942660861,-78.0933147057137,-86.8364372929406,
      -91.7082446364904,-93.3710147788841,-88.7394862777094,-82.1316771785178,
      -85.0022901390231,-77.5579779796277,-84.2291721786358,-79.8066599162008,
      -73.0843070917823,-70.7652214061364,-63.8755350428146,-66.2756147363548,
      -59.399856955614,-56.9094884913253,-61.4609345615684,-59.0081011258437,
      -54.3754157882716,-51.7761864531444,-83.1985753270907,-88.5438567540574,
      -90.113263328022,-55.0108319544642,-57.5137047770667,-50.6844933145969,
      -48.1291161811374,-52.4735393355294,-61.8668205857027,-59.9994288005785,
      -66.8064007576942,-62.4851540135732,-55.6692483988584,-53.1924558840445,
      -64.3296074100853,-46.398567139477,-48.8801504830162,-42.132186725652,
      -39.6307053763395,-43.8546115967724,-41.2339410010575,-37.0357021224558,
      -34.3359750029528,-38.5237161678218,-45.5107932446741,-49.8842819837172,
      -42.8143932970649,-47.2250447824741,-68.6832434232027,-75.4445432933408,
      -71.1187005195997,-27.4439157934624,-20.5637725369443,-24.5152066090099,
      -31.5224874761553,-30.237891309809,-23.4687258546667,-13.6980241000992,
      -10.0244587268408,-6.84510180643638,-10.5024585245832,-17.5075462226961,
      -16.7316461395699,-21.4487812914056,-14.3021668958399,-18.2417252289625,
      -25.5235233797642,-28.5874466342623,-35.7120478353684,-32.7874445622044,
      -40.0248257807384,-32.9011607653153,-26.2203655171164,-35.4402035704789,
      -28.8185670370637,-19.5948022830634,-22.2789990318707,-15.8268549149317,
      -13.0242016719487,-14.8907940822762,-11.3926199516694,-18.979917275311,
      -22.3234208376132,-10.9488510429001,-7.44770738954449,-7.7445073098993,
      0.000148978925143669,-3.94581029847735,-11.8384659350107,-15.4864692576116,
      -3.79815853453078,-23.2213036757918,-19.7319932897632,-27.6225502805546,
      -30.9415306792109,-26.5534578017589,-29.7384276200592,-34.1043222485107,
      -37.1267296636149,-7.15169170407115,-3.65008591036533,-3.50024801647786,
      0.000233105604966819,
      0.000189880586895533,
      3.6505089576814,
      7.44808895799284,
      3.79849708490552,-32.1943020954046,-35.5009370515976,
      -24.1330229704541,-28.6954884939941,-36.9517708649911,-38.6359774761778,
      -41.6209413846694,-16.0785453148076,-20.4621303757089,-8.03526646614653,
      -12.2597899390794,-24.9869425335202,-33.4299774536258,-16.6061018110234,
      -21.0577482033466,-29.6550939469413,-41.9174532369346,-38.3562961382678,
      -47.125004350448,
      134.891435653857,
      130.949453848088,
      138.242393260911,
      142.324133323354,
      138.980600923127,
      131.393233538101,
      127.152259219575,
      134.302793562742,
      123.500783739477,
      130.503047133891,
      141.449474520117,
      137.508195463001,
      144.515924039112,
      148.588213366875,
      145.524263471222,
      149.739217051658,
      152.788262811242,
      157.127601095295,
      154.10516299913,
      146.554217483466,
      143.222032398384,
      135.487122572918,
      150.942339839178,
      147.623326637505,
      139.732689566422,
      127.745091162884,
      131.839087199024,
      123.946362513865,
      147.444656675435,
      143.46941743931,
      150.23865509143,
      154.336793048892,
      151.523280128845,
      140.564443334613,
      139.595447471059,
      133.024788541232,
      135.827456950937,
      142.279661600187,
      146.221077309773,
      136.732273330511,
      152.901947022512,
      148.819298575984,
      155.441011925239,
      159.631573047593,
      157.03654516016,
      161.234842264361,
      163.855539760152,
      168.130105289304,
      165.511753484635,
      158.524590179987,
      155.71289421473,
      162.815324325685,
      160.025727241844,
      133.698632509894,
      126.845655755257,
      130.025029635295,
      175.011911750157,-178.132008164879,
      179.40099749594,
      172.474589055593,
      170.685510866066,
      177.51481401296,-171.315495386349,
      -168.880009122003,-164.554109463204,-166.914375372166,-173.723154697009,
      -175.669191614244,-176.123266033658,-169.233492268865,-171.53495454535,
      -178.53789881054,
      176.910597664744,
      169.885301196271,
      174.376493175057,
      167.226033163609,
      166.399521792364,
      173.193501281298,
      162.133078627568,
      168.881131067056,-179.999433445547,
      175.670320790429,-177.513680990781,
      -173.192369916071,-166.805883025781,-168.980215694789,-173.844484481119,
      -164.636019486527,-159.901191067542,-161.905333722495,-171.190708873495,
      -165.961466475829,-173.471025117683,-178.600154668373,-176.189702258862,
      -163.913642944562,
      179.009235079317,
      176.492775944195,
      171.777231768272,
      -162.440652834527,-157.866907445163,-160.191940919625,-155.7693824537,
      -153.162107281751,-154.996285582956,-151.259028529299,-146.627467135695,
      -148.290266630268,-156.80003228487,-149.885278535134,-151.454716250336,
      -158.611124028568,-175.857613624155,
      176.252712281316,
      178.892285653734,
      -168.085982144837,-178.390970206639,
      168.278389207855,
      165.211353128713,
      160.250268627746,
      163.353305531271,
      171.158071239906,
      173.44223749229,
      173.885521078126,
      166.290714258828,
      169.090056141023,-160.467335640697,
      -153.037638671081,
      178.882710420902,
      175.909446881825,
      170.416840633427,
      152.195128112566,
      155.501797426251,
      156.952647989002,
      148.696278504908,
      144.133764996424,
      158.636870947479,
      161.621867045406,
      161.918382352487,
      153.430817090456,
      167.125985863925,
      158.35718649668,
      144.987694512048,
      140.462836256691,
      149.655893679628,
      141.058459819629,
      136.606769532722,
      136.079207417638,
      132.260415980818,
      128.035853809831,
      175.858629993421,
      168.086961397325,
      173.472049694172,-178.891229567123,-176.251662431813,
      178.391979124525,
      160.46827573697,
      165.962456548103,
      153.038539234787,
      158.612078074064,
      171.19174228012,
      163.914644601258,
      168.981258400542,
      176.190771806953,
      178.601217340968,-173.884432868447,-176.491682795326,
      -169.088943633982,-166.289605303227,-171.156987972731,-168.277310909735,
      -173.441193490792,-163.352200499653,-160.249167979702,-165.210279865214,
      -178.88170808621,-170.415802069405,-175.908450168927,
      166.806935326371,
      159.902217147677,
      164.637081489867,
      171.536038383088,
      173.845561116052,
      161.906347473193,
      153.163106260004,
      148.291220795416,
      146.628439087062,
      151.260042269884,
      157.86794580751,
      154.997269439184,
      162.441724454916,
      155.770432777454,
      160.193021883563,
      166.915473518221,
      169.234583316203,
      176.124373963186,
      173.724267452749,-179.399873212499,-176.909476052943,
      178.539001837859,-179.00813698784,-174.375374394125,-171.77611600678,
      156.801001037114,
      151.455634240089,
      149.886214549119,-175.010778998743,
      -177.513680990781,-170.684377535396,-168.128970279526,-172.473456790676,
      178.133134972081,-179.999433445547,
      173.193501281298,
      177.51481401296,
      -175.669191614244,-173.192369916071,
      175.670320790429,-166.398395629704,
      -168.880009122003,-162.131967095912,-159.630455463257,-163.854409746724,
      -161.233708869932,-157.035422105057,-154.335665227975,-158.523453992722,
      -165.510617164429,-169.884169686037,-162.814187165396,-167.224902748413,
      171.31661283641,
      164.555214476835,
      168.881131067056,-147.443538356396,
      -144.514800998567,-151.52214838135,-150.237542575141,-143.468318908531,
      -140.563338299113,-141.44834797956,-134.301679457349,-138.241264588268,
      -145.523126984382,-148.587078678759,-137.507085195887,-155.711755956962,
      -152.787123352908,-160.024589830998,-152.900841261568,-146.21998645108,
      -155.439913754016,-148.818216467536,-139.594374407337,-136.731192031727,
      -142.278598030361,-135.826414217087,-133.023735973083,-133.697544280219,
      -130.023968554526,-126.844587489903,-130.50195335354,-134.890306360375,
      -138.979464892636,-142.32299633818,-130.94833742249,-131.392105264852,
      -143.220896122738,-139.731557115694,-147.622196890014,-150.941206586885,
      -146.553078860557,-135.485989088053,-149.738077418868,-154.104027397902,
      -157.126464156644,-127.151161364473,-123.499709671659,-127.743965657373,
      -123.945241597269,-131.837957964939,-152.194011856709,-155.500676788974,
      -144.132640045588,-148.695167652671,-156.95155228018,-158.635746827383,
      -161.620740215301,-136.078080388218,-140.461717513148,-128.034730611941,
      -132.259296054275,-144.986590198127,-153.429726977381,-136.605658494382,
      -141.057363263382,-149.654809915742,-161.917314242661,-158.356123724361,
      -167.12495232328,
      14.8911810821931,
      10.9492775782817,
      18.2421587525311,
      22.3238169192504,
      18.9802670683227,
      11.3929622408326,
      7.15215959239805,
      14.3026398185291,
      3.50075851980503,
      10.5029722504893,
      21.4492626132048,
      17.5080663916805,
      24.5157364366998,
      28.5879397272245,
      25.5239674111918,
      29.738836467869,
      32.7879026394772,
      37.1271549916939,
      34.1046985343908,
      26.5538189094528,
      23.2216190514975,
      15.486774927518,
      30.941859750675,
      27.6228344409742,
      19.7322654019128,
      7.7448071911007,
      11.8387300908237,
      3.94607050099561,
      27.4444942619762,
      23.4693408264933,
      30.2385179979623,
      34.3365672525671,
      31.5230301678637,
      20.5643402404798,
      19.5954538595425,
      13.0248460787441,
      15.8275425412833,
      22.279694966155,
      26.2210269756977,
      16.7322522493758,
      32.9018347300898,
      28.819273739084,
      35.4409233899704,
      39.6313944032216,
      37.036343327398,
      41.2345500064697,
      43.8552700639413,
      48.129744856501,
      45.511371172092,
      38.5242749071218,
      35.7125560706934,
      42.8149200258502,
      40.0253014467382,
      13.69858408676,
      6.84565715048793,
      10.0250588847341,
      55.0114831198552,
      61.8674969163098,
      59.4004823195393,
      52.4741395138954,
      50.6851717210951,
      57.5144057006831,
      68.6839473801166,
      71.1194535385817,
      75.4452770364899,
      73.0849907599979,
      66.2762680242786,
      64.3303332782832,
      63.8761365668243,
      70.7658537226704,
      68.4643715662439,
      61.4614837768098,
      56.9100619992523,
      49.8848305039762,
      54.3759371225252,
      47.225541556802,
      46.3992737283633,
      53.1931824725057,
      42.1329219482969,
      48.8809033562632,
      60.0001777345013,
      55.6700211298259,
      62.4859487375788,
      66.807174238216,
      73.1933737569328,
      71.0190221999852,
      66.1548221503029,
      75.3632568076776,
      80.0980239669642,
      78.0938623198491,
      68.8085109565083,
      74.0376940069783,
      66.5281777892694,
      61.3991153364862,
      63.8095855463368,
      76.0855348680324,
      59.0085980607321,
      56.4921201435542,
      51.776655882579,
      77.558643510339,
      82.1323273216357,
      79.8073760355286,
      84.2298728695395,
      86.8370754670265,
      85.002878022854,
      88.7401743637317,
      93.3716937929823,
      91.7088749837979,
      83.1991130276431,
      90.1138448422244,
      88.5443897519004,
      81.388003796621,
      64.141573937956,
      56.2519518147223,
      58.8915393703408,
      71.9131621642991,
      61.6082041405607,
      48.2776877560648,
      45.2106423700219,
      40.2496314343639,
      43.3526795257379,
      51.1573825553255,
      53.4414656388029,
      53.884847846805,
      46.2901027067199,
      49.0894615373314,
      79.5317755723491,
      86.9614507077971,
      58.8818743496068,
      55.9086039764232,
      50.4160609731328,
      32.1945586142764,
      35.5012374610266,
      36.9520036615347,
      28.6957039997946,
      24.1332649301647,
      38.6363243093901,
      41.621336754897,
      41.9176665718396,
      33.4301704602486,
      47.1252028542957,
      38.3564708429273,
      24.9871201747822,
      20.462333178517,
      29.6552503159176,
      21.0578913397218,
      16.6062687638052,
      16.078777022721,
      12.259984418859,
      8.03549208904175,
      14.8911810821931,
      10.9492775782817,
      7.44808895799285,
      11.3929622408326,
      18.9802670683227,
      22.3238169192504,
      18.2421587525311,
      7.15215959239806,
      10.5029722504893,
      3.50075851980503,
      0.000233105604975139,
      3.65050895768141,
      14.3026398185291,
      0.00018988058690236,-3.65008591036532,-7.44770738954449,-3.79815853453077,
      3.79849708490553,
      7.74480719110071,
      0.000148978925151522,
      3.94607050099561,
      11.8387300908237,
      15.486774927518,
      23.2216190514975,
      19.7322654019128,
      27.6228344409742,
      30.941859750675,
      26.5538189094528,
      29.738836467869,
      34.1046985343908,
      37.1271549916939,
      32.7879026394772,
      25.5239674111919,
      21.4492626132048,
      28.5879397272245,
      24.5157364366998,
      17.5080663916805,
      32.1945586142764,
      36.9520036615347,
      40.2496314343639,
      35.5012374610267,
      24.1332649301647,
      28.6957039997946,
      41.9176665718397,
      38.3564708429273,
      47.1252028542957,
      50.4160609731328,
      45.210642370022,
      33.4301704602486,
      48.2776877560648,
      53.4414656388029,
      56.2519518147223,
      51.1573825553255,
      43.3526795257379,
      38.6363243093901,
      46.2901027067199,
      41.621336754897,
      16.078777022721,
      20.462333178517,
      8.03549208904176,
      12.259984418859,
      24.9871201747822,
      16.6062687638052,
      21.0578913397218,
      29.6552503159176,
      64.141573937956,
      71.9131621642991,
      66.5281777892694,
      58.8915393703409,
      61.6082041405607,
      69.6714781104545,
      79.5317755723491,
      85.3269322483236,
      86.9614507077971,
      81.388003796621,
      74.0376940069783,
      77.5909902805928,
      68.8085109565083,
      76.0855348680324,
      71.0190221999852,
      63.8095855463368,
      61.3991153364862,
      53.884847846805,
      56.4921201435542,
      49.0894615373314,
      58.8818743496068,
      67.2669334324647,
      55.9086039764232,
      64.6460873442912,
      75.5223237465439,
      73.2758615713817,
      81.7393780305578,
      83.6010418221605,
      73.1933737569328,
      68.4643715662439,
      66.1548221503029,
      78.0938623198491,
      80.0980239669642,
      75.3632568076776,
      63.8761365668243,
      66.2762680242786,
      59.4004823195394,
      56.9100619992523,
      61.4614837768098,
      70.7658537226704,
      59.0085980607321,
      54.3759371225252,
      51.776655882579,
      83.1991130276431,
      85.002878022854,
      88.5443897519003,
      90.1138448422244,
      86.8370754670265,
      82.1323273216357,
      91.7088749837979,
      93.3716937929823,
      88.7401743637317,
      77.558643510339,
      84.2298728695395,
      79.8073760355286,
      73.0849907599979,
      55.0114831198553,
      48.1297448565011,
      52.4741395138955,
      61.8674969163098,
      50.6851717210951,
      41.2345500064697,
      37.036343327398,
      34.3365672525671,
      38.5242749071218,
      45.511371172092,
      43.8552700639413,
      49.8848305039762,
      42.8149200258503,
      47.225541556802,
      68.6839473801166,
      75.4452770364899,
      46.3992737283633,
      42.132921948297,
      39.6313944032216,
      27.4444942619763,
      31.5230301678638,
      30.2385179979623,
      23.4693408264933,
      20.5643402404798,
      35.7125560706934,
      40.0253014467382,
      32.9018347300898,
      26.2210269756977,
      35.4409233899704,
      28.819273739084,
      19.5954538595425,
      16.7322522493758,
      22.279694966155,
      15.8275425412833,
      13.0248460787441,
      13.69858408676,
      10.0250588847341,
      6.84565715048794,-55.0108319544642,-61.8668205857027,
      -59.399856955614,-52.4735393355294,-48.1291161811373,-50.6844933145968,
      -68.6832434232027,-66.2756147363548,-75.4445432933408,-73.0843070917823,
      -63.8755350428146,-70.7652214061363,-68.4637913607931,-61.4609345615684,
      -56.9094884913253,-49.8842819837172,-54.3754157882716,-47.2250447824741,
      -42.8143932970649,-45.510793244674,-41.2339410010575,-43.8546115967724,
      -38.5237161678218,-34.3359750029528,-37.0357021224558,-46.398567139477,
      -39.6307053763394,-42.132186725652,-73.192811740882,-80.0974250156558,
      -78.0933147057137,-71.0185120595029,-66.1542942660861,-75.3626428153525,
      -86.8364372929406,-88.7394862777094,-93.3710147788841,-91.7082446364904,
      -85.0022901390231,-82.1316771785178,-83.1985753270907,-90.113263328022,
      -88.5438567540574,-81.3875156677116,-76.0850382146063,-68.8080520484032,
      -74.0372474228809,-66.52776895288,-61.3986904839085,-63.8091096305504,
      -59.0081011258437,-56.4916748846284,-51.7761864531443,-77.5579779796277,
      -79.8066599162008,-84.2291721786358,-64.1412135505286,-69.6711271732802,
      -61.6078902003859,-56.2516243771636,-58.8911641608976,-71.9127642848744,
      -75.5219761704256,-83.6006477978237,-81.739026956523,-73.2755570774994,
      -67.26662738237,-77.5905975868108,-58.88160458119,-64.6458239615063,
      -55.908375949615,-50.4158221022724,-53.4411837361064,-48.277388603924,
      -45.2103874926485,-40.2493558956088,-43.3523585626756,-51.1570366625699,
      -53.8844531048191,-46.2897339883609,-49.0890431635545,-79.5313359197239,
      -86.9609654170905,-85.3264934041261,-32.1943020954046,-27.6225502805546,
      -35.5009370515975,-36.9517708649911,-28.6954884939941,-24.1330229704541,
      -23.2213036757918,-15.4864692576116,-18.979917275311,-26.5534578017589,
      -30.9415306792109,-19.7319932897632,-38.6359774761778,-34.1043222485107,
      -41.6209413846694,-41.9174532369346,-33.4299774536258,-47.125004350448,
      -38.3562961382678,-24.9869425335202,-20.4621303757089,-29.6550939469413,
      -21.0577482033466,-16.6061018110234,-16.0785453148076,-12.2597899390794,
      -8.03526646614653,-11.8384659350107,-14.8907940822762,-18.2417252289625,
      -22.3234208376132,-11.3926199516694,-10.9488510429001,-21.4487812914056,
      -17.5075462226961,-24.5152066090099,-28.5874466342623,-25.5235233797642,
      -14.3021668958399,-29.7384276200592,-32.7874445622044,-37.1267296636149,
      -7.74450730989929,-3.94581029847734,-7.15169170407115,-3.50024801647785,
      -10.5024585245832,-27.4439157934624,-31.5224874761553,-20.5637725369443,
      -23.4687258546667,-30.237891309809,-35.7120478353684,-40.0248257807384,
      -13.6980241000992,-16.7316461395699,-6.84510180643637,-10.0244587268408,
      -19.5948022830634,-26.2203655171164,-13.0242016719487,-15.8268549149317,
      -22.2789990318707,-32.9011607653153,-28.8185670370637,-35.4402035704789,
      -105.108185517537,-109.050113771212,-112.551299308406,-108.606400631719,
      -101.01907399356,-97.6755361364222,-101.757219320261,-112.847255766956,
      -109.4964528692,-116.498680232756,-119.999204425564,-116.348904161832,
      -105.696762253606,-119.99922929073,-123.64953040551,-127.447167665725,
      -123.79759264992,-116.200896477409,-112.254560400585,-119.999258816073,
      -116.053310760297,-108.16061115127,-104.512561977743,-96.7776957220652,
      -100.26704500172,-92.3764534219358,-89.0574404560503,-93.4455081436239,
      -90.2605099993221,-85.8946212360714,-82.872190712866,-87.2114694888058,
      -94.4754046623351,-98.5501338303696,-91.4114574671269,-95.4836843255744,
      -102.491353164249,-87.8047019338253,-83.047229473757,-79.7496137019104,
      -84.4980353136164,-95.8660185454504,-91.3035522877174,-78.0815394507931,
      -81.642731174068,-72.8739768677912,-69.5831304535947,-74.7885754308549,
      -86.5690585905079,-71.7215489565899,-66.5577443731155,-63.7472830448242,
      -68.8418795054502,-76.6465848587223,-81.3629679568557,-73.709187415785,
      -78.3779814613273,-103.920537532397,-99.5369544407853,-111.963862427589,
      -107.739343196321,-95.0121403713362,-103.393031878186,-98.9413823320008,
      -90.3439831229333,-55.8576653267436,-48.0860875482076,-53.4710960030463,
      -61.1077259417907,-58.3910054149329,-50.3277381473105,-40.4674904954575,
      -34.6723183033218,-33.037837542261,-38.6113019200814,-45.9615932852275,
      -42.4082396889517,-51.1908015559514,-43.9137935826827,-48.9803325687351,
      -56.1897546515608,-58.6001853325833,-66.1144452470629,-63.5072088756506,
      -70.9098599908389,-61.1173108936877,-52.7322539838871,-64.090562883211,
      -55.3530762640055,-44.4768740839827,-46.7233083967129,-38.259807725422,
      -36.398174482981,-46.806026146113,-51.535057260054,-53.8445610067351,
      -41.9055102908084,-39.9013952344822,-44.6361904845527,-56.1233215203746,
      -53.7232376577924,-60.5990042934745,-63.0893791098424,-58.5379285253289,
      -49.233622818253,-60.9907709630927,-65.6234607616756,-68.2227018570783,
      -36.8002354128232,-34.9965157113832,-31.4549392952915,-29.8855276765249,
      -33.162365646446,-37.8671403827617,-28.2905432353112,-26.6277719526928,
      -31.2593158075837,-42.4408528765129,-35.7696448291849,-40.1921707106588,
      -46.9145349643698,-64.9880304424547,-71.8697496074296,-67.5253291962217,
      -58.1320367585252,-69.3143666036843,-78.7649269325825,-82.9631559386518,
      -85.6628945345401,-81.4751634343793,-74.4880812257655,-76.1442478826279,
      -70.1145953922242,-77.18449294329,-72.7738443896258,-51.3156071072882,
      -44.554298878044,-73.600286782811,-77.8666579868935,-80.3681445313407,
      -92.5549557598321,-88.4763972661064,-89.7609652022964,-96.5301300336519,
      -99.4351025865679,-84.2868470099477,-79.9740756417028,-87.0976845700196,
      -93.778475646074,-84.5586339919437,-91.1802633718154,-100.404036222489,
      -103.26721124852,-97.7198252436946,-104.171965365794,-106.974636893959,
      -106.300857410405,-109.974403556396,-113.15379021341,-175.010778998743,
      178.133134972081,-179.399873212499,-172.473456790676,-168.128970279526,
      -170.684377535396,
      171.31661283641,
      173.724267452749,
      164.555214476835,
      166.915473518221,
      176.124373963186,
      169.234583316203,
      171.536038383088,
      178.539001837859,-176.909476052943,-169.884169686037,-174.375374394125,
      -167.224902748413,-162.814187165396,-165.510617164429,-161.233708869932,
      -163.854409746724,-158.523453992722,-154.335665227975,-157.035422105057,
      -166.398395629704,-159.630455463257,-162.131967095912,
      166.806935326371,
      161.906347473193,
      168.981258400542,
      173.845561116052,
      164.637081489867,
      159.902217147677,
      156.801001037114,
      149.886214549118,
      151.455634240089,
      158.612078074064,
      163.914644601258,
      154.997269439184,
      171.19174228012,
      165.962456548103,
      173.472049694172,
      178.601217340968,
      176.190771806953,
      -179.00813698784,-176.491682795326,-171.77611600678,
      162.441724454916,
      157.867945807509,
      160.193021883563,
      155.770432777454,
      153.163106260004,
      151.260042269884,
      146.628439087062,
      148.291220795416,
      175.858629993421,
      170.328620985436,
      178.391979124525,-176.251662431813,-178.891229567123,
      168.086961397325,
      164.477673487608,
      156.398885858534,
      158.260522493914,
      166.724113445342,
      172.733144429618,
      162.409032615975,-178.88170808621,
      175.353973327052,-175.908450168927,-170.415802069405,-173.441193490792,
      -168.277310909735,-165.210279865214,-160.249167979702,-163.352200499653,
      -171.156987972731,-173.884432868447,-166.289605303227,-169.088943633982,
      160.46827573697,
      153.038539234787,
      154.673025425532,-152.194011856709,
      -147.622196890014,-155.500676788974,-156.95155228018,-148.695167652671,
      -144.132640045588,-143.220896122738,-135.485989088053,-138.979464892636,
      -146.553078860557,-150.941206586885,-139.731557115694,-158.635746827383,
      -154.104027397902,-161.620740215301,-161.917314242661,-153.429726977381,
      -167.12495232328,-158.356123724361,-144.986590198127,-140.461717513148,
      -149.654809915742,-141.057363263382,-136.605658494382,-136.078080388218,
      -132.259296054275,-128.034730611941,-131.837957964939,-134.890306360375,
      -138.241264588268,-142.32299633818,-131.392105264852,-130.94833742249,
      -141.44834797956,-137.507085195887,-144.514800998567,-148.587078678759,
      -145.523126984382,-134.301679457349,-149.738077418869,-152.787123352908,
      -157.126464156644,-127.743965657373,-123.945241597269,-127.151161364473,
      -123.499709671659,-130.50195335354,-147.443538356396,-151.52214838135,
      -140.563338299113,-143.468318908531,-150.237542575141,-155.711755956962,
      -160.024589830998,-133.697544280219,-136.731192031727,-126.844587489903,
      -130.023968554526,-139.594374407337,-146.21998645108,-133.023735973083,
      -135.826414217087,-142.278598030361,-152.900841261568,-148.818216467536,
      -155.439913754016,
      134.891435653857,
      130.949453848088,
      127.44828477691,
      131.393233538101,
      138.980600923127,
      142.324133323354,
      138.242393260911,
      127.152259219575,
      130.503047133891,
      123.500783739477,
      120.000282837242,
      123.650630760897,
      134.302793562742,
      120.000330486496,
      116.349985383458,
      112.552381749107,
      116.201996793465,
      123.798708715646,
      127.745091162884,
      120.000372038807,
      123.946362513865,
      131.839087199024,
      135.487122572918,
      143.222032398384,
      139.732689566422,
      147.623326637505,
      150.942339839178,
      146.554217483466,
      149.739217051658,
      154.10516299913,
      157.127601095295,
      152.788262811242,
      145.524263471222,
      141.449474520117,
      148.588213366875,
      144.515924039112,
      137.508195463001,
      152.195128112566,
      156.952647989002,
      160.250268627746,
      155.501797426251,
      144.133764996424,
      148.696278504908,
      161.918382352487,
      158.35718649668,
      167.125985863925,
      170.416840633427,
      165.211353128714,
      153.430817090456,
      168.278389207855,
      173.44223749229,
      176.252712281316,
      171.158071239906,
      163.353305531271,
      158.636870947479,
      166.290714258828,
      161.621867045406,
      136.079207417638,
      140.462836256691,
      128.035853809831,
      132.260415980818,
      144.987694512048,
      136.606769532722,
      141.058459819629,
      149.655893679628,-175.857613624155,-168.085982144837,
      -173.471025117683,
      178.892285653734,-178.390970206639,-170.327651556387,
      -160.467335640697,-154.672141254983,-153.037638671081,-158.611124028568,
      -165.961466475829,-162.408105378998,-171.190708873494,-163.913642944562,
      -168.980215694789,-176.189702258862,-178.600154668373,
      173.885521078126,
      176.492775944195,
      169.090056141023,
      178.882710420903,-172.732183619018,
      175.909446881825,-175.353019741254,-164.476757716493,-166.723207467795,
      -158.259666466994,-156.398016653373,-166.805883025781,-171.53495454535,
      -173.844484481119,-161.905333722495,-159.901191067542,-164.636019486527,
      -176.123266033658,-173.723154697009,
      179.40099749594,
      176.910597664744,
      -178.53789881054,-169.233492268865,
      179.009235079317,
      174.376493175057,
      171.777231768272,-156.80003228487,-154.996285582956,-151.454716250336,
      -149.885278535134,-153.162107281751,-157.866907445163,-148.290266630268,
      -146.627467135695,-151.259028529299,-162.440652834527,-155.7693824537,
      -160.191940919625,-166.914375372166,
      175.011911750157,
      168.130105289304,
      172.474589055593,-178.132008164879,
      170.685510866066,
      161.234842264361,
      157.03654516016,
      154.336793048893,
      158.524590179987,
      165.511753484635,
      163.855539760152,
      169.885301196271,
      162.815324325685,
      167.226033163609,
      -171.315495386349,-164.554109463204,
      166.399521792364,
      162.133078627568,
      159.631573047593,
      147.444656675435,
      151.523280128845,
      150.23865509143,
      143.46941743931,
      140.564443334613,
      155.71289421473,
      160.025727241844,
      152.901947022512,
      146.221077309773,
      155.441011925239,
      148.819298575984,
      139.595447471059,
      136.732273330511,
      142.279661600187,
      135.827456950937,
      133.024788541232,
      133.698632509894,
      130.025029635295,
      126.845655755257,
      64.9888683151129,
      58.1328531485527,
      60.5998614634234,
      67.5262072078468,
      71.8706108058709,
      69.3151853253129,
      51.3164039710916,
      53.7240758027849,
      44.5550782152546,
      46.9153559132564,
      56.1241978630957,
      49.2344824838755,
      51.5359523863937,
      58.5388396530264,
      63.0902738349098,
      70.115510218702,
      65.6243895241606,
      72.7747924471029,
      77.1854294945862,
      74.4889817967187,
      78.7658130925014,
      76.1450923936867,
      81.476088071561,
      85.6638069746814,
      82.9640277199905,
      73.6010867916328,
      80.368972739138,
      77.8674400531625,
      46.8069393997205,
      41.9064407445733,
      48.9812747190438,
      53.8454880155689,
      44.6370711141832,
      39.9022959492384,
      36.8011818718122,
      29.8864646909566,
      31.4559003118948,
      38.6122712262135,
      43.9147499083591,
      34.9974353181071,
      51.1917686070945,
      45.9625713458806,
      53.4720837717295,
      58.601164359457,
      56.1907096945716,
      60.9917131851767,
      63.5081782843418,
      68.2236609032582,
      42.4416974810342,
      37.868007832027,
      40.19297625013,
      35.7704758647215,
      33.1632547572404,
      31.2601711922258,
      26.6286501229095,
      28.2914524803702,
      55.8586695453022,
      50.3287467185907,
      58.3920218534306,
      63.7482975178481,
      61.1087247846571,
      48.0870830380979,
      44.477885887353,
      36.3991817667869,
      38.2608215554296,
      46.7243257511218,
      52.7332713945556,
      42.4092417306679,
      61.1183354978463,
      55.3540985431576,
      64.0915919244349,
      69.5841641312683,
      66.5587703851754,
      71.7225754334725,
      74.789612861283,
      79.7506539120223,
      76.6476108373293,
      68.8428910608586,
      66.1154377884392,
      73.7101951398677,
      70.9108453930047,
      40.4684783759449,
      33.0388184141447,
      34.673314629703,
      87.8057573026665,
      92.3775124171518,
      84.4990772529355,
      83.0482800177247,
      91.3046171733334,
      95.8670898989228,
      96.7787570447097,
      104.513642004037,
      101.020136267993,
      93.4465501317904,
      89.058483006934,
      100.268121440111,
      81.3639924552448,
      85.8956432531073,
      78.3789844714675,
      78.0825840951267,
      86.5701157782555,
      72.8750146847381,
      81.6437796259082,
      95.0132110221023,
      99.5380341173259,
      90.3450435525556,
      98.9424552190803,
      103.394115942409,
      103.921624821475,
      107.740437063386,
      111.964964504935,
      108.161704479764,
      105.109247316721,
      101.758256504284,
      97.6765763441217,
      108.607482672263,
      109.051173644566,
      98.5511422662772,
      102.492355053507,
      95.4846601422419,
      91.412441271993,
      94.4764186506133,
      105.697795169125,
      90.2615285163864,
      87.2124605153302,
      82.8731881501582,
      112.255658090117,
      116.054419314212,
      112.848312270489,
      116.499731958842,
      109.497480298104,
      92.5558953690026,
      88.4773471397488,
      99.4360697213508,
      96.5310590414183,
      89.761865319694,
      84.287806679584,
      79.9750445442033,
      106.301851818224,
      103.268169116827,
      113.154810992536,
      109.975389637387,
      100.404954470447,
      93.7793635206694,
      106.975585056987,
      104.172872924826,
      97.7207012229425,
      87.0985422359652,
      91.1811074774834,
      84.5594465916798,
      88.3711471723476,
      79.6896101643277,
      86.5688105828125,
      95.4676175255399,
      96.7805866161354,
      89.9840732937923,
      70.791765963822,
      77.3874109416888,
      61.7446037879116,
      67.9960125410129,
      84.5114935902622,
      74.7511723175756,
      82.1139744887978,
      92.2499511031828,
      93.9780371496426,
      103.077478976563,
      101.982184923689,
      111.244073433108,
      111.760570787508,
      104.028577839989,
      104.87425366824,
      97.9648755410537,
      112.213484783792,
      112.620610442409,
      105.644964810279,
      91.4596204362897,
      99.0591193240299,
      92.8408420712777,
      79.262824765657,
      68.0185033863416,
      75.8041176552608,
      87.7184990487968,
      90.2009591281674,
      71.6748951609939,
      56.6544532161907,
      50.4528370352621,
      45.3915468290294,
      51.3504058814636,
      63.5947601234372,
      61.0669511294143,
      71.5254324789998,
      58.1521055446483,
      66.1290982889183,
      80.7538914249952,
      84.6449780423251,
      97.2158069607426,
      94.79051876429,
      107.928059885991,
      109.036187809224,
      99.1353591086478,
      100.691440669832,
      109.919406234126,
      110.64079689443,
      64.7947738152268,
      58.4831243399703,
      54.7617713917922,
      119.999729113674,
      119.999708089947,
      133.499179645309,
      132.071435008962,
      119.999746968307,
      106.500281077857,
      119.999680886386,
      101.984778709229,
      119.999641991352,
      138.014588355916,
      135.396189160726,
      104.603230906758,
      148.354253061038,
      152.557626681089,
      164.289842514188,
      159.245729702801,
      145.209017315277,
      142.783752265364,
      155.354650677375,
      152.281142565568,
      140.864224337544,
      130.963338279975,
      119.999763396625,
      130.080150208414,
      119.999779437279,
      91.6452600782561,
      75.7097781105788,
      87.4418627509767,
      160.73691028362,
      157.885772360877,
      149.798699791792,
      164.195612177234,
      171.981330899289,
      168.324939656844,
      155.488270466088,
      162.612446432955,
      153.430975227675,
      146.021667682416,
      147.749729014179,
      165.248670681479,
      139.308168687404,
      138.01745241115,
      129.35879035883,
      168.474300479769,
      176.405083304587,
      173.870648969763,
      -178.152240357748,-176.654502597787,
      178.932988224357,-171.350431536296,
      -165.391470644593,-170.452782793881,
      175.205164080654,-174.761727682695,
      -178.483081983053,
      172.003931747319,
      151.628664257342,
      143.219176885319,
      144.532115209353,
      160.310266678956,
      150.015767038569,
      135.125481040502,
      134.354806567291,
      127.379115210091,
      127.78620361266,
      135.971122204028,
      142.034921257722,
      136.922188579346,
      128.239082154354,
      128.755545850576,
      169.208191086445,
      178.255444676853,
      148.540251562729,
      147.159063882684,
      140.940712960388,
      119.999867994161,
      119.99984868102,
      127.003519989442,
      119.999888082525,
      112.996244613061,
      119.999830203971,
      119.999812570319,
      133.63390142799,
      126.647145561306,
      139.90361480004,
      132.940300857016,
      119.99990884615,
      113.352659498385,
      126.298376092054,
      119.999930151353,
      113.701470683787,
      106.365908392224,
      107.059548907842,
      100.096254810042,
      -151.627873308444,-160.309421709695,-153.430196795783,-144.531393798521,
      -143.218438430552,-150.014961073227,-169.207292968144,-162.611610079153,
      -178.254496748847,-172.003039298251,-155.487501700123,-165.247840172161,
      -157.885010037007,-147.749033117467,-146.020960567671,-136.921540162485,
      -138.01682051433,-128.754972730195,-128.23848714774,-135.970454466123,
      -135.124791444424,-142.034163353196,-127.785584226831,-127.378469156932,
      -134.354092896102,-148.539428441102,-140.939933578967,-147.158221853154,
      -160.736150742543,-171.98050225976,-164.194851200212,-152.280458366673,
      -149.798011679711,-168.324111860364,
      176.655393908885,
      170.453724765638,
      165.392414823949,
      171.351328804889,-176.404249739162,-178.93209947638,
      -168.473533071935,
      178.153083605432,-173.869869001389,-159.245038911567,
      -155.353965904758,-142.783150767046,-145.20841849934,-132.070923571755,
      -130.96281519471,-140.863616158859,-139.307550279961,-130.079613030466,
      -129.358236521798,-175.20427484892,
      178.484025983766,
      174.762669645501,
      -119.999314306296,-106.49996710335,-107.927717120091,-119.999313031197,
      -133.498677565354,-119.999313417216,-91.6450464227269,-87.4416988662312,
      -75.7096571022458,-80.7537225352479,-94.790265885463,-104.602951438291,
      -97.2155204885024,-84.6447691132295,-87.7182543771806,-99.1350416603998,
      -109.035818757024,-119.999309938664,-109.919011461922,-119.99930519035,
      -148.353652112907,-135.39569425213,-164.28913865615,-152.557017161569,
      -119.999309658622,-138.014098253048,-119.999301607951,-101.984545117919,
      -79.2626093377183,-82.1137235507762,-90.2006806341354,-75.8039386324641,
      -68.0183430554596,-71.6746983951915,-84.5112068351294,-77.38713999536,
      -86.5684868944844,-93.9776909308892,-92.2496391116094,-74.7509389576444,
      -100.691092953353,-101.981806421331,-110.64037575764,-71.5252924584181,
      -63.5946372087315,-66.1290021952876,-58.1520224770441,-56.6543386050819,
      -61.0668005302341,-51.3503277458204,-45.391467799753,-50.4527239194402,
      -64.7945868518441,-54.7616232308519,-58.4829396992172,-67.9957881229403,
      -88.3707849400777,-96.7801674114787,-95.4672356888098,-79.6893000837417,
      -89.9836706702997,-104.873773603347,-105.6444471719,-112.620066712727,
      -112.212974682726,-104.028133472587,-97.9644171021679,-103.077068402946,
      -111.760092298829,-111.243624535276,-70.7915024774077,-61.7443808317433,
      -91.4591755537532,-92.8403532222026,-99.0586198690578,-119.999258976441,
      -119.999270915529,-112.995665412536,-119.999246068707,-127.002845285256,
      -119.999281642097,-119.999290990475,-106.365351507588,-113.352043306848,
      -100.095712808109,-107.058951455197,-119.999232521394,-126.646440629693,
      -113.700816433847,-119.999218749243,-126.297639870184,-133.633161856195,
      -132.939534032698,-139.902812347273,-31.6280348495245,-40.3095488545864,
      -33.4303460814994,-24.531571247407,-23.2186283335487,-30.0151373349126,
      -49.2073806386185,-42.6117251311044,-58.2545414090462,-52.0031153358012,
      -35.4876406694835,-45.2479444645147,-37.8851398473661,-27.7491926861861,
      -26.021128098075,-16.9217292129126,-18.0170023168162,-8.75516884116102,
      -8.23869055435171,-15.9706534189784,-15.1250033200463,-22.0343685754905,
      -7.78579808587568,-7.37869680466754,-14.3543208478051,-28.5396221587692,
      -20.9401570686018,-27.1584357853379,-40.7362715305168,-51.9805851435915,
      -44.1949618906488,-32.2806043683773,-29.7981644211831,-48.3242058021675,
      -63.3446483828354,-69.5462893815484,-74.607588041054,-68.6486993065212,
      -56.4043196613113,-58.9321538339761,-48.4736313045335,-61.8469704294649,
      -53.8699513293002,-39.2451667247332,-35.3541040286466,-22.7833197533558,
      -25.2085828791813,-12.0711112883205,-10.9630034480084,-20.8637888371826,
      -19.3077268951693,-10.079802252885,-9.35842810252392,-55.2043401028468,
      -61.5160081928496,-65.2373546543017,
      0.000487622065641145,
      0.000488367763429842,
      13.4998393988643,
      12.0720890957447,
      0.000490239350133522,-13.4988640674432,
      0.000495108380598912,-18.0142754528685,
      0.000512229476121475,
      18.0152781946159,
      15.3968592247511,-15.3958776428048,
      28.354787844149,
      32.5581537152742,
      44.2902355495537,
      39.2461461336859,
      25.2095602740289,
      22.7843023689615,
      35.3550864282912,
      32.2815934838587,
      20.8647795788933,
      10.9639884169595,
      0.000494476284785397,
      10.0807962337081,
      0.000499095685893089,
      -28.3538097529457,-44.28925262776,-32.5571648987345,
      40.7372682857322,
      37.8861439978005,
      29.7991617028985,
      44.1959515338618,
      51.9815835876592,
      48.3252108531698,
      35.4886510088385,
      42.6127401930697,
      33.4313602076776,
      26.0221391458556,
      27.7501977587518,
      45.2489554634988,
      19.3087264003992,
      18.0180094893391,
      9.35943086182051,
      48.474615893184,
      56.4053122685445,
      53.8709349074362,
      61.847959491923,
      63.3456509516447,
      58.9331620488763,
      68.6496972063572,
      74.6085969860368,
      69.5473031283442,
      55.2053537056693,
      65.2383731257445,
      61.5170302784853,
      52.0041328949081,
      31.6290494464862,
      23.2196417644916,
      24.5325853499698,
      40.3105651078774,
      30.0161484369676,
      15.126015383602,
      14.3553262152041,
      7.3797066753622,
      7.78681207104561,
      15.9716676987393,
      22.0353770741046,
      16.9227416361999,
      8.23970431541341,
      8.75617858221585,
      49.2083997154432,
      58.2555650351255,
      28.5406253964535,
      27.1594266129708,
      20.9411560900976,
      0.000503174624182414,
      0.000506327479807365,
      7.00409116129508,
      0.000497688744230916,-7.00309001993159,
      0.000507221087779454,
      0.000506058799600013,
      13.6344029734015,
      6.64769326369936,
      19.9040418455875,
      12.9407811218571,
      0.000489918550931101,-6.64670549376823,
      6.2988974036774,
      0.000480031066149665,-6.29792743786264,-13.6334089386487,-12.939802978214,
      -19.9030568983249,-119.999286255401,-141.816495096945,-147.754431090525,
      -119.999256423558,-92.2441966643566,-98.182142147473,-158.384373409798,
      -166.851448611261,-171.000427127452,
      179.804478614883,-179.930045862115,
      166.79444284322,
      147.832967674514,
      158.301537097259,-158.124117889708,
      -119.999190478018,-179.903438905768,-119.99898033518,-60.095243291955,
      -81.8745045902867,-60.068825928253,-73.1473363485156,-38.3006045270357,
      -27.8322085436695,-46.7934819565284,-81.6143680293093,-59.8033971210922,
      -68.9984171850191,
      120.000557444814,
      92.1682265347654,
      120.00065649282,
      141.744010632549,
      120.000509512085,
      98.2570538259009,
      59.9313168102065,
      46.8526355301338,
      27.7557277754149,
      38.1255967725635,
      81.6999124350398,
      73.206685197715,
      120.000884515601,
      59.9053965357739,
      120.001628400634,
      158.014288375496,
      137.746497758919,
      170.109084276791,
      151.777319236651,
      120.000486333124,
      102.25450044424,
      134.890422881646,
      120.000476271633,
      105.110543326595,
      81.9867551000931,
      88.2236776304897,
      69.8919576920066,
      60.1966209803923,
      0.000548062917413245,-27.7545875642572,
      0.000621501244595633,
      21.8177116373724,-21.8166624584997,-59.9301690303687,-73.2056243820515,
      -92.1671275882309,-81.6986606603058,-38.1242813719308,-46.8515699732095,
      0.000788497618397009,-59.9037504756484,
      0.00132762061216022,
      38.3855233103769,
      51.0015196568637,-38.3845079781962,-51.0005235029117,
      -60.1955988570516,-119.999540007934,-147.832039006717,-119.999574048378,
      -98.2560213722388,-119.999518947544,-141.743072583037,
      179.930783901266,
      166.85211292283,
      147.754927538302,
      158.124652788233,-158.300638122358,
      -166.793615841895,-119.999642868649,
      179.904160400144,-119.999854688433,
      -81.9857366997505,-102.253496465565,-69.8909569895784,-88.2226772662399,
      -119.999503507035,-137.745550353469,-105.109548418499,-119.999490496764,
      -134.889463038566,-158.013412570408,-151.7764092371,-170.108253141869,
      -179.803713873703,
      119.999580319674,
      92.2442479135526,
      119.999470008053,
      141.816983992883,
      98.1823075832756,
      60.0686540910692,
      46.7933479620109,
      27.8319277915436,
      38.3001662338006,
      81.874334792335,
      73.1473287244358,
      119.999233616228,
      60.0945580271623,
      119.998484569757,
      158.385001405112,
      171.001153923971,
      81.6144631830692,
      68.9984771794597,
      59.8033753033267,
      -0.000131991452646992,-0.000214042274612159,
      21.7431546036456,
      -8.559379539566e-05,-21.7433395731943,-0.000387405123187061,
      -0.000930421293563747,
      38.0133384896222,
      17.7457515214511,
      50.108085359453,
      31.7764706010597,-5.63177860745496e-05,-17.7458747919108,
      14.8897460943736,
      -3.62484555567898e-05,-14.8898269801826,-38.0134350178678,
      -31.7765363028632,-50.1081044869815,
      120.000473238626,
      107.290857683575,
      109.057958118863,
      120.000473646102,
      130.942991943478,
      132.710095451719,
      92.9271862331929,
      96.6688989802094,
      77.2478095799021,
      83.072108709332,
      99.8097854680461,
      87.8860374208948,
      92.0543514269618,
      102.618818183434,
      110.587438120009,
      120.000475199811,
      112.039979586302,
      120.000476365205,
      127.96097360146,
      129.413513228085,
      140.191174282593,
      143.332064167098,
      137.382140458172,
      147.946620729868,
      152.114940689767,
      147.073787114778,
      156.928879557432,
      162.753197861754,
      85.5306076083073,
      79.9859075378689,
      90.0595455513487,
      95.8659453550327,
      80.6338273302633,
      75.212711334278,
      84.98632286729,
      71.050764666226,
      80.4990538964525,
      94.4224394125819,
      89.7598788169311,
      98.7503155000219,
      103.407317792588,
      99.580347325968,
      105.358523145986,
      108.367204730902,
      113.673967262857,
      75.1130456006351,
      68.6467020425007,
      103.090414475384,
      107.426192114733,
      111.601974054878,
      107.430991182743,
      94.3987980804283,
      111.715477649459,
      115.820418852615,
      115.917074320415,
      120.000434593376,
      120.000455467454,
      124.180473844637,
      128.398940159143,
      124.154370492847,
      115.846556895318,
      111.890239000427,
      120.000469526399,
      116.27995402972,
      85.5193713995281,
      76.4901235139392,
      136.910509737743,
      145.602143123198,
      141.25062936431,
      132.569941812344,
      132.574708023558,
      154.481593736187,
      150.24108479793,
      163.510871810202,
      159.501935304694,
      145.578522258283,
      155.014659439633,
      149.941429230023,
      140.420612020004,
      136.593630422186,
      128.110702148739,
      131.63374633556,
      123.720994057474,
      128.285395625319,
      124.083769932685,
      154.470377607367,
      144.13502143226,
      160.015090382284,
      159.367167592052,
      134.642433403726,
      126.326985585877,
      164.788298482285,
      168.950256011507,
      164.887961085912,
      171.354322021575,-2.14606952905316e-05,-12.7095149047723,-10.9424203177513,
      -9.81741570774655e-06,
      10.9423946643451,
      12.7094650505499,-27.0730518430519,
      -23.3313626363998,-42.7522939992857,-36.9280332120837,-20.1904983493668,
      -32.1141395349691,-27.9458571962899,-17.3814861869835,-9.41294754177327,
      -1.10509860747836e-07,-7.96041366202215,
      8.2518161743233e-06,
      7.96042552037457,
      9.41294193223361,
      20.1904960295243,
      23.3313424418143,
      17.3815001104359,
      27.9458816973433,
      32.1141517503933,
      27.0730110190818,
      36.9280337038192,
      42.7522836155142,-34.4695413275412,-40.0141932978508,
      -29.9406353125317,-24.1342917990427,-39.3662858671514,-44.7873496995093,
      -35.0138099737204,-48.9492622438105,-39.5010370853791,-25.5777698062373,
      -30.2402818855464,-21.2499186352134,-16.5929694088748,-20.4199158102071,
      -14.6418005325844,-11.6331385304397,-6.3264346347639,-44.8870279759576,
      -51.35332829229,-16.9098409520193,-12.5740805131931,-8.39835467559085,
      -12.5693181557188,-25.6013862236123,-8.28480755439304,-4.17992547075785,
      -4.08321841664627,
      7.93004067041122e-05,
      5.19611336112179e-05,
      4.18005592401496,
      8.39846061654772,
      4.15390922320853,-4.15382815850064,
      -8.11012517935097,
      3.00348269684473e-05,-3.72046334215516,-34.4807451584963,
      -43.509930025028,
      16.9099531196805,
      25.6015092619809,
      21.2500118026439,
      12.5694030731456,
      12.5742151259095,
      34.4808842567951,
      30.24038848033,
      43.5100908922739,
      39.5011630392178,
      25.5778471038307,
      35.0139037000731,
      29.9406994966699,
      20.419967227997,
      16.5930363849482,
      8.11018682128463,
      11.6331833983301,
      3.7205061793801,
      8.28496822535423,
      4.08340878298222,
      34.4695948931861,
      24.1343292556865,
      40.0142777482669,
      39.3663313251108,
      14.6418299082606,
      6.32646226451689,
      44.7874668517851,
      48.9494140900946,
      44.8870682650539,
      51.3533674221749,-119.999478342954,-132.709120403348,
      -130.941999948704,-119.99946625263,-109.056953609364,-107.289861057089,
      -147.072848565959,-143.331099597214,-162.752317396939,-156.92795882818,
      -140.19018533211,-152.113985114233,-147.945634170028,-137.381128784255,
      -129.412503679831,-119.999453915263,-127.959947016578,-119.999441491283,
      -112.038951162455,-110.586422375753,-99.8087760793269,-96.6678985788293,
      -102.617797089223,-92.0533383917503,-87.8850350740577,-92.9261899650519,
      -83.0711136213263,-77.2468161519453,-154.469392355511,-160.014105216003,
      -149.940411927875,-144.13400720055,-159.366218885181,-164.787312174142,
      -155.013638635402,-168.949267368067,-159.500910624924,-145.577477172416,
      -150.240033509537,-141.249560798102,-136.592570608859,-140.419573336218,
      -134.64140102833,-131.632695646691,-126.325943581596,-164.887054107222,
      -171.353463480164,-136.909422184394,-132.573606219727,-128.397849054515,
      -132.568864418972,-145.60106653641,-128.284284516441,-124.179373221164,
      -124.08265458913,-119.999328888125,-119.999366829745,-115.819324442395,
      -111.600892346765,-115.84548140977,-124.15329132935,-128.109635771048,
      -119.999403078794,-123.719938823457,-154.480536553255,-163.509842890641,
      -103.089342595404,-94.397737446568,-98.7492572643275,-107.429923195007,
      -107.42510744542,-85.5183221126277,-89.7588311444822,-76.4890846072191,
      -80.4980163523099,-94.4213952132876,-84.9852884467734,-90.058515286629,
      -99.5793078337756,-103.406264048211,-111.889177316517,-108.366156951466,
      -116.278900310859,-111.714381439846,-115.915968112681,-85.5295906379221,
      -95.8649196313916,-79.9848862014414,-80.6328223392418,-105.357489006685,
      -113.672926079777,-75.2116857717319,-71.0497358515472,-75.1120503317002,
      -68.6457128899946,
      0.000468312164905248,-5.94413371384609,-5.56895467715173,
      0.000455178048612957,
      5.56987772653254,
      5.94508188210981,-12.2512195099245,
      -11.5422300654077,-18.8926832286088,-17.8779058993561,-10.778723696704,
      -16.8226446299065,-15.6797466438768,-9.90693161298125,-5.14633174812347,
      0.000441218172360239,-4.6240545752356,
      0.000427358504274915,
      4.62492145540911,
      5.14722728582774,
      10.7796308434453,
      11.5431641570363,
      9.90780965746116,
      15.680635344442,
      16.8235623462868,
      12.2521775030092,
      17.878849750127,
      18.8936496664279,-20.3463335122747,-24.8511546557025,
      -18.6902517940716,-14.3823026496237,-21.8327413562863,-29.2492626377126,
      -22.9137786490593,-33.5783653328331,-27.0978331276712,-16.8011575215393,
      -20.7759520832704,-14.633900291845,-10.9485215538048,-12.8369955491299,
      -8.83010581996183,-7.36972148192407,-3.86493599708938,-23.2104496527346,
      -24.5301710154215,-12.1786187373251,-9.45602427364577,-6.05515457335198,
      -8.67707228327951,-18.414656985952,-6.49896718979765,-3.14447107285837,
      -3.33868561776639,
      0.000319292655951608,
      0.000358260359168034,
      3.14515010454542,
      6.05587260371654,
      2.87263741413972,-2.87188537575892,
      -5.37250694739986,
      0.0003916748870018,-2.37143013318987,-24.7791151332519,
      -31.2675831467431,
      12.1793411733557,
      18.4153864416924,
      14.6346616177471,
      8.67782756785852,
      9.45670620893051,
      24.7798539400677,
      20.7767217243577,
      31.2683334399541,
      27.0986130049669,
      16.8019560608531,
      22.9145866373377,
      18.6910858424058,
      12.8378203593925,
      10.9493123438912,
      5.37329231880347,
      7.37053844925895,
      2.3722417369847,
      6.49960723864866,
      3.33928278425218,
      20.3472011916089,
      14.3831601775023,
      24.8519989292302,
      21.8336403900357,
      8.83095358076969,
      3.86577468416087,
      29.2500814840439,
      33.5791571917452,
      23.2113772148449,
      24.5311237038283,-119.999205247647,-125.943821538979,
      -125.568616852447,-119.999192584838,-114.429785263068,-114.054607146738,
      -132.25092650001,-131.541911506401,-138.892415195005,-137.877612526538,
      -130.778378973315,-136.822324776925,-135.679399975951,-129.906561078902,
      -125.145968274415,-119.999181399557,-124.623666683283,-119.999172437584,
      -115.374690156406,-114.852409475525,-109.220023904964,-108.456517793117,
      -110.091817896451,-104.319012170876,-103.176113948717,-107.747530671068,
      -102.120854494109,-101.106080915858,-140.345990459216,-144.850821481075,
      -138.689881597109,-134.381929628933,-141.832425878228,-149.248946288645,
      -142.91341747054,-153.578073311217,-147.097487970395,-136.800761035195,
      -140.775563582583,-134.633478526086,-130.948099314023,-132.836597256599,
      -128.829710777487,-127.369303812896,-123.864526291713,-143.210161556981,
      -144.52990940496,-132.178172631772,-129.455554579808,-126.054687600763,
      -128.676627264035,-138.414241983608,-126.498474431723,-123.143982645282,
      -123.338170077798,-119.99917103537,-119.9991635575,-116.854352217231,
      -113.943646781845,-117.126899456955,-122.871426773265,-125.372068329507,
      -119.999162501973,-122.371001644638,-144.778741711868,-151.267261640894,
      -107.820183431332,-101.58414976384,-105.364889272739,-111.321712878299,
      -110.542795299255,-95.2196989453321,-99.2228451682783,-88.7312399525765,
      -92.90097418499,-103.197623383614,-97.0850124497741,-101.308523619746,
      -107.161770496282,-109.050252186249,-114.626263308225,-112.62903883443,
      -117.627328333444,-113.4998753861,-116.660186231701,-99.6524390107748,
      -105.616458580719,-95.147633069483,-98.1660305370645,-111.168647848762,
      -116.133814377655,-90.7495408131509,-86.4204534281241,-96.788323682892,
      -95.4686057150267,
      119.999951824692,
      114.05529995481,
      114.430516461184,
      119.999973627605,
      125.569416206349,
      125.944589487391,
      107.748169541732,
      108.457198370257,
      101.106666610917,
      102.121484546444,
      109.220745868641,
      103.176788489427,
      104.31973081467,
      110.092580351887,
      114.85317814312,
      119.999995184664,
      115.375494576103,
      120.000015743265,
      124.62452383062,
      125.146797776301,
      130.779229470357,
      131.542734525591,
      129.907437420123,
      135.680299482001,
      136.823200626795,
      132.251721363344,
      137.878463831587,
      138.893241814254,
      99.6531596393266,
      95.1483601610064,
      101.309289869348,
      105.617220553108,
      98.1667047798768,
      90.7502779975449,
      97.0857866975965,
      86.4212035658109,
      92.9017592772803,
      103.19843434014,
      99.2236653936935,
      105.365743945864,
      109.051098407663,
      107.162574923877,
      111.169449562923,
      112.629879004045,
      116.134652280537,
      96.7889510887911,
      95.4691862783209,
      107.821080648204,
      110.543733489452,
      113.944574898813,
      111.322600410729,
      101.585014534866,
      113.500852402945,
      116.855319530807,
      116.661199272526,
      120.000175322235,
      120.000120559711,
      123.144977193716,
      126.055671350277,
      122.872372707453,
      117.127817499499,
      114.627142146944,
      120.000070344916,
      117.628199838238,
      95.2205304157962,
      88.7320380226961,
      132.179181150463,
      138.415273505701,
      134.634474290835,
      128.677598875834,
      129.456574289448,
      144.779794548688,
      140.776582417703,
      151.268334004027,
      147.098528858804,
      136.801742181157,
      142.914422076598,
      138.690846071147,
      132.837538200879,
      130.949056883716,
      125.373001882722,
      127.370222318398,
      122.371898301902,
      126.499504000049,
      123.339208275635,
      140.346936321544,
      134.382851088777,
      144.851810378049,
      141.833351611887,
      128.830610180562,
      123.865406710744,
      149.249974088871,
      153.579135032987,
      143.211066235163,
      144.530792726035,
      107.821080648204,
      101.585014534866,
      105.365743945864,
      111.322600410729,
      113.944574898813,
      110.543733489452,
      95.2205304157962,
      99.2236653936935,
      88.7320380226961,
      92.9017592772803,
      103.19843434014,
      97.0857866975965,
      101.309289869348,
      107.162574923877,
      109.051098407663,
      114.627142146944,
      112.629879004045,
      117.628199838238,
      120.000070344916,
      117.127817499499,
      120.000120559711,
      116.855319530807,
      122.872372707453,
      126.055671350277,
      123.144977193716,
      113.500852402945,
      120.000175322235,
      116.661199272526,
      99.6531596393266,
      98.1667047798768,
      104.31973081467,
      105.617220553108,
      95.1483601610064,
      96.7889510887911,
      103.176788489427,
      95.4691862783209,
      102.121484546444,
      109.220745868641,
      108.457198370257,
      114.430516461184,
      114.85317814312,
      110.092580351887,
      111.169449562923,
      115.375494576103,
      116.134652280537,
      90.750277997545,
      86.4212035658109,
      119.999951824692,
      125.944589487391,
      125.569416206349,
      119.999973627605,
      114.05529995481,
      132.251721363344,
      131.542734525591,
      138.893241814254,
      137.878463831587,
      130.779229470357,
      136.823200626795,
      135.680299482001,
      129.907437420123,
      125.146797776301,
      119.999995184664,
      124.62452383062,
      120.000015743265,
      107.748169541732,
      101.106666610917,
      140.346936321544,
      144.851810378049,
      138.690846071147,
      134.382851088777,
      141.833351611887,
      149.249974088871,
      142.914422076598,
      153.579135032987,
      147.098528858804,
      136.801742181157,
      140.776582417703,
      134.634474290835,
      130.949056883716,
      132.837538200879,
      128.830610180562,
      127.370222318398,
      123.865406710744,
      143.211066235163,
      144.530792726035,
      132.179181150463,
      128.677598875834,
      138.415273505701,
      129.456574289448,
      125.373001882722,
      122.371898301902,
      144.779794548688,
      151.268334004027,
      126.499504000049,
      123.339208275635,-107.820183431332,
      -110.542795299255,-113.943646781845,-111.321712878299,-105.364889272739,
      -101.58414976384,-113.4998753861,-116.854352217231,-116.660186231701,
      -119.99917103537,-119.9991635575,-123.143982645282,-126.054687600763,
      -122.871426773265,-117.126899456955,-114.626263308225,-119.999162501973,
      -117.627328333444,-112.62903883443,-109.050252186249,-103.197623383614,
      -99.2228451682783,-107.161770496282,-101.308523619746,-97.0850124497741,
      -95.2196989453321,-92.90097418499,-88.7312399525765,-132.178172631772,
      -138.414241983608,-134.633478526086,-128.676627264035,-129.455554579808,
      -144.778741711868,-140.775563582583,-151.267261640894,-147.097487970395,
      -136.800761035195,-142.91341747054,-138.689881597109,-132.836597256599,
      -130.948099314023,-125.372068329507,-127.369303812896,-122.371001644638,
      -126.498474431723,-123.338170077798,-140.345990459216,-141.832425878228,
      -135.679399975951,-134.381929628933,-144.850821481075,-143.210161556981,
      -136.822324776925,-144.52990940496,-137.877612526538,-130.778378973315,
      -131.541911506401,-125.568616852447,-125.145968274415,-129.906561078902,
      -128.829710777487,-124.623666683283,-123.864526291713,-149.248946288645,
      -153.578073311217,-119.999205247647,-114.054607146738,-114.429785263068,
      -119.999192584838,-125.943821538979,-107.747530671068,-108.456517793117,
      -101.106080915858,-102.120854494109,-109.220023904964,-103.176113948717,
      -104.319012170876,-110.091817896451,-114.852409475525,-119.999181399557,
      -115.374690156406,-119.999172437584,-132.25092650001,-138.892415195005,
      -99.6524390107748,-105.616458580719,-98.1660305370646,-95.147633069483,
      -111.168647848762,-116.133814377656,-96.788323682892,-95.4686057150267,
      -90.749540813151,-86.4204534281242,-12.1786187373251,-18.414656985952,
      -14.633900291845,-8.67707228327952,-6.05515457335199,-9.45602427364578,
      -24.7791151332519,-20.7759520832705,-31.2675831467431,-27.0978331276712,
      -16.8011575215393,-22.9137786490593,-18.6902517940716,-12.8369955491299,
      -10.9485215538048,-5.37250694739987,-7.36972148192408,-2.37143013318988,
      0.000391674886989947,-2.87188537575893,
      0.000358260359157054,
      -3.14447107285838,
      2.87263741413971,
      6.05587260371653,
      3.14515010454541,
      -6.49896718979766,
      0.000319292655942089,-3.3386856177664,-20.3463335122747,
      -21.8327413562863,-15.6797466438768,-14.3823026496237,-24.8511546557025,
      -23.2104496527347,-16.8226446299066,-24.5301710154215,-17.8779058993561,
      -10.778723696704,-11.5422300654077,-5.56895467715174,-5.14633174812349,
      -9.90693161298126,-8.83010581996184,-4.62405457523561,-3.8649359970894,
      -29.2492626377126,-33.5783653328331,
      0.000468312164891348,
      5.9450818821098,
      5.56987772653253,
      0.000455178048599614,-5.94413371384611,
      12.2521775030092,
      11.5431641570363,
      18.8936496664279,
      17.8788497501269,
      10.7796308434452,
      16.8235623462868,
      15.680635344442,
      9.90780965746115,
      5.14722728582773,
      0.000441218172347542,
      4.6249214554091,
      0.000427358504262291,
      -12.2512195099246,-18.8926832286088,
      20.3472011916089,
      24.8519989292302,
      18.6910858424058,
      14.3831601775023,
      21.8336403900357,
      29.2500814840439,
      22.9145866373377,
      33.5791571917451,
      27.0986130049669,
      16.8019560608531,
      20.7767217243576,
      14.6346616177471,
      10.9493123438912,
      12.8378203593925,
      8.83095358076969,
      7.37053844925895,
      3.86577468416086,
      23.2113772148449,
      24.5311237038283,
      12.1793411733557,
      8.67782756785851,
      18.4153864416924,
      9.45670620893049,
      5.37329231880346,
      2.37224173698469,
      24.7798539400677,
      31.2683334399541,
      6.49960723864865,
      3.33928278425217,
      16.9099531196806,
      12.5742151259095,
      8.39846061654773,
      12.5694030731456,
      21.2500118026439,
      25.6015092619809,
      8.28496822535424,
      4.18005592401497,
      4.08340878298223,
      7.93004067123555e-05,
      5.19611336190226e-05,-4.17992547075785,
      -8.39835467559084,-4.15382815850063,
      4.15390922320854,
      8.11018682128464,
      3.00348269765157e-05,
      3.72050617938011,
      11.6331833983301,
      16.5930363849483,
      25.5778471038307,
      30.24038848033,
      20.419967227997,
      29.9406994966699,
      35.0139037000731,
      34.4808842567951,
      39.5011630392178,
      43.5100908922739,
      -16.9098409520193,-25.6013862236123,-21.2499186352134,-12.5693181557188,
      -12.5740805131931,-34.4807451584963,-30.2402818855464,-43.509930025028,
      -39.5010370853791,-25.5777698062373,-35.0138099737204,-29.9406353125318,
      -20.4199158102071,-16.5929694088748,-8.11012517935097,-11.6331385304397,
      -3.72046334215515,-8.28480755439303,-4.08321841664626,-34.4695413275412,
      -39.3662858671514,-27.9458571962899,-24.1342917990427,-40.0141932978508,
      -44.8870279759576,-32.1141395349691,-51.35332829229,-36.9280332120837,
      -20.1904983493668,-23.3313626363998,-10.9424203177513,-9.41294754177327,
      -17.3814861869835,-14.6418005325844,-7.96041366202214,-6.3264346347639,
      -44.7873496995093,-48.9492622438104,-2.14606952840826e-05,
      12.70946505055,
      10.9423946643451,-9.81741570105257e-06,-12.7095149047723,
      27.0730110190818,
      23.3313424418143,
      42.7522836155142,
      36.9280337038193,
      20.1904960295243,
      32.1141517503933,
      27.9458816973433,
      17.3815001104359,
      9.41294193223362,-1.10509853349333e-07,
      7.96042552037459,
      8.25181618208056e-06,
      -27.0730518430519,-42.7522939992856,
      34.4695948931861,
      24.1343292556865,
      39.3663313251108,
      40.0142777482669,
      14.6418299082606,
      6.3264622645169,
      44.8870682650539,
      51.3533674221749,
      44.7874668517851,
      48.9494140900946,
      -103.089342595404,-107.42510744542,-111.600892346765,-107.429923195007,
      -98.7492572643276,-94.397737446568,-111.714381439846,-115.819324442395,
      -115.915968112681,-119.999328888125,-119.999366829745,-124.179373221164,
      -128.397849054515,-124.15329132935,-115.84548140977,-111.889177316517,
      -119.999403078794,-116.278900310859,-108.366156951466,-103.406264048211,
      -94.4213952132876,-89.7588311444822,-99.5793078337756,-90.058515286629,
      -84.9852884467735,-85.5183221126277,-80.4980163523099,-76.4890846072191,
      -136.909422184394,-145.60106653641,-141.249560798102,-132.568864418972,
      -132.573606219727,-154.480536553255,-150.240033509537,-163.509842890641,
      -159.500910624924,-145.577477172416,-155.013638635402,-149.940411927876,
      -140.419573336218,-136.592570608859,-128.109635771048,-131.632695646691,
      -123.719938823457,-128.284284516441,-124.08265458913,-154.469392355511,
      -159.366218885181,-147.945634170028,-144.13400720055,-160.014105216003,
      -164.887054107222,-152.113985114233,-171.353463480164,-156.92795882818,
      -140.19018533211,-143.331099597214,-130.941999948704,-129.412503679831,
      -137.381128784255,-134.64140102833,-127.959947016578,-126.325943581596,
      -164.787312174142,-168.949267368067,-119.999478342954,-107.289861057089,
      -109.056953609364,-119.99946625263,-132.709120403348,-92.9261899650519,
      -96.6678985788294,-77.2468161519453,-83.0711136213263,-99.808776079327,
      -87.8850350740577,-92.0533383917503,-102.617797089223,-110.586422375753,
      -119.999453915263,-112.038951162455,-119.999441491283,-147.072848565959,
      -162.752317396939,-85.5295906379221,-95.8649196313916,-80.6328223392419,
      -79.9848862014415,-105.357489006685,-113.672926079777,-75.1120503317003,
      -68.6457128899947,-75.2116857717319,-71.0497358515472,
      136.910509737743,
      132.574708023558,
      128.398940159143,
      132.569941812344,
      141.25062936431,
      145.602143123198,
      128.285395625319,
      124.180473844637,
      124.083769932685,
      120.000434593376,
      120.000455467454,
      115.820418852615,
      111.601974054878,
      115.846556895318,
      124.154370492847,
      128.110702148739,
      120.0004695264,
      123.720994057474,
      131.63374633556,
      136.593630422186,
      145.578522258283,
      150.24108479793,
      140.420612020004,
      149.941429230023,
      155.014659439633,
      154.481593736187,
      159.501935304694,
      163.510871810202,
      103.090414475384,
      94.3987980804283,
      98.7503155000219,
      107.430991182743,
      107.426192114733,
      85.5193713995281,
      89.7598788169311,
      76.4901235139392,
      80.4990538964524,
      94.4224394125819,
      84.98632286729,
      90.0595455513487,
      99.580347325968,
      103.407317792588,
      111.890239000427,
      108.367204730902,
      116.27995402972,
      111.715477649459,
      115.917074320415,
      85.5306076083073,
      80.6338273302633,
      92.0543514269618,
      95.8659453550327,
      79.9859075378689,
      75.1130456006351,
      87.8860374208948,
      68.6467020425007,
      83.072108709332,
      99.8097854680461,
      96.6688989802094,
      109.057958118863,
      110.587438120009,
      102.618818183434,
      105.358523145986,
      112.039979586302,
      113.673967262857,
      75.212711334278,
      71.050764666226,
      120.000473238626,
      132.710095451719,
      130.942991943478,
      120.000473646101,
      107.290857683575,
      147.073787114778,
      143.332064167098,
      162.753197861754,
      156.928879557432,
      140.191174282593,
      152.114940689767,
      147.946620729868,
      137.382140458172,
      129.413513228085,
      120.000475199811,
      127.960973601461,
      120.000476365205,
      92.9271862331929,
      77.2478095799021,
      154.470377607367,
      144.13502143226,
      159.367167592052,
      160.015090382284,
      134.642433403726,
      126.326985585877,
      164.887961085912,
      171.354322021575,
      164.788298482285,
      168.950256011507,
      179.193174870529,
      60.8078763915565,
      67.3762382577493,
      120.000406809903,
      172.624792112659,
      59.1921520473055,
      -59.1921078356949,-52.6237581398782,
      0.000111803161003638,
      52.6239468868869,
      -60.8068878321419,-179.19237450734,-172.623799984055,-119.99929233418,
      -67.3752080255016,
      25.8348198839396,-25.8338459795266,-37.8654251051505,
      0.000276897116459532,
      37.8661889191216,-94.1649360041966,-145.833609280404,
      -157.865165275904,-119.999184814605,-82.1334076705484,
      145.834471537931,
      94.1654702197059,
      82.1341729564449,
      120.000230415743,
      157.86625513924,
      120.000230415743,
      82.1341729564449,
      94.1654702197058,
      145.834471537931,
      157.86625513924,-82.1334076705484,-119.999184814605,-157.865165275904,
      -145.833609280404,-94.1649360041966,
      0.000276897116450814,-37.8654251051505,
      -25.8338459795266,
      25.8348198839396,
      37.8661889191216,
      52.6239468868869,
      0.000111803161011638,-52.6237581398782,-59.1921078356949,
      59.1921520473055,
      -67.3752080255016,-119.99929233418,-172.623799984055,-179.19237450734,
      -60.8068878321419,
      172.624792112659,
      120.000406809903,
      67.3762382577493,
      60.8078763915565,
      179.193174870529,-88.5640310182623,
      0.000503183912670418,
      -119.999298859311,
      119.999795709719,
      75.5227577739418,-75.5217802731372,
      -44.4771239427271,
      164.478081173325,-164.476952283349,
      44.4775694743839,
      44.4775694743839,-44.4771239427271,-75.5217802731372,-164.476952283349,
      164.478081173325,
      75.5227577739418,
      119.999795709719,-119.999298859311,
      0.000503183912652996,-88.5640310031033,
      120.00047615684,
      1.49949411930337e-05,
      -119.999430271952,
      0.000415696281654456,-119.999166827725,
      120.000032983135,
      120.000032983135,-119.999166827725,
      0.000415696281642122,
      1.49949412009288e-05,
      -119.999430271952,
      120.00047615684,-76.0552215845769,-74.038626868701,
      -72.5743079349531,-74.038592602719,-77.4385924853913,-79.538641273048,
      -77.4386278737832,-71.6104644310732,-71.9969242889622,-68.9323306250503,
      -68.301515491679,-70.6123084108677,-74.8478635353178,-69.0948762686965,
      -67.17102434975,-65.6154448295312,-67.1709910085817,-70.6122747839273,
      -71.6103996354047,-68.3014507706657,-68.9322391332034,-71.9968345208061,
      -74.8477985129515,-77.9560907122225,-74.8911814565239,-77.4957511550637,
      -80.8004637798804,-80.7814191732116,-83.0247478308312,-83.9659270269251,
      -86.5126010970479,-83.9659667610278,-80.7814563620314,-77.9561556276031,
      -80.8005265417089,-77.4958315880456,-74.8912682100432,-76.156323666693,
      -74.1631518843345,-77.4957747266159,-79.586516944167,-74.1631319504437,
      -72.7651893449646,-71.7325195295522,-68.5536308929242,-69.0173388995115,
      -71.9968887226443,-74.8912223198321,-70.8481663278022,-77.9561382364147,
      -74.8478584186985,-77.4386588728123,-80.7814759285372,-80.8004933363288,
      -83.0432290438685,-83.9659679330633,-86.516811487825,-71.7324834534774,
      -70.8481488298848,-69.017289363527,-68.553598350416,-69.4292325140176,
      -67.5814254490943,-66.1690670390749,-67.5814412047903,-76.0552988801686,
      -72.5743912095604,-74.0387083636742,-77.438704315119,-79.5387132988137,
      -74.0386669357976,-69.0949663806541,-67.1710811602424,-65.6155427493633,
      -67.1711190129722,-70.6123959589332,-70.6123568280501,-71.6105458945665,
      -68.3016039770134,-68.9324096685692,-71.9969957834695,-74.847938737454,
      -77.9562248498399,-74.8913323187551,-77.495887552316,-80.8005887205558,
      -80.7815286117903,-83.0248151202351,-83.9660348391003,-86.512663994227,
      -71.6104696090755,-68.9323046516479,-68.301530071895,-76.1564442458635,
      -74.1632466147351,-77.4958591493794,-79.5866290926078,-74.1632777504264,
      -72.7653176198982,-71.7325847356287,-68.5537062589861,-69.0173738870678,
      -71.9969108886695,-74.8912754613985,-70.8482697781063,-77.9561761379918,
      -74.8478655177716,-77.438648036789,-80.7814931400024,-80.8005645276314,
      -83.043331925438,-83.9660187807846,-86.5169041602061,-71.7326471203419,
      -70.8483028459713,-69.0174670672114,-68.5537725112756,-69.4293678356372,
      -67.581586771195,-66.1692088232861,-67.5815523771176,-76.0552468179986,
      -74.0386261027782,-77.4386407626803,-79.5386821908895,-74.0386298000404,
      -72.5743165790919,-71.6104429382315,-68.3014783153242,-68.9322928947089,
      -71.9969014197085,-74.8478557322787,-70.6122920904124,-77.956158310105,
      -74.891257692638,-77.4958295163813,-80.8005338680185,-80.7814796111663,
      -83.0248033843599,-83.9659926350294,-86.5126701584434,-71.6104475914335,
      -70.6122935963242,-68.932296749615,-68.3014796964143,-69.0948676273729,
      -67.1709914317787,-65.6154184764898,-67.1709912687302,-76.1564037122884,
      -79.5865836934781,-74.1632199956213,-72.7652821375918,-74.1632277952399,
      -83.0432819047883,-86.5168497456455,-71.7325690822274,-70.8482470348828,
      -69.0173662584579,-68.5536936644034,-69.429337454075,-70.8482587411891,
      -67.58153379956,-66.1691833820321,-67.581548318979,-71.7325886754371,
      -68.5537198355127,-69.0174003458277,-62.1344876376872,-63.7191423776215,
      -60.2585797708336,-58.6510512576855,-60.2585806522569,-63.7191429647767,
      -64.9476787358414,-61.5624163010125,-65.7602101599091,-62.5145178346603,
      -58.1531753110064,-59.2145537457004,-55.8725905267831,-54.7250940197831,
      -56.7904830306257,-55.1649286412606,-53.3163680861691,-51.6770600201267,
      -53.316368495186,-56.7904838331697,-58.1531770599701,-61.5624178717813,
      -54.7250952718254,-55.8725928103551,-59.2145563247258,-64.9476793257595,
      -62.5145196367553,-65.7602099135499,-53.462094907837,-54.1596449331459,
      -50.9577087753038,-50.1446957665513,-52.4977598408146,-56.7321611560837,
      -54.5827360877017,-57.5228964632081,-54.7348269140666,-51.8639151236251,
      -51.5301823364793,-57.2848097323623,-48.3865292966362,-48.8664612815476,
      -45.767276257405,-45.1711976129057,-47.6950803183375,-46.7913782167376,
      -44.3864607903422,-43.4130292594817,-45.6813512103303,-49.0980607159896,
      -51.2827430505043,-47.831022808924,-49.8386187277664,-59.9421741852025,
      -63.0764455427789,-60.3148040348301,-40.0204200016994,-37.685450262975,
      -36.6245300415663,-38.8305516423919,-42.2558623103616,-41.0455775295321,
      -35.2644301331378,-36.0729430186003,-32.76857291119,-31.9245571899663,
      -34.3186806456834,-38.5947444824132,-33.2368879576349,-30.9577734833035,
      -29.8699131267965,-32.0220748550008,-35.4154545482814,-37.4826485775271,
      -34.0634518446969,-35.9848947685638,-39.426326712504,-40.9234193490178,
      -44.3756379387617,-42.8878246099929,-46.3607882661389,-41.9019006637485,
      -42.5889495513103,-39.3516001235507,-34.3460382729705,-32.5745891786819,
      -35.9848901620027,-37.7762354736218,-32.5745950541642,-30.9548996774664,
      -30.6782552897002,-27.3423470565284,-28.6637578496037,-32.0220570221263,
      -34.0634413126035,-29.2095309090939,-37.4826405794017,-35.415440535479,
      -38.8305413814436,-40.9234137899839,-39.4263233548961,-41.2329511113657,
      -42.8878224283692,-44.7065366845375,-30.6782683441997,-29.2095380183639,
      -28.6637794125168,-27.3423625113783,-27.6189382687755,-25.9075851503641,
      -24.358767971587,-25.9075769004942,-40.0204084751678,-41.04556554761,
      -43.4130222134841,-42.2558555792576,-36.6245136376992,-37.68543241585,
      -41.901888788907,-39.3515813509678,-42.5889380400569,-45.1711915481553,
      -44.3864540605975,-38.5947259351075,-46.7913750646369,-47.6950780027608,
      -50.1446957404457,-49.098059789809,-45.6813476383566,-44.3756346211218,
      -47.8310214361287,-46.3607871365319,-33.2368664765016,-34.3186565552467,
      -29.8698865704952,-30.9577430132499,-35.2644043174105,-31.9245237865268,
      -32.768537386722,-36.0729161400442,-53.4620970667498,-52.4977609106795,
      -50.957709822643,-54.1596480894276,-56.7321643898579,-51.2827432313814,
      -49.8386184773435,-48.3865279274294,-51.5301843120497,-45.7672708739625,
      -48.8664606239259,-54.5827398347186,-57.2848135453653,-51.8639175427837,
      -54.7348305313574,-57.5229001923497,-59.9421772079511,-60.3148068467562,
      -63.0764468677185,-53.4622214371453,-54.1597662402572,-50.9578471524005,
      -50.1448381751315,-52.4978871998479,-55.872701272487,-56.7322699871794,
      -54.582847559902,-57.5229878218253,-54.7349240150173,-51.8640315577775,
      -51.5303120739525,-57.2849121436273,-48.3866751066082,-48.8665949237641,
      -45.7674245918123,-45.1713568612459,-47.6952335284997,-46.7915342288864,
      -44.3866261208612,-43.4131961079919,-45.6815058004826,-49.0982028491396,
      -51.2828672907098,-47.8311608420392,-49.8387364857297,-53.3164709595482,
      -54.7252025836187,-58.1532667802836,-59.2146464842936,-56.790569541967,
      -60.2586488924513,-61.5624896946545,-59.9422638946315,-62.5145915633226,
      -63.0765150191579,-60.3148860442925,-40.0205944231425,-37.6856296694069,
      -36.6247083061847,-38.8307222680398,-42.2560265539248,-41.0457517597925,
      -35.2646087871337,-36.0731152549365,-32.7687446325934,-31.9247337112559,
      -34.3188610489241,-38.5949206678847,-33.2370659395632,-30.9579503429433,
      -29.8700864198486,-32.0222468544353,-35.415627868177,-37.4828120312697,
      -34.0636170672149,-35.9850483533542,-39.4264757303196,-40.9235774324007,
      -44.3757874069951,-42.8879658774386,-46.3609189724351,-41.902070212611,
      -42.5891095750072,-39.3517682953389,-34.3461800058689,-32.574717800787,
      -35.9850151347761,-37.7763732161966,-32.5747497297676,-30.9550420802565,
      -30.6783702595781,-27.3424625946948,-28.6638593284019,-32.0221548338109,
      -34.063552738384,-29.209660032632,-37.4827456294157,-35.4155319868178,
      -38.830623982063,-40.9235098600232,-39.4264417100835,-41.2330817745053,
      -42.8879314650359,-44.7066574969205,-30.6784314814843,-29.2096901295715,
      -28.6639458826346,-27.3425196016012,-27.6190779067814,-25.9077310136448,
      -24.3589014459301,-25.90770331159,-40.0204667202759,-41.0455981490514,
      -43.4130675651158,-42.2559271023689,-36.6245829492598,-37.6854780158687,
      -41.9018950903243,-39.351577170001,-42.588918042851,-45.1711823477123,
      -44.3864722733527,-38.5947468391075,-46.7914060286165,-47.6950807967154,
      -50.1447111857039,-49.0981037613559,-45.6814061689291,-44.3757193990036,
      -47.8310929496019,-46.3608844854419,-33.2369447324194,-34.3187134354804,
      -29.8699713992715,-30.9578091637766,-35.2644385577854,-31.9245697615315,
      -32.7685621971482,-36.0729270230608,-53.4620962492402,-55.8726044833853,
      -52.4977891318733,-50.9576965545003,-54.1596185270318,-56.7321469742349,
      -58.1532007748768,-61.5624243282381,-60.2586154152962,-56.7905357903727,
      -54.7251358542464,-59.214551060033,-51.2827998815935,-53.3164368935933,
      -49.838702145487,-48.3865027201964,-51.5301430109972,-45.7672347190429,
      -48.8664084015642,-54.5826827949554,-57.2847678980635,-51.8638497905433,
      -54.7347482507662,-57.5228282502742,-59.9421432979221,-60.3147458219292,
      -63.0763970686977,-62.5144974751848,-62.1345318040231,-58.6511129682875,
      -63.7191601902224,-63.7191935067393,-55.1650072212536,-51.6771543656182,
      -64.9476685478824,-65.7601713799078,-64.9477334631696,-65.7602641920547,
      -53.4622046147289,-54.1597127646101,-50.9578039122406,-50.1448327542179,
      -52.4979106316069,-55.872713560295,-56.7322429045507,-54.582762280868,
      -57.5228953423592,-54.7348127490981,-51.8639269419129,-51.5302354481556,
      -57.2848496907627,-48.3866088089005,-48.8664988523693,-45.7673391946708,
      -45.1713027997089,-47.6952020137294,-46.7915415485775,-44.3866080291728,
      -43.4132176567569,-45.6815548603296,-49.0982384983868,-51.2829332004994,
      -47.8312395182024,-49.8388457197429,-53.3165679422441,-54.7252567256524,
      -58.1533100828342,-59.2146485246147,-56.7906551898352,-60.2587241227384,
      -61.5625229497229,-59.9422274587364,-62.5145840175331,-63.0764698838861,
      -60.3148156469227,-40.0206317791479,-37.6856441037567,-36.6247630642201,
      -38.8308019032814,-42.256090277454,-41.0457489516545,-35.2646047110964,
      -36.0730768256532,-32.7687272854985,-31.9247509817091,-34.318894697808,
      -38.5948975938996,-33.2371396216955,-30.9580050828683,-29.8701803683945,
      -32.0223616574053,-35.4157245843688,-37.4829347947068,-34.063756079339,
      -35.9852137614491,-39.4266263523338,-40.9236846162247,-44.375879857825,
      -42.8881020715658,-46.36104131496,-41.9020305054267,-42.5890372176607,
      -39.3517115465357,-34.3463862243956,-32.574961672313,-35.985247308708,
      -37.7765659334014,-32.5749300145234,-30.9552612425954,-30.6786473729456,
      -27.3427470975937,-28.6641641256715,-32.0224531500918,-34.0638204942414,
      -29.2099143477418,-37.4830024377505,-35.4158214972906,-38.830902790178,
      -40.923754554786,-39.4266613088021,-41.2332607701073,-42.8881379944111,
      -44.706822862802,-30.6785871635971,-29.2098850678374,-28.6640795195591,
      -27.3426920546774,-27.6193091051615,-25.9079400289507,-24.359143423973,
      -25.9079664673373,-40.0207636800842,-41.0459083740617,-43.4133519625926,
      -42.2561937949128,-36.6248908555494,-37.6857998793623,-41.9022129023903,
      -39.3519104623708,-42.5892372786637,-45.1714855668499,-44.3867690863272,
      -38.5950773598145,-46.7916768046064,-47.6953630184008,-50.1449678119936,
      -49.098343987296,-45.6816598364785,-44.3759512568116,-47.831311683561,
      -46.3610778235977,-33.2372614248205,-34.3190445647887,-29.8702942267059,
      -30.9581466300692,-35.2647792606903,-31.9249175027995,-32.7689150913886,
      -36.073271758384,-53.4623386685653,-55.8728183344272,-52.4980159544379,
      -50.9579635510388,-54.159870118662,-56.7323755067407,-58.1533822818238,
      -61.5625951655211,-60.2587610744085,-56.79069208466,-54.7253290744833,
      -59.214752681366,-51.2830056143023,-53.3166048291608,-49.8388825163972,
      -48.3867900767065,-51.5304137729914,-45.767537957913,-48.8666943245398,
      -54.5829366412723,-57.2850042215466,-51.8641175958207,-54.7349974922024,
      -57.5230650844484,-59.9423585086149,-60.3149671342748,-63.0765995804288,
      -62.5146878078947,-62.1346385698741,-58.6512296363621,-63.7192963814226,
      -63.7192591721573,-55.1651348135692,-51.6772938169769,-64.9478299269407,
      -65.7603514118904,-64.9477572489284,-65.7602474265442,-30.2073317625114,
      -29.4522974907207,-26.9112762127528,-27.5891749561501,-30.8534481169687,
      -33.4898748148738,-28.5879025698992,-26.1366492606554,-27.6153705743201,
      -25.2667858050945,-23.6132214159451,-22.8328244581196,-20.3230119495854,
      -21.0271438145494,-24.3103463796303,-24.9218992584948,-21.6583680441552,
      -22.2132408217113,-25.4469329298909,-28.1703693528758,-31.3930134841947,
      -34.0908982485364,-28.6564546797224,-31.8303988643427,-34.5765680857104,
      -36.7455395943379,-37.2867735170904,-39.9587314153246,-17.0487557236889,
      -16.2985011656729,-13.796511865781,-14.4789716414363,-17.7478717739236,
      -19.5507317414272,-15.5062064938735,-17.8276957554618,-14.6829648936572,
      -12.3469098493792,-13.0817008213478,-18.7164526756454,-10.569846837396,
      -9.90243167934099,-7.36949368162671,-7.98798613888188,-11.2248976834154,
      -11.8547126357933,-8.59920054397556,-9.19014341547259,-12.4483333300171,
      -15.1188797351933,-18.3884337643715,-15.7077010487087,-18.9644603748806,
      -21.972793092586,-24.3044716226086,-21.0379346564119,-6.50003634357162,
      -3.25002684525202,-3.79977443644147,-7.03552209604192,-9.74926969918681,
      -5.93547958571219,
      0.000132870130642004,
      0.559643028971678,
      3.25028948888104,
      2.68573599395337,-0.55937844336114,-2.68546888614527,-1.10556045403685,
      2.11947095080141,
      1.5652371367519,-1.62480078585358,-4.32194648125397,
      -7.53044670353806,-4.80388764317605,-7.97377933425966,-10.7309319621845,
      -10.2660910494545,-12.9962247841251,-13.4899548150088,-16.2382229055681,
      -5.35396037833891,-4.76849535404372,-2.11920171597369,-8.35494677014459,
      -8.66402606407874,-11.469559859515,-11.134826418548,-5.23295150940571,
      -5.59659381141761,-8.89216313191876,-6.08064976655798,-9.03220597036669,
      -11.9037179484344,-11.7278595247552,-5.88275746065231,-14.5751987547841,
      -14.7857045512506,-17.6683590129999,-17.4233155931624,-14.285689747271,
      -13.9220037886251,-17.1007966398011,-16.7043188667689,-2.10297256813631,
      -2.52532533671466,
      1.037769537728,
      0.553148077252146,-2.87663440283318,
      0.129057813830954,-0.215290911910344,-3.14184167007055,-20.7439771449834,
      -23.7957304702133,-23.638666243043,-20.5430341260611,-17.8332444022952,
      -20.8648572255136,-26.8162726440972,-26.8539720513674,-29.7974884658028,
      -29.725817828795,-26.7025925463699,-23.8740802989981,-26.5112315650594,
      -29.5802456946059,-29.3567790525339,-26.2398047344527,-23.4022761644142,
      -20.262894516205,-23.085976897056,-19.9049403855638,-14.9135484024847,
      -17.9161540394191,-11.9927963700226,-14.9564330703607,-20.905209383338,
      -17.9161682711814,-20.8648882495951,-23.8740969060764,-32.171834513782,
      -29.0505019595057,-32.4249487382428,-35.2350076884603,-34.9545553912385,
      -25.8857671870475,-22.6895129383545,-32.5979038034861,-35.4297755199443,
      -32.6981378772807,-35.5509265818313,-38.2218839369374,-38.0113195258099,
      -38.3539241744065,-41.1103554185389,-40.9789725195559,-37.7047309220961,
      -40.7574957615171,-40.4232982734429,-20.7441047755073,-23.7958432630325,
      -20.8649896061291,-17.8333917692397,-17.6685019076656,-20.5431572752043,
      -23.6387743344813,-26.8163715183382,-29.7258981836746,-29.7975747767482,
      -26.8540770636046,-23.87419840536,-26.7026862187335,-20.9053469113378,
      -23.8742210469666,-20.8650314166714,-17.916324864991,-17.9163059345348,
      -14.9137151497909,-14.9566038514135,-11.9929815837701,-11.9038994959677,
      -14.785867098601,-14.5753568158181,-11.7280369049018,-11.4697324578689,
      -14.2858429094061,-17.4234539377529,-20.2630132939605,-17.1009302068415,
      -19.9050547200278,-23.0860767637867,-23.4023800115702,-26.5113208347707,
      -26.2398902089636,-29.3568506798864,-29.5803212136193,-8.35513276148575,
      -5.23314927137736,-7.97395898880315,-11.1349935114709,-8.66421738993097,
      -5.59679768330511,-2.10318005679461,
      0.552925093749835,
      1.03755471490624,
      -1.62499976383516,-4.80407805202684,-2.52553989213882,-7.5306189424508,
      -4.32212824711496,-7.03568577447128,-10.2662445447321,-10.7310927206492,
      -13.9221515084753,-13.490096417194,-16.7044472683663,-8.89235887617738,
      -5.88296625954338,-9.03240531407411,-6.08086238516645,-2.87685461499179,
      -3.14206618106667,-0.215525458105773,
      0.128828265518635,-6.50019026443917,
      -5.93562251893621,-9.19027925508085,-9.74941491270296,-3.79994623691989,
      -3.25018734223227,-5.35409108709534,-2.11933564085359,-4.76861262872433,
      -7.98809979190918,-8.59932586848224,-2.68561674708259,-11.8548306268846,
      -11.2250057495031,-14.4790723905551,-15.1189887187539,-12.4484601724652,
      -12.9963594656675,-15.7078173072906,-16.2383455901534,-1.10574946038983,
      -0.559556017275085,
      1.56503207833941,
      2.11927724840821,-3.18298601484912e-05,
      2.68555520719396,
      3.25012312448078,
      0.559492602516954,-17.0488401362751,
      -20.3230880591747,-17.7479637577462,-13.7966033528853,-16.298577005323,
      -19.5508009417659,-23.613288304394,-26.1367024358159,-26.9113332913603,
      -24.3104177852089,-21.0272259023623,-22.8328860044257,-18.3885323862845,
      -21.6584553051521,-18.9645648231714,-10.5699438870155,-13.0817820051705,
      -7.36959453477392,-9.90251665717668,-15.5062727554553,-18.7165139724758,
      -12.3469797403788,-14.683020644433,-17.827748164814,-21.9728483473806,
      -21.0379826160028,-24.3045142756673,-25.266834211054,-30.2073787846498,
      -30.8534972643696,-27.5892352566908,-29.4523418866661,-33.4899118823601,
      -31.3930645456918,-34.5766077122274,-31.8304519496079,-28.6565203749915,
      -28.1704324328845,-34.0909365724467,-24.9219745397946,-25.4470116743847,
      -22.2133326265979,-28.587943598029,-27.6154073145139,-36.7455671569263,
      -39.9587502623716,-37.2868017185823,-32.1718900628301,-29.0505704044756,
      -34.954596719697,-35.2350514674694,-32.4250075076037,-25.8858492398599,
      -22.6896088685541,-37.7047600819566,-38.0113503349381,-40.4233174082439,
      -40.7575157785808,-38.2219174385397,-35.4298228185427,-40.9789943852144,
      -41.1103804362007,-38.3539617203696,-32.5979668293112,-35.5509787372558,
      -32.6982064174488,-30.2073496970765,-29.4523347375576,-26.9113075268454,
      -27.5891891546928,-30.853446431126,-33.4898779698052,-28.587958376461,
      -26.1366971297915,-27.6154437348393,-25.2668492747902,-23.6132643547727,
      -22.8328808438375,-20.3230644327086,-21.0271853608236,-24.3103751199772,
      -24.9219133828958,-21.6583980508132,-22.2132589629372,-25.4469323549826,
      -28.1703662640498,-31.3929923171434,-34.0908797573892,-28.6564345265369,
      -31.8303588133804,-34.5765284679792,-36.7455269532688,-37.2867377480742,
      -39.9587023736876,-17.0488153739826,-16.2985672549041,-13.7965760386823,
      -14.4790321675413,-17.7479240263884,-19.5507942774386,-15.5062778327188,
      -17.8277745634547,-14.6830400668333,-12.3469782262673,-13.0817676632347,
      -18.7165240881427,-10.5699126511401,-9.90249629375487,-7.36955805022234,
      -7.98805475759596,-11.2249637517014,-11.8547781137657,-8.59927257425497,
      -9.19021807321701,-12.448397484757,-15.1189358028115,-18.3884778863605,
      -15.7077520139566,-18.9644958559797,-21.9728618284487,-24.3045493274507,
      -21.0380142816178,-6.50012437850987,-3.25012312448079,-3.79987982600331,
      -7.03561526857793,-9.74934626679013,-5.93556172307609,
      3.18298601342804e-05,
      0.559556017275071,
      3.25018734223225,
      2.68561674708258,-0.559492602516954,
      -2.68555520719397,-1.10568677179445,
      2.11933564085358,
      1.56508688737742,
      -1.62493826040058,-4.32206012575489,-7.53054429180128,-4.80400869269575,
      -7.97388067115389,-10.7310105083146,-10.2661688842093,-12.9962870003372,
      -13.4900146024793,-16.2382682946009,-5.35403583060501,-4.76856331722693,
      -2.11927724840822,-8.35505127042116,-8.6641332627926,-11.4696386229336,
      -11.1349052278894,-5.23307914199525,-5.59672726861798,-8.89227273143709,
      -6.08079309761034,-9.03231788953224,-11.9037964591169,-11.7279381131488,
      -5.88289609538036,-14.5752498514002,-14.785752959107,-17.6683812887109,
      -17.4233433074566,-14.2857437919338,-13.9220607971529,-17.1008301902533,
      -16.7043583847962,-2.10312017304697,-2.5254820521523,
      1.03760554963539,
      0.552971604556205,-2.87679926387507,
      0.128870118866871,-0.215488627935983,
      -3.14201382901028,-20.7439702957905,-23.7956950827157,-23.6386396397601,
      -20.5430346913632,-17.8332619454064,-20.8648441711752,-26.8162101974593,
      -26.8539024633127,-29.7974012920699,-29.7257401110838,-26.7025395775062,
      -23.8740378863414,-26.5111899515278,-29.5801798732502,-29.3567270958988,
      -26.2397759123223,-23.4022596821784,-20.2629033352872,-23.0859714800552,
      -19.9049579657527,-14.9135946691232,-17.9161679047753,-11.9928751719237,
      -14.9564780716518,-20.905191735506,-17.9161798942823,-20.8648680419662,
      -23.8740496697987,-32.1717766471969,-29.0504653743818,-32.4248746051016,
      -35.2349294586678,-34.9544956863799,-25.8857521747872,-22.6895191715238,
      -32.5978154376697,-35.4296808420167,-32.6980377963811,-35.5508180300531,
      -38.2217868782067,-38.0112409838761,-38.3538112160837,-41.1102416457008,
      -40.9788765235429,-37.7046729950183,-40.757420192354,-40.4232452251607,
      -20.7440381819127,-17.8332866104921,-17.668427758529,-20.5431231958899,
      -23.6387466928999,-23.7957797703827,-14.9135734959324,-14.785753825985,
      -11.9928071064136,-11.9037497318429,-14.5752704316676,-11.7279111011272,
      -11.4696292150427,-14.2857812687052,-17.4234085507745,-20.2630087546048,
      -17.1009107054313,-19.9050761678235,-23.0861112648596,-23.4023852578534,
      -26.5113308909073,-26.7026604811398,-26.2399324600811,-29.3568956898046,
      -29.5803315385732,-26.8163071337623,-29.72587036232,-29.7975061495432,
      -8.35500839537025,-5.59663462863389,-5.23300017410266,-7.97385118367568,
      -11.1349108897161,-8.66407482770373,-2.87665749435904,-3.14185810193901,
      -0.215300157214045,
      0.129046829461984,-2.52535338314749,-5.88278829128917,
      -2.10300353880167,
      0.553137024062551,
      1.03776022653112,-1.62483248604497,
      -4.80394167554731,-7.5305257943515,-4.32200322533929,-7.03560527259323,
      -10.2661959112623,-10.7310283805301,-13.9221119462101,-13.4900759093495,
      -16.7044503018386,-8.89219689966046,-9.03222324146425,-6.08066896094638,
      -6.50012045116875,-5.93556163308926,-9.19025422563691,-9.74937934816082,
      -3.79983122612303,-3.25008115836839,-5.35403767820094,-2.11924471120678,
      -4.76856563421467,-7.98808934867795,-8.59930909080319,-2.68551847577183,
      -11.8548482205255,-11.2250302323388,-14.4791289088383,-15.1190372211138,
      -12.448468157753,-12.9963548070752,-15.707854359087,-16.2383675110336,
      -1.1055906866097,-0.559405156306397,
      1.56523135512481,
      2.11947031833562,
      0.000111461069423058,
      2.685741846528,
      3.25030279853343,
      0.559628350099345,
      -17.0489306346083,-20.3232032573997,-17.74804835438,-13.7966648407201,
      -16.298670153292,-19.5509195706383,-23.6134232407009,-26.1368579658575,
      -26.9114826357609,-24.3105437105183,-21.0273338092929,-22.8330255923641,
      -18.3886073685596,-21.6585516542895,-18.9646261523669,-10.5699729694415,
      -13.0818459113366,-7.36958895207076,-9.90254855313762,-15.5063658578755,
      -18.7166326997209,-12.3470440751992,-14.68311161676,-17.8278642679023,
      -21.9729887083682,-21.0381204591825,-24.304669759565,-25.2669916050838,
      -30.2075371128116,-30.8536426867107,-27.5893736753636,-29.4525081185841,
      -33.4900739165565,-31.3931918910709,-34.5767348491539,-31.8305560703478,
      -28.6566218805128,-28.1705549291912,-34.0910837701188,-24.9220867583469,
      -25.4471053270723,-22.2134129021156,-28.5881130764447,-27.6155758746943,
      -36.7457279579522,-39.9589053647011,-37.2869458963576,-32.1719660308286,
      -29.0506459749318,-34.9546986937444,-35.2351234896378,-32.4250508006339,
      -25.8859194951885,-22.6896684862072,-37.704882475452,-38.0114460082718,
      -40.423454317398,-40.7576295100286,-38.2219818600868,-35.4298605830539,
      -40.9790802894412,-41.1104343560875,-38.3539909051786,-32.5979734970831,
      -35.5509785618072,-32.6981732232808,-30.207707699745,-29.4526918978591,
      -26.9116665227029,-27.5895449356647,-30.8537997200546,-33.4902303951519,
      -28.5883094752347,-26.1370541769634,-27.6157841460334,-25.267199648928,
      -23.6136193554469,-22.8332330921764,-20.3234102682233,-21.0275302821903,
      -24.3107282090461,-24.922259591711,-21.6587376005524,-22.2135884884111,
      -25.4472666331396,-28.1707134704296,-31.3933352637258,-34.0912258733658,
      -28.6567678429082,-31.8306859665135,-34.5768624956172,-36.7458697883369,
      -37.2870726619178,-39.9590322803923,-17.0491469555809,-16.2988957825263,
      -13.796888639943,-14.4793444978304,-17.7482552741048,-19.5511369610204,
      -15.506600496935,-17.828101158255,-14.6833547258052,-12.3472839474071,
      -13.0820778798574,-18.7168601215562,-10.5702021825855,-9.90278472615724,
      -7.36982130386399,-7.98831603778925,-11.2252524806799,-11.8550636916772,
      -8.59953033855913,-9.19047040041607,-12.4486771768721,-15.1192447379411,
      -18.3888049639133,-15.708054075054,-18.9648146383572,-21.9732071793532,
      -24.304888968901,-21.0383492964087,-6.50033827383878,-3.25030279853344,
      -3.80005167021058,-7.03582042486013,-9.74959090263562,-5.93578263638159,
      -0.000111461069437269,
      0.559405156306383,
      3.25008115836837,
      2.68551847577181,
      -0.559628350099359,-2.68574184652803,-1.10581465904554,
      2.11924471120676,
      1.56500310557534,-1.62505763854169,-4.32222296628662,-7.5307387459665,
      -4.80416110142863,-7.97406230978238,-10.7312320938393,-10.2664033218419,
      -12.9965577824696,-13.4902732831828,-16.2385597888716,-5.35426234917271,
      -4.76879436870441,-2.11947031833563,-8.35521793531268,-11.4698265497876,
      -11.135111279303,-5.2332195170612,-5.59685392958819,-8.66428285845647,
      -14.5754534238279,-14.7859326250995,-17.6685946185984,-17.423581107489,
      -14.2859687030702,-11.7281055252871,-13.9223041530721,-17.101089389002,
      -16.7046355600284,-2.10323010772369,-2.52558139533402,
      1.03752909317596,
      0.552902982638415,-2.87688674114494,-5.88300738201633,
      0.128810107598753,
      -0.215539066190487,-3.1420881329086,-8.89240332380486,-6.08088746305975,
      -9.03242778803616,-11.9039412554391,-20.7441875388581,-23.6388852499123,
      -20.5432793188167,-17.8334481678809,-23.7959107253238,-26.5114603433371,
      -29.5804430784163,-29.3570179108327,-26.2400718908928,-23.4025321677576,
      -26.7027808065122,-20.263172214675,-23.0862672031894,-19.9052475054743,
      -14.9137482583666,-11.9929956037795,-26.8164192938445,-29.7975996406847,
      -29.7259722819561,-32.172082946823,-29.0507797472639,-32.4251555407356,
      -35.2352234337843,-34.9548121615199,-25.8860696034776,-22.6898340245052,
      -32.5980671402422,-35.429948016661,-32.6982570621191,-35.5510547997596,
      -38.222065133257,-38.0115430605845,-38.3540616559376,-41.1105016789653,
      -40.9791613232688,-37.7049941707774,-40.7577253725282,-40.423565642144,
      -20.7440178705551,-17.8332978233296,-17.6684407823939,-20.5431056335371,
      -23.63869818564,-23.7957303592782,-14.913618463905,-14.7858003569545,
      -11.9928868762613,-11.9038314734969,-14.5753204681422,-11.7279961413423,
      -11.4697191708517,-14.2858370503914,-17.4234259600154,-20.2629971335268,
      -17.1009353581831,-19.905073928176,-23.0860752576246,-23.402341117042,
      -26.5112584656508,-26.7025854678042,-26.2398666475007,-29.3568043779575,
      -29.5802353397474,-26.8162332055557,-29.7257734926291,-29.7974124357304,
      -8.35514020798168,-5.59680245944679,-5.23317464534892,-7.9739903572876,
      -11.1350076050981,-8.66420066076793,-2.87686078609758,-3.1420551478425,
      -0.215536928543926,
      0.128803079533824,-2.52556321505365,-5.88295028888322,
      -2.10322021784113,
      0.552886450028893,
      1.03750309905962,-1.62505624483899,
      -4.80412363323025,-7.53067375001856,-4.32219345312853,-7.03576335221777,
      -10.2663120924144,-10.7311338330033,-13.9221759281395,-13.4901506485181,
      -16.7044852366648,-8.89231799393758,-9.0323406197097,-6.08082580668912,
      -6.50028979022917,-5.93574303653661,-9.19039719705806,-9.74950812560888,
      -3.80003033703368,-3.25028948888105,-5.35423151269673,-2.11947095080144,
      -4.76877174997827,-7.98826373657238,-8.59946744308542,-2.68573599395339,
      -11.8549694013764,-11.2251704285389,-14.4792337784163,-15.119120870203,
      -12.4485717735579,-12.9964428226616,-15.7079189951459,-16.2384158119513,
      -1.10582159354372,-0.559643028971692,
      1.56496813334354,
      2.11920171597369,
      -0.000132870130656215,
      2.68546888614526,
      3.25002684525201,
      0.559378443361098,
      -17.0490252642506,-20.3232652959887,-17.748117995418,-13.7967925004297,
      -16.2987912997587,-19.551010300226,-23.6134540681102,-26.1368906339747,
      -26.9114843703652,-24.3105472967535,-21.0273693963253,-22.8330865624119,
      -18.3886543243614,-21.6585637711653,-18.9646533263404,-10.5701329846195,
      -13.0819971536222,-7.36977941073089,-9.90272845076683,-15.5065141324482,
      -18.7167534408395,-12.3472188196011,-14.6832866205778,-17.8280152846529,
      -21.9730818340226,-21.0382466941503,-24.3047712507563,-25.2670578688237,
      -30.2075124002,-30.8535908601366,-27.5893479753084,-29.4525145456164,
      -33.4900257282069,-31.3931175255221,-34.5766389076167,-31.8304640636355,
      -28.6565540682824,-28.170505914094,-34.091009224597,-24.9220666922595,
      -25.4470656701667,-22.213405072368,-28.5881538949216,-27.615653354763,
      -36.7456594141173,-39.9588195896021,-37.286852119732,-32.1718613891985,
      -29.0505640672395,-34.9545865640078,-35.2350004111052,-32.4249384492937,
      -25.8858645687572,-22.6896445691997,-37.704768752303,-38.0113177917566,
      -40.4233447451048,-40.7575016980407,-38.2218445519916,-35.4297316420476,
      -40.9789398729292,-41.1102868235286,-38.3538496768347,-32.5978581262454,
      -35.5508485500537,-32.6980591759779,
      20.7440178705551,
      17.8332978233296,
      20.8648680419661,
      23.7957303592782,
      23.63869818564,
      20.5431056335371,
      17.6684407823939,
      14.913618463905,
      11.9038314734969,
      11.9928868762612,
      14.9564780716518,
      17.9161798942823,
      14.7858003569545,
      20.905191735506,
      17.9161679047752,
      20.8648441711752,
      23.8740378863414,
      23.8740496697987,
      26.8162332055557,
      26.8539024633127,
      29.7974124357305,
      29.7257734926291,
      26.7025854678042,
      26.5112584656508,
      29.5802353397474,
      29.3568043779575,
      26.2398666475007,
      23.402341117042,
      20.2629971335267,
      23.0860752576246,
      19.905073928176,
      17.1009353581831,
      17.4234259600154,
      14.5753204681422,
      14.2858370503914,
      11.4697191708516,
      11.7279961413422,
      32.1718613891985,
      34.9545865640078,
      31.8304640636355,
      29.0505640672394,
      32.4249384492937,
      35.2350004111052,
      37.704768752303,
      40.7575016980407,
      40.4233447451047,
      37.286852119732,
      34.5766389076167,
      38.0113177917566,
      31.3931175255221,
      34.091009224597,
      30.8535908601366,
      28.170505914094,
      28.6565540682824,
      25.8858645687572,
      25.4470656701667,
      22.6896445691996,
      32.5978581262454,
      35.4297316420476,
      32.6980591759779,
      35.5508485500538,
      38.2218445519916,
      38.3538496768348,
      41.1102868235286,
      40.9789398729291,
      30.2075124002,
      29.4525145456164,
      26.9114843703652,
      27.5893479753084,
      33.4900257282069,
      32.7687272854985,
      28.5881538949215,
      30.9580050828683,
      27.615653354763,
      25.2670578688237,
      26.1368906339747,
      31.9247509817091,
      23.6134540681102,
      22.8330865624119,
      20.3232652959887,
      21.0273693963252,
      24.3105472967535,
      24.9220666922594,
      21.6585637711653,
      22.213405072368,
      36.7456594141173,
      36.0730768256532,
      39.9588195896021,
      39.3517115465357,
      35.2646047110963,
      38.5948975938995,
      37.6856441037567,
      34.318894697808,
      17.0490252642506,
      14.4792337784163,
      17.748117995418,
      19.551010300226,
      16.2987912997587,
      13.7967925004297,
      11.8549694013764,
      8.59946744308539,
      9.19039719705803,
      12.4485717735578,
      15.119120870203,
      11.2251704285389,
      18.3886543243613,
      15.7079189951458,
      18.9646533263404,
      21.9730818340226,
      18.7167534408395,
      24.3047712507563,
      21.0382466941503,
      15.5065141324481,
      13.0819971536222,
      17.8280152846529,
      14.6832866205777,
      12.347218819601,
      10.5701329846195,
      9.90272845076682,
      7.36977941073087,
      7.98826373657236,
      6.50028979022916,
      7.03576335221776,
      9.74950812560886,
      5.93574303653659,
      3.80003033703366,
      7.53067375001856,
      4.80412363323023,
      7.97399035728759,
      10.7311338330033,
      10.2663120924144,
      4.32219345312852,
      12.9964428226615,
      13.4901506485181,
      16.2384158119513,
      5.35423151269671,
      4.76877174997826,
      1.10582159354369,
      -1.56496813334356,
      1.62505624483896,
      8.35514020798166,
      11.1350076050981,
      5.23317464534891,
      5.59680245944678,
      8.66420066076792,
      13.9221759281395,
      16.7044852366648,
      2.10322021784111,
      2.52556321505364,-1.03750309905963,
      -0.552886450028922,
      2.87686078609757,
      5.88295028888321,-0.128803079533839,
      0.215536928543912,
      3.14205514784248,
      8.89231799393757,
      6.08082580668912,
      9.03234061970967,
      6.50012437850985,
      5.93556172307608,
      9.190218073217,
      9.7493462667901,
      7.03561526857791,
      3.79987982600329,
      5.354035830605,
      8.59927257425497,
      4.76856331722692,
      7.98805475759595,
      11.8547781137657,
      11.2249637517014,
      14.4790321675413,
      15.1189358028115,
      12.448397484757,
      12.9962870003372,
      15.7077520139566,
      16.2382682946008,
      13.4900146024792,
      10.2661688842093,
      7.53054429180126,
      4.32206012575487,
      10.7310105083146,
      7.97388067115388,
      4.80400869269573,
      1.10568677179447,
      1.62493826040057,
      -1.56508688737742,
      17.0488153739826,
      16.298567254904,
      19.5507942774386,
      20.3230644327086,
      17.7479240263883,
      13.7965760386823,
      15.5062778327188,
      12.3469782262672,
      14.6830400668333,
      17.8277745634547,
      18.7165240881426,
      13.0817676632347,
      21.9728618284487,
      21.0380142816178,
      24.3045493274507,
      25.2668492747901,
      22.8328808438375,
      23.6132643547727,
      26.1366971297915,
      26.9113075268454,
      24.3103751199772,
      21.0271853608236,
      18.3884778863605,
      21.6583980508132,
      18.9644958559797,
      10.5699126511401,
      7.36955805022234,
      9.90249629375485,
      30.2073496970765,
      32.7685621971482,
      33.4898779698052,
      30.853446431126,
      27.5891891546928,
      29.4523347375576,
      35.2644385577854,
      34.3187134354804,
      37.6854780158687,
      38.5947468391075,
      36.0729270230608,
      31.9245697615315,
      36.7455269532688,
      39.351577170001,
      39.9587023736876,
      37.2867377480742,
      34.0908797573892,
      31.3929923171433,
      34.5765284679792,
      31.8303588133804,
      28.6564345265369,
      28.1703662640498,
      24.9219133828958,
      25.4469323549825,
      22.2132589629372,
      28.587958376461,
      27.6154437348393,
      30.9578091637766,
      32.1717766471969,
      29.3567270958987,
      29.0504653743818,
      34.9544956863799,
      35.2349294586677,
      32.4248746051016,
      26.5111899515278,
      26.7025395775062,
      23.6386396397601,
      23.4022596821784,
      26.2397759123223,
      29.5801798732502,
      25.8857521747871,
      23.0859714800552,
      22.6895191715238,
      37.7046729950183,
      38.0112409838761,
      40.4232452251607,
      40.757420192354,
      38.2217868782067,
      35.4296808420167,
      40.9788765235429,
      41.1102416457008,
      38.3538112160837,
      32.5978154376697,
      35.5508180300531,
      32.6980377963811,
      29.7257401110838,
      20.7439702957905,
      17.6683812887109,
      20.5430346913632,
      23.7956950827157,
      17.8332619454063,
      14.5752498514002,
      11.7279381131488,
      11.4696386229336,
      14.2857437919337,
      17.4233433074566,
      14.7857529591069,
      20.2629033352872,
      17.1008301902533,
      19.9049579657527,
      26.8162101974593,
      29.7974012920699,
      14.9135946691232,
      11.9928751719237,
      11.9037964591169,
      8.35505127042114,
      11.1349052278894,
      8.66413326279259,
      5.59672726861794,
      5.23307914199522,
      13.9220607971529,
      16.7043583847961,
      8.89227273143709,
      5.88289609538036,
      9.03231788953222,
      6.08079309761031,
      2.87679926387504,
      2.52548205215228,
      3.14201382901025,
      0.215488627935969,-0.128870118866885,
      2.10312017304696,-0.55297160455622,-1.0376055496354,
      20.7441047755073,
      17.8333917692397,
      20.8649896061291,
      23.7958432630325,
      23.6387743344813,
      20.5431572752043,
      17.6685019076656,
      14.9137151497909,
      11.9038994959677,
      11.9929815837701,
      14.9566038514134,
      17.9163059345348,
      14.7858670986009,
      20.9053469113378,
      17.916324864991,
      20.8650314166714,
      23.8742210469666,
      23.8741984053599,
      26.8163715183382,
      26.8540770636046,
      29.7975747767482,
      29.7258981836746,
      26.7026862187335,
      26.5113208347707,
      29.5803212136193,
      29.3568506798864,
      26.2398902089636,
      23.4023800115702,
      20.2630132939605,
      23.0860767637867,
      19.9050547200278,
      17.1009302068415,
      17.4234539377529,
      14.5753568158181,
      14.2858429094061,
      11.4697324578689,
      11.7280369049018,
      32.1718900628301,
      34.954596719697,
      31.8304519496079,
      29.0505704044756,
      32.4250075076037,
      35.2350514674694,
      37.7047600819567,
      40.7575157785808,
      40.4233174082438,
      37.2868017185823,
      34.5766077122273,
      38.0113503349381,
      31.3930645456918,
      34.0909365724467,
      30.8534972643696,
      28.1704324328845,
      28.6565203749915,
      25.8858492398598,
      25.4470116743847,
      22.6896088685541,
      32.5979668293112,
      35.4298228185427,
      32.6982064174488,
      35.5509787372558,
      38.2219174385397,
      38.3539617203696,
      41.1103804362007,
      40.9789943852144,
      30.2073787846498,
      29.4523418866661,
      26.9113332913603,
      27.5892352566908,
      33.4899118823601,
      32.76857291119,
      28.5879435980289,
      30.9577734833035,
      27.6154073145139,
      25.266834211054,
      26.1367024358158,
      31.9245571899663,
      23.613288304394,
      22.8328860044257,
      20.3230880591747,
      21.0272259023623,
      24.3104177852089,
      24.9219745397946,
      21.6584553051521,
      22.2133326265979,
      36.7455671569263,
      36.0729430186004,
      39.9587502623716,
      39.3516001235507,
      35.2644301331377,
      38.5947444824132,
      37.685450262975,
      34.3186806456834,
      17.0488401362751,
      14.4790723905551,
      17.7479637577462,
      19.5508009417659,
      16.298577005323,
      13.7966033528853,
      11.8548306268846,
      8.59932586848223,
      9.19027925508084,
      12.4484601724652,
      15.1189887187538,
      11.2250057495031,
      18.3885323862845,
      15.7078173072906,
      18.9645648231714,
      21.9728483473806,
      18.7165139724758,
      24.3045142756673,
      21.0379826160027,
      15.5062727554553,
      13.0817820051704,
      17.827748164814,
      14.683020644433,
      12.3469797403787,
      10.5699438870155,
      9.90251665717665,
      7.36959453477391,
      7.98809979190916,
      6.50019026443915,
      7.03568577447126,
      9.74941491270295,
      5.93562251893621,
      3.79994623691988,
      7.53061894245079,
      4.80407805202682,
      7.97395898880313,
      10.7310927206492,
      10.2662445447321,
      4.32212824711495,
      12.9963594656675,
      13.490096417194,
      16.2383455901534,
      5.35409108709533,
      4.76861262872431,
      1.10574946038982,-1.56503207833943,
      1.62499976383518,
      8.35513276148573,
      11.1349935114709,
      5.23314927137736,
      5.59679768330513,
      8.66421738993095,
      13.9221515084753,
      16.7044472683663,
      2.1031800567946,
      2.52553989213881,
      -1.03755471490625,-0.552925093749849,
      2.8768546149918,
      5.88296625954337,
      -0.128828265518621,
      0.215525458105759,
      3.14206618106665,
      8.89235887617735,
      6.08086238516643,
      9.03240531407411,
      6.50033827383876,
      5.93578263638157,
      9.19047040041606,
      9.7495909026356,
      7.03582042486013,
      3.80005167021055,
      5.3542623491727,
      8.59953033855913,
      4.76879436870436,
      7.98831603778923,
      11.8550636916772,
      11.2252524806799,
      14.4793444978304,
      15.1192447379411,
      12.4486771768721,
      12.9965577824695,
      15.708054075054,
      16.2385597888716,
      13.4902732831828,
      10.2664033218419,
      7.53073874596649,
      4.3222229662866,
      10.7312320938393,
      7.97406230978238,
      4.8041611014286,
      1.10581465904552,
      1.62505763854168,-1.56500310557537,
      17.0491469555809,
      19.5511369610204,
      20.3234102682233,
      17.7482552741048,
      13.7968886399429,
      16.2988957825263,
      21.9732071793532,
      21.0383492964087,
      24.304888968901,
      25.267199648928,
      22.8332330921764,
      18.7168601215562,
      23.6136193554469,
      26.1370541769633,
      26.9116665227029,
      24.3107282090461,
      21.0275302821903,
      18.3888049639133,
      21.6587376005523,
      18.9648146383571,
      10.5702021825855,
      13.0820778798574,
      7.36982130386396,
      9.90278472615721,
      15.5066004969349,
      12.3472839474071,
      14.6833547258052,
      17.828101158255,
      30.207707699745,
      32.7689150913886,
      33.4902303951519,
      30.8537997200546,
      27.5895449356647,
      29.4526918978591,
      35.2647792606903,
      34.3190445647887,
      37.6857998793623,
      38.5950773598145,
      36.073271758384,
      31.9249175027995,
      36.7458697883368,
      39.3519104623708,
      39.9590322803923,
      37.2870726619177,
      34.0912258733658,
      31.3933352637258,
      34.5768624956172,
      31.8306859665135,
      28.6567678429082,
      28.1707134704296,
      24.922259591711,
      25.4472666331396,
      22.2135884884111,
      28.5883094752347,
      27.6157841460334,
      30.9581466300692,
      32.172082946823,
      29.3570179108327,
      29.0507797472639,
      34.9548121615199,
      35.2352234337843,
      32.4251555407355,
      26.511460343337,
      26.7027808065122,
      23.6388852499123,
      23.4025321677576,
      26.2400718908928,
      29.5804430784162,
      25.8860696034777,
      23.0862672031894,
      22.6898340245052,
      37.7049941707774,
      38.0115430605845,
      40.423565642144,
      40.7577253725282,
      38.222065133257,
      35.4299480166611,
      40.9791613232688,
      41.1105016789653,
      38.3540616559376,
      32.5980671402422,
      35.5510547997596,
      32.6982570621191,
      29.7259722819561,
      20.7441875388581,
      17.6685946185984,
      20.5432793188166,
      23.7959107253238,
      17.8334481678809,
      14.5754534238279,
      11.7281055252871,
      11.4698265497876,
      14.2859687030702,
      17.423581107489,
      14.7859326250995,
      20.263172214675,
      17.101089389002,
      19.9052475054743,
      26.8164192938445,
      29.7975996406847,
      14.9137482583666,
      11.9929956037795,
      11.9039412554391,
      8.35521793531267,
      11.1351112793029,
      8.66428285845646,
      5.59685392958818,
      5.23321951706119,
      13.9223041530721,
      16.7046355600284,
      8.89240332380486,
      5.88300738201632,
      9.03242778803616,
      6.08088746305974,
      2.87688674114493,
      2.525581395334,
      3.14208813290858,
      0.215539066190473,
      -0.128810107598767,
      2.10323010772368,-0.552902982638429,-1.03752909317598,
      20.7440381819127,
      17.8332866104921,
      20.8648882495951,
      23.7957797703826,
      23.6387466928999,
      20.5431231958898,
      17.668427758529,
      14.9135734959324,
      11.9037497318429,
      11.9928071064136,
      14.9564330703607,
      17.9161682711814,
      14.785753825985,
      20.905209383338,
      17.916154039419,
      20.8648572255136,
      23.874080298998,
      23.8740969060764,
      26.8163071337623,
      26.8539720513674,
      29.7975061495432,
      29.72587036232,
      26.7026604811398,
      26.5113308909072,
      29.5803315385732,
      29.3568956898045,
      26.2399324600811,
      23.4023852578534,
      20.2630087546048,
      23.0861112648596,
      19.9050761678234,
      17.1009107054312,
      17.4234085507745,
      14.5752704316676,
      14.2857812687052,
      11.4696292150426,
      11.7279111011272,
      32.1719660308286,
      34.9546986937443,
      31.8305560703478,
      29.0506459749318,
      32.4250508006339,
      35.2351234896378,
      37.704882475452,
      40.7576295100286,
      40.423454317398,
      37.2869458963576,
      34.5767348491539,
      38.0114460082717,
      31.3931918910709,
      34.0910837701188,
      30.8536426867107,
      28.1705549291912,
      28.6566218805128,
      25.8859194951885,
      25.4471053270722,
      22.6896684862072,
      32.5979734970831,
      35.4298605830539,
      32.6981732232808,
      35.5509785618072,
      38.2219818600868,
      38.3539909051786,
      41.1104343560875,
      40.9790802894412,
      30.2075371128116,
      29.4525081185841,
      26.9114826357609,
      27.5893736753636,
      33.4900739165565,
      32.7687446325934,
      28.5881130764447,
      30.9579503429433,
      27.6155758746943,
      25.2669916050838,
      26.1368579658574,
      31.9247337112559,
      23.6134232407009,
      22.8330255923641,
      20.3232032573997,
      21.0273338092928,
      24.3105437105182,
      24.9220867583469,
      21.6585516542895,
      22.2134129021156,
      36.7457279579522,
      36.0731152549366,
      39.9589053647011,
      39.3517682953388,
      35.2646087871336,
      38.5949206678847,
      37.6856296694069,
      34.3188610489241,
      17.0489306346083,
      14.4791289088383,
      17.74804835438,
      19.5509195706382,
      16.298670153292,
      13.7966648407201,
      11.8548482205255,
      8.59930909080319,
      9.19025422563688,
      12.448468157753,
      15.1190372211138,
      11.2250302323387,
      18.3886073685596,
      15.707854359087,
      18.9646261523669,
      21.9729887083682,
      18.7166326997209,
      24.3046697595649,
      21.0381204591825,
      15.5063658578755,
      13.0818459113366,
      17.8278642679023,
      14.68311161676,
      12.3470440751992,
      10.5699729694415,
      9.90254855313759,
      7.36958895207074,
      7.98808934867793,
      6.50012045116874,
      7.03560527259322,
      9.74937934816082,
      5.93556163308925,
      3.79983122612302,
      7.53052579435149,
      4.80394167554731,
      7.97385118367565,
      10.7310283805301,
      10.2661959112623,
      4.32200322533926,
      12.9963548070752,
      13.4900759093495,
      16.2383675110336,
      5.35403767820092,
      4.76856563421464,
      1.10559068660969,-1.56523135512482,
      1.62483248604494,
      8.35500839537022,
      11.134910889716,
      5.23300017410263,
      5.59663462863388,
      8.6640748277037,
      13.9221119462101,
      16.7044503018386,
      2.10300353880166,
      2.52535338314748,-1.03776022653113,-0.553137024062579,
      2.87665749435901,
      5.88278829128916,-0.129046829462013,
      0.215300157214017,
      3.14185810193896,
      8.89219689966042,
      6.08066896094635,
      9.03222324146424,
      6.50003634357161,
      5.93547958571216,
      9.19014341547256,
      9.7492696991868,
      7.03552209604189,
      3.79977443644147,
      5.3539603783389,
      8.59920054397556,
      4.76849535404372,
      7.98798613888185,
      11.8547126357933,
      11.2248976834153,
      14.4789716414363,
      15.1188797351933,
      12.4483333300171,
      12.996224784125,
      15.7077010487087,
      16.2382229055681,
      13.4899548150088,
      10.2660910494545,
      7.53044670353805,
      4.32194648125396,
      10.7309319621845,
      7.97377933425965,
      4.80388764317604,
      1.10556045403683,
      1.62480078585355,-1.56523713675193,
      17.0487557236889,
      19.5507317414272,
      20.3230119495854,
      17.7478717739236,
      13.796511865781,
      16.2985011656729,
      21.972793092586,
      21.0379346564119,
      24.3044716226086,
      25.2667858050944,
      22.8328244581196,
      18.7164526756454,
      23.6132214159451,
      26.1366492606554,
      26.9112762127528,
      24.3103463796303,
      21.0271438145494,
      18.3884337643715,
      21.6583680441552,
      18.9644603748806,
      10.569846837396,
      13.0817008213478,
      7.36949368162669,
      9.90243167934098,
      15.5062064938735,
      12.3469098493792,
      14.6829648936572,
      17.8276957554618,
      30.2073317625114,
      32.768537386722,
      33.4898748148738,
      30.8534481169686,
      27.58917495615,
      29.4522974907206,
      35.2644043174105,
      34.3186565552467,
      37.68543241585,
      38.5947259351075,
      36.0729161400442,
      31.9245237865268,
      36.7455395943379,
      39.3515813509678,
      39.9587314153245,
      37.2867735170904,
      34.0908982485364,
      31.3930134841947,
      34.5765680857103,
      31.8303988643427,
      28.6564546797224,
      28.1703693528757,
      24.9218992584947,
      25.4469329298909,
      22.2132408217112,
      28.5879025698991,
      27.6153705743201,
      30.9577430132499,
      32.1718345137819,
      29.3567790525338,
      29.0505019595056,
      34.9545553912385,
      35.2350076884603,
      32.4249487382428,
      26.5112315650594,
      26.7025925463699,
      23.638666243043,
      23.4022761644142,
      26.2398047344526,
      29.5802456946059,
      25.8857671870476,
      23.0859768970559,
      22.6895129383545,
      37.704730922096,
      38.0113195258099,
      40.4232982734428,
      40.7574957615171,
      38.2218839369374,
      35.4297755199443,
      40.978972519556,
      41.1103554185389,
      38.3539241744065,
      32.597903803486,
      35.5509265818313,
      32.6981378772807,
      29.725817828795,
      20.7439771449834,
      17.6683590129998,
      20.5430341260611,
      23.7957304702133,
      17.8332444022951,
      14.5751987547841,
      11.7278595247551,
      11.469559859515,
      14.285689747271,
      17.4233155931624,
      14.7857045512506,
      20.262894516205,
      17.1007966398011,
      19.9049403855638,
      26.8162726440972,
      29.7974884658028,
      14.9135484024847,
      11.9927963700226,
      11.9037179484343,
      8.35494677014458,
      11.134826418548,
      8.66402606407873,
      5.59659381141756,
      5.23295150940569,
      13.9220037886251,
      16.7043188667689,
      8.89216313191874,
      5.8827574606523,
      9.03220597036666,
      6.08064976655795,
      2.87663440283315,
      2.52532533671462,
      3.14184167007053,
      0.215290911910301,-0.129057813830968,
      2.10297256813628,-0.55314807725216,
      -1.03776953772801,
      40.0206317791478,
      41.0457489516545,
      43.4132176567568,
      42.2560902774539,
      38.8308019032814,
      36.62476306422,
      41.9020305054267,
      44.3866080291728,
      42.5890372176607,
      45.1713027997089,
      46.7915415485775,
      47.6952020137294,
      50.1448327542178,
      49.0982384983868,
      45.6815548603296,
      44.375879857825,
      47.8312395182024,
      46.36104131496,
      42.8881020715658,
      40.9236846162246,
      37.4829347947068,
      35.4157245843687,
      39.4266263523338,
      35.985213761449,
      34.063756079339,
      33.2371396216955,
      32.0223616574053,
      29.8701803683945,
      53.4622046147289,
      54.1597127646101,
      56.7322429045507,
      55.872713560295,
      52.4979106316069,
      50.9578039122406,
      54.582762280868,
      51.8639269419129,
      54.7348127490981,
      57.5228953423591,
      57.2848496907627,
      51.5302354481556,
      59.9422274587364,
      60.3148156469227,
      63.0764698838861,
      62.5145840175331,
      59.2146485246147,
      58.1533100828342,
      61.5625229497229,
      60.2587241227384,
      56.7906551898352,
      54.7252567256524,
      51.2829332004994,
      53.3165679422441,
      49.8388457197429,
      48.3866088089005,
      45.7673391946707,
      48.8664988523693,
      62.1346385698741,
      65.6155427493633,
      63.7192963814225,
      60.2587610744085,
      58.651229636362,
      63.7192591721573,
      69.0949663806541,
      70.6123568280501,
      72.5743912095604,
      70.6123959589331,
      67.1711190129722,
      67.1710811602424,
      64.9478299269407,
      68.3016039770133,
      65.7603514118904,
      62.5146878078947,
      61.5625951655211,
      58.1533822818238,
      59.214752681366,
      55.8728183344272,
      54.7253290744833,
      56.7906920846599,
      55.1651348135692,
      53.3166048291608,
      51.6772938169769,
      64.9477572489284,
      65.7602474265442,
      68.301530071895,
      53.4623386685653,
      50.1449678119936,
      52.4980159544379,
      56.7323755067407,
      54.159870118662,
      50.9579635510388,
      46.7916768046064,
      44.3867690863272,
      43.4133519625925,
      45.6816598364785,
      49.098343987296,
      47.6953630184008,
      51.2830056143023,
      47.831311683561,
      49.8388825163971,
      59.9423585086149,
      57.2850042215466,
      63.0765995804288,
      60.3149671342748,
      54.5829366412724,
      51.5304137729914,
      57.5230650844484,
      54.7349974922024,
      51.8641175958206,
      48.3867900767066,
      48.8666943245398,
      45.767537957913,
      45.1714855668499,
      40.0207636800841,
      38.830902790178,
      42.2561937949128,
      41.0459083740617,
      36.6248908555494,
      37.4830024377505,
      34.0638204942414,
      35.985247308708,
      39.4266613088022,
      40.9237545547859,
      35.4158214972906,
      44.3759512568116,
      42.8881379944111,
      46.3610778235978,
      41.9022129023903,
      42.5892372786637,
      33.2372614248205,
      29.8702942267059,
      32.0224531500917,
      34.3463862243955,
      37.7765659334013,
      32.574961672313,
      30.9552612425954,
      32.5749300145234,
      41.2332607701073,
      44.706822862802,
      30.6786473729456,
      29.2099143477417,
      28.6641641256714,
      27.3427470975937,
      27.6193091051615,
      29.2098850678374,
      25.9079664673372,
      24.3591434239729,
      25.9079400289507,
      30.6785871635971,
      27.3426920546774,
      28.6640795195591,
      40.0205944231425,
      41.0457517597924,
      43.4131961079919,
      42.2560265539248,
      38.8307222680398,
      36.6247083061847,
      41.902070212611,
      44.3866261208612,
      42.5891095750071,
      45.1713568612459,
      46.7915342288864,
      47.6952335284997,
      50.1448381751314,
      49.0982028491396,
      45.6815058004825,
      44.3757874069951,
      47.8311608420393,
      46.3609189724351,
      42.8879658774385,
      40.9235774324007,
      37.4828120312697,
      35.415627868177,
      39.4264757303196,
      35.9850483533542,
      34.0636170672149,
      33.2370659395632,
      32.0222468544353,
      29.8700864198486,
      53.4622214371453,
      54.1597662402571,
      56.7322699871794,
      55.872701272487,
      52.4978871998479,
      50.9578471524005,
      54.582847559902,
      51.8640315577775,
      54.7349240150173,
      57.5229878218253,
      57.2849121436273,
      51.5303120739525,
      59.9422638946315,
      60.3148860442925,
      63.0765150191579,
      62.5145915633226,
      59.2146464842936,
      58.1532667802835,
      61.5624896946545,
      60.2586488924513,
      56.790569541967,
      54.7252025836187,
      51.2828672907098,
      53.3164709595482,
      49.8387364857296,
      48.3866751066081,
      45.7674245918123,
      48.8665949237641,
      62.1345318040231,
      63.7191601902224,
      60.2586154152962,
      58.6511129682875,
      63.7191935067393,
      65.6154448295312,
      64.9476685478824,
      68.3014507706657,
      65.7601713799078,
      62.5144974751848,
      61.5624243282381,
      67.1709910085816,
      58.1532007748767,
      59.214551060033,
      55.8726044833853,
      54.7251358542464,
      56.7905357903726,
      55.1650072212536,
      53.3164368935932,
      51.6771543656182,
      64.9477334631696,
      67.17102434975,
      65.7602641920547,
      68.301515491679,
      69.0948762686965,
      70.6123084108677,
      72.5743079349531,
      70.6122747839273,
      53.4620962492402,
      50.1447111857039,
      52.4977891318732,
      56.7321469742349,
      54.1596185270318,
      50.9576965545003,
      46.7914060286165,
      44.3864722733526,
      43.4130675651158,
      45.6814061689291,
      49.0981037613559,
      47.6950807967154,
      51.2827998815935,
      47.8310929496019,
      49.838702145487,
      59.9421432979221,
      57.2847678980634,
      63.0763970686977,
      60.3147458219291,
      54.5826827949554,
      51.5301430109971,
      57.5228282502742,
      54.7347482507661,
      51.8638497905433,
      48.3865027201964,
      48.8664084015642,
      45.7672347190429,
      45.1711823477123,
      40.0204667202759,
      38.830623982063,
      42.2559271023689,
      41.0455981490513,
      36.6245829492598,
      37.4827456294157,
      34.063552738384,
      35.985015134776,
      39.4264417100835,
      40.9235098600232,
      35.4155319868178,
      44.3757193990036,
      42.8879314650359,
      46.3608844854419,
      41.9018950903243,
      42.588918042851,
      33.2369447324193,
      29.8699713992715,
      32.0221548338109,
      34.3461800058689,
      37.7763732161966,
      32.574717800787,
      30.9550420802565,
      32.5747497297676,
      41.2330817745053,
      44.7066574969205,
      30.6783702595781,
      29.209660032632,
      28.6638593284019,
      27.3424625946948,
      27.6190779067814,
      29.2096901295715,
      25.90770331159,
      24.3589014459301,
      25.9077310136448,
      30.6784314814842,
      27.3425196016012,
      28.6639458826346,
      40.0204200016994,
      41.045577529532,
      43.4130292594817,
      42.2558623103616,
      38.8305516423919,
      36.6245300415663,
      41.9019006637484,
      44.3864607903422,
      42.5889495513103,
      45.1711976129057,
      46.7913782167376,
      47.6950803183375,
      50.1446957665512,
      49.0980607159896,
      45.6813512103303,
      44.3756379387617,
      47.831022808924,
      46.3607882661389,
      42.8878246099929,
      40.9234193490177,
      37.482648577527,
      35.4154545482813,
      39.426326712504,
      35.9848947685638,
      34.0634518446969,
      33.2368879576349,
      32.0220748550008,
      29.8699131267965,
      53.462094907837,
      54.1596449331459,
      56.7321611560836,
      55.8725905267831,
      52.4977598408146,
      50.9577087753037,
      54.5827360877017,
      51.8639151236251,
      54.7348269140666,
      57.5228964632081,
      57.2848097323623,
      51.5301823364793,
      59.9421741852025,
      60.31480403483,
      63.0764455427789,
      62.5145178346602,
      59.2145537457004,
      58.1531753110064,
      61.5624163010125,
      60.2585797708336,
      56.7904830306257,
      54.7250940197831,
      51.2827430505043,
      53.3163680861691,
      49.8386187277664,
      48.3865292966362,
      45.7672762574049,
      48.8664612815476,
      62.1344876376872,
      65.6154184764898,
      63.7191429647767,
      60.2585806522569,
      58.6510512576855,
      63.7191423776215,
      69.094867627373,
      70.6122935963242,
      72.5743165790919,
      70.6122920904124,
      67.1709912687302,
      67.1709914317787,
      64.9476793257595,
      68.3014783153242,
      65.7602099135499,
      62.5145196367553,
      61.5624178717813,
      58.1531770599701,
      59.2145563247257,
      55.8725928103551,
      54.7250952718254,
      56.7904838331697,
      55.1649286412606,
      53.3163684951859,
      51.6770600201266,
      64.9476787358414,
      65.7602101599091,
      68.3014796964143,
      53.4620970667498,
      50.1446957404457,
      52.4977609106795,
      56.7321643898578,
      54.1596480894276,
      50.957709822643,
      46.7913750646369,
      44.3864540605975,
      43.4130222134841,
      45.6813476383565,
      49.098059789809,
      47.6950780027607,
      51.2827432313814,
      47.8310214361287,
      49.8386184773435,
      59.9421772079511,
      57.2848135453653,
      63.0764468677185,
      60.3148068467562,
      54.5827398347186,
      51.5301843120497,
      57.5229001923497,
      54.7348305313574,
      51.8639175427837,
      48.3865279274293,
      48.8664606239259,
      45.7672708739625,
      45.1711915481552,
      40.0204084751678,
      38.8305413814435,
      42.2558555792576,
      41.04556554761,
      36.6245136376993,
      37.4826405794016,
      34.0634413126035,
      35.9848901620027,
      39.4263233548961,
      40.9234137899839,
      35.415440535479,
      44.3756346211217,
      42.8878224283692,
      46.3607871365319,
      41.901888788907,
      42.5889380400569,
      33.2368664765016,
      29.8698865704952,
      32.0220570221263,
      34.3460382729705,
      37.7762354736218,
      32.5745891786819,
      30.9548996774664,
      32.5745950541642,
      41.2329511113657,
      44.7065366845375,
      30.6782552897002,
      29.2095309090939,
      28.6637578496037,
      27.3423470565283,
      27.6189382687755,
      29.2095380183639,
      25.9075769004942,
      24.358767971587,
      25.9075851503641,
      30.6782683441997,
      27.3423625113783,
      28.6637794125168,
      76.0552215845769,
      74.038626868701,
      77.4386278737833,
      79.5386412730479,
      77.4385924853913,
      74.0385926027191,
      71.6104644310732,
      74.8478635353178,
      68.9323306250503,
      71.9969242889622,
      77.9561556276031,
      74.8912682100432,
      77.4958315880456,
      80.8005265417089,
      80.7814563620314,
      83.0247478308312,
      83.9659667610278,
      86.5126010970479,
      83.965927026925,
      80.7814191732116,
      77.9560907122225,
      74.8477985129515,
      80.8004637798804,
      77.4957511550637,
      74.8911814565238,
      71.6103996354047,
      71.9968345208061,
      68.9322391332034,
      76.1564037122884,
      77.4958295163813,
      79.5865836934781,
      74.1632277952399,
      72.7652821375918,
      74.1632199956213,
      77.956158310105,
      74.8478557322787,
      77.4386407626803,
      80.7814796111663,
      80.8005338680185,
      74.891257692638,
      83.0432819047883,
      83.9659926350294,
      86.5168497456455,
      71.732588675437,
      70.8482587411891,
      69.0174003458277,
      68.5537198355127,
      69.429337454075,
      70.8482470348828,
      67.5815483189789,
      66.1691833820321,
      67.58153379956,
      71.7325690822274,
      68.5536936644034,
      69.0173662584579,
      71.9969014197085,
      76.0552468179987,
      77.438648036789,
      79.5386821908895,
      74.0386261027782,
      74.0386298000404,
      77.9561761379918,
      74.8912754613985,
      77.4958591493794,
      80.8005645276314,
      80.7814931400024,
      74.8478655177715,
      83.02480338436,
      83.9660187807847,
      86.5126701584434,
      71.6104429382315,
      68.932292894709,
      71.6104475914335,
      68.932296749615,
      71.9969108886696,
      76.1564442458635,
      77.495887552316,
      79.5866290926078,
      74.1632466147351,
      72.7653176198982,
      74.1632777504264,
      77.9562248498399,
      74.8479387374541,
      77.438704315119,
      80.7815286117903,
      80.8005887205558,
      74.8913323187551,
      83.0433319254381,
      83.9660348391003,
      86.5169041602061,
      71.7325847356287,
      70.8482697781063,
      69.0173738870678,
      68.5537062589862,
      69.4293678356372,
      70.8483028459713,
      67.5815523771176,
      66.1692088232861,
      67.581586771195,
      71.7326471203419,
      68.5537725112756,
      69.0174670672114,
      71.9969957834695,
      76.0552988801686,
      77.4386588728123,
      79.5387132988137,
      74.0387083636741,
      74.0386669357976,
      77.9561382364147,
      74.8912223198321,
      77.4957747266159,
      80.8004933363288,
      80.7814759285372,
      74.8478584186985,
      83.0248151202351,
      83.9659679330633,
      86.5126639942271,
      71.6105458945665,
      68.9324096685692,
      71.6104696090754,
      68.9323046516479,
      71.9968887226443,
      76.156323666693,
      79.586516944167,
      74.1631518843345,
      72.7651893449646,
      74.1631319504437,
      83.0432290438685,
      86.516811487825,
      71.7325195295522,
      70.8481663278022,
      69.0173388995115,
      68.5536308929242,
      69.4292325140176,
      70.8481488298848,
      67.5814412047903,
      66.1690670390748,
      67.5814254490943,
      71.7324834534773,
      68.553598350416,
      69.0172893635271,
      -63.011380746377,-64.3917887886734,-61.3111474859832,-59.9913610311822,
      -61.3111653576907,-64.3918053298143,-65.4018714964913,-62.315172426647,
      -65.9888817710091,-62.9657300635243,-59.3296784601134,-59.9896586442266,
      -57.0948785733489,-56.4819853082647,-58.379520218325,-57.1609806661396,
      -55.6508009155575,-54.6147032190688,-55.6508190632635,-58.3795386939195,
      -59.3297150794045,-62.3152069075202,-56.4820226090967,-57.0949346307523,
      -59.9897120835231,-65.4019025191568,-62.9657790116397,-65.9889243517653,
      -54.6325071844626,-51.9717564201306,-51.879975924756,-54.3067428963443,
      -57.4527013569844,-49.1443379768534,-49.2405508736327,-46.1813367683643,
      -46.428331285706,-49.1891578252275,-46.5332610308365,-46.5330304774984,
      -49.0422610540911,-51.6318263642835,-53.8045741008765,-51.2963379996724,
      -53.1966417415765,-60.3267777921236,-63.2267292887722,-43.873479846331,
      -41.1771837910817,-43.8765633610942,-46.4776659166964,-43.8307133049119,
      -38.4245022762605,-41.2031952298081,-35.6085864045255,-38.4464355581227,
      -43.8730532073561,-41.2032113942235,-43.8765935789983,-46.4267340451933,
      -46.4267201455009,-48.8775001919927,-48.8022617951255,-50.9962908870136,
      -43.7103530925031,-43.4790529867393,-43.8735396885489,-43.8308014618472,
      -46.5330990268641,-46.4777074572865,-41.177231913963,-43.7104674107585,
      -46.5333551989364,-43.4791904326264,-46.428448767272,-49.1892319060388,
      -49.2406478287445,-51.8800524426937,-51.631881008706,-49.0423107723023,
      -48.8775250285595,-51.2963702363889,-50.9963014121599,-38.4245360723041,
      -35.6086038882322,-54.6325833035434,-54.306799491662,-51.9718530767522,
      -57.4527745393555,-53.8046102202627,-53.1966580048742,-49.1444553042909,
      -46.1814743560016,-60.326845712887,-63.2267896822992,-63.0112539733275,
      -64.3916706744445,-61.3110203319084,-59.9912250906858,-61.3110336940387,
      -64.3916851114592,-65.4017665487539,-62.315058208935,-65.9887948306869,
      -62.9656332648461,-59.3295556391943,-59.9895524198469,-57.0947636055767,
      -56.4818548234549,-58.3793850796381,-57.1608371456949,-55.6506591362145,
      -54.6145540515105,-55.650670386184,-58.3793974495127,-59.3295814719931,
      -62.315085904556,-56.4818788079341,-57.0948013879143,-59.9895925758047,
      -65.4017963964672,-62.965675999772,-65.9888406143155,-54.6324027623486,
      -51.9716646672251,-51.8798633783111,-54.3066200921347,-57.4526060515025,
      -49.1442605507225,-49.2404508309221,-46.1812748759316,-46.4282456211336,
      -49.1890384141689,-46.533154248271,-46.5329058071627,-49.0421260120144,
      -51.6316968056357,-53.8044370743182,-51.2961955616914,-53.1964948065656,
      -60.3266923496131,-63.2266542123134,-43.8733519882393,-41.1770553757511,
      -43.876422760022,-46.4775270117056,-43.8306017742333,-38.4243765121568,
      -41.2030557237039,-35.6084670315139,-38.4463005258641,-43.8729037678975,
      -41.2030647346101,-43.876439526249,-46.4265786228713,-46.4265709254469,
      -48.8773535369858,-48.8021076228627,-50.996139823075,-43.7102610718731,
      -43.4789831439448,-43.8733856420582,-43.8306524949857,-46.532944853861,
      -46.4775502310723,-41.1770824370299,-43.7103290110658,-46.5332094569869,
      -43.4790683492982,-46.428317238815,-49.1890817681223,-49.2405096608857,
      -51.8799101660526,-51.6317290978337,-49.04215437451,-48.8773674926791,
      -51.2962141766775,-50.9961458295991,-38.4243957412945,-35.6084772106555,
      -54.6324524132964,-54.306655385725,-51.9717265004141,-57.4526583307443,
      -53.8044588492264,-53.1965043856375,-49.1443351573838,-46.1813629877594,
      -60.3267473274223,-63.2267122021789,-63.0114016789001,-64.3918384743813,
      -61.3111937629416,-59.9913781983126,-61.3111585688905,-64.3918033441845,
      -65.4019495506544,-62.3152486394052,-65.9889858738245,-62.9658352866266,
      -59.3297520987381,-59.9897633686046,-57.0949814681474,-56.482055746194,
      -58.3795631867375,-57.1609951349273,-55.6508407064019,-54.6147163509619,
      -55.650808347327,-58.3795287856338,-59.3296823661478,-62.315178642541,
      -56.4819881232294,-57.0948780012854,-59.9896591408843,-65.4018807688108,
      -62.9657326222189,-65.9888868859847,-54.6326411876912,-51.9719231783581,
      -51.8801071246616,-54.306842686661,-57.4528364061223,-49.1445386477299,
      -49.2407153107785,-46.1815717534647,-46.4285301439931,-49.1892844460292,
      -46.5334211440371,-46.5331507534788,-49.0423499564224,-51.6319215878353,
      -53.8046404974178,-51.2963987457839,-53.1966779584205,-60.3269120386552,
      -63.226860613386,-43.8735921975234,-41.177287048331,-43.8766345924253,
      -46.4777466959294,-43.8308672603196,-38.4245958629987,-41.2032561409734,
      -35.6086704602084,-38.4464861399204,-43.8730847289152,-41.2032315201577,
      -43.8765874269582,-46.4267406421997,-46.4267628480834,-48.8775529461667,
      -48.8022807174153,-50.996320416161,-43.7105479075986,-43.4792865240596,
      -43.8734983917283,-43.8307280806796,-46.5330402235821,-46.4776801237609,
      -41.177213546348,-43.7103656042455,-46.5332679371454,-43.4790644379556,
      -46.4283367280029,-49.1891612356295,-49.2405522339263,-51.8799753485459,
      -51.6318285591738,-49.0422679646504,-48.8775122092859,-51.296344348913,
      -50.9963027440274,-38.4245454622909,-35.6086449493917,-54.632504694853,
      -54.3067427328987,-51.97175437261,-57.4526986401709,-53.8045775395053,
      -53.1966499246754,-49.1443385172135,-46.1813418199184,-60.326776089306,
      -63.2267293645867,-21.2009499115277,-22.6912869014611,-19.5893704543584,
      -18.1809159487092,-19.5893604679305,-22.691277667618,-24.074342931628,
      -20.8966510732374,-25.3561065393568,-22.1168404415116,-17.8358802874517,
      -18.965565478338,-15.9219923173695,-14.9220452378989,-16.6395492973241,
      -15.3505229452304,-13.8938952769335,-12.8042349869151,-13.893884954478,
      -16.6395388908591,-17.835859602508,-20.8966316625425,-14.9220240038515,
      -15.9219601742983,-18.9655349478031,-24.0743253152133,-22.1168123505404,
      -25.3560814998605,-13.8423707202902,-11.6075614950201,-10.8834502097693,
      -13.0012288598684,-16.8931807618356,-9.23827058832025,-8.59671066734177,
      -6.75882890247695,-6.17370158552464,-8.00367911797606,-5.63629425172061,
      -5.17481172501546,-7.49603614768704,-10.2026520457841,-12.1821909835351,
      -9.61058510260456,-11.421748682464,-20.0338146760231,-23.2533483466792,
      -2.36252093981294,
      0.460351279111705,-2.14005789471183,-4.8258346808303,
      -2.70572566543952,
      3.30765397694582,
      0.588169609158825,
      6.18205960202353,
      3.36405956592569,-2.06255760101429,
      0.588179347157634,-2.14003990907376,
      -4.63358398615053,-4.63359215367019,-7.13041042460692,-6.99177474266331,
      -9.19865301671364,-3.14175158924778,-3.64500014929619,-2.36248507841675,
      -2.70567219234123,-5.17477097199682,-4.82581018218791,
      0.460380417477069,
      -3.14168096735095,-5.63623750594523,-3.64491305381527,-6.17362934669171,
      -8.0036353667215,-8.59665253781769,-10.8834052848221,-10.2026202838962,
      -7.49600704598797,-7.13039595024156,-9.61056645073172,-9.19864693571341,
      3.30767472586959,
      6.182070537013,-13.8423262547455,-13.0011961958793,
      -11.6075037600058,-16.8931381314253,-12.1821702459332,-11.4217393481963,
      -9.23819863910003,-6.75874189873545,-20.0337749924217,-23.2533124751379,
      -21.2010740427381,-22.691422992766,-19.5894936316579,-18.1810279964661,
      -19.5894722770224,-22.6913982269519,-24.074490089973,-20.8967847115569,
      -25.3562632537542,-22.116983371097,-17.8359973573542,-18.9656910304799,
      -15.9220975748171,-14.9221434772796,-16.6396570575547,-15.3506208853661,
      -13.8939860579814,-12.8043179662091,-13.8939725086301,-16.6396394827988,
      -17.8359591869216,-20.8967393646636,-14.9221130648593,-15.9220480979857,
      -18.9656304088877,-24.0744384045526,-22.1169126529245,-25.356183823502,
      -13.8424580997377,-11.607624856302,-10.8835117746791,-13.0013117786683,
      -16.8932921638094,-9.23830404915034,-8.59674498028176,-6.75882718679304,
      -6.17370322343054,-8.00371408131464,-5.63629918040657,-5.17482028597686,
      -7.49607204410016,-10.2027115452621,-12.1822691165003,-9.6106428193653,
      -11.4218222040814,-20.0339473612365,-23.2534987826124,-2.36250425770942,
      0.460391086343051,-2.14004914881781,-4.82584756775488,-2.70570198169672,
      3.3077138603504,
      0.588197733500706,
      6.18213569434711,
      3.36410393233876,
      -2.06255777242387,
      0.588194858799596,-2.14004984607827,-4.63360854729096,
      -4.63361034239263,-7.13044802514594,-6.99181534201487,-9.19870993030895,
      -3.14172166694739,-3.64496449255074,-2.3625053169676,-2.70570287207177,
      -5.17481022211453,-4.8258419355831,
      0.460382624712096,-3.14172186451046,
      -5.63628404896291,-3.6449636733776,-6.1736826242512,-8.00369032316704,
      -8.59671168901673,-10.8834728859178,-10.2026855680797,-7.49605711030028,
      -7.13044093966931,-9.61062844004702,-9.19870544402561,
      3.30770271116985,
      6.18212726493057,-13.8424036447981,-13.0012740391364,-11.6075724111116,
      -16.8932225438757,-12.1822467407109,-11.4218128721732,-9.23826103774982,
      -6.75880114848491,-20.0338636607054,-23.2534026130207,-21.2013252141636,
      -22.6916451268636,-19.589727533222,-18.1812864827968,-19.5897471680497,
      -22.6916683194935,-24.074679024582,-20.8969893877295,-25.3564161109517,
      -22.1171553722244,-17.8362165440762,-18.9658815454352,-15.9223053503881,
      -14.9223754432616,-16.6399009964131,-15.3508845748477,-13.8942379818112,
      -12.8045846004665,-13.8942500364128,-16.6399168785667,-17.8362514950381,
      -20.8970316185082,-14.9224028622779,-15.9223507215371,-18.9659379379695,
      -24.0747280239709,-22.1172222039464,-25.3564924384403,-13.8426583901452,
      -11.6078221106207,-10.8837296617236,-13.0015348974795,-16.8934725798299,
      -9.23850311134389,-8.59696172948068,-6.75903309111602,-6.17392330432108,
      -8.00394637277222,-5.63653160475226,-5.17506280508886,-7.49631723973646,
      -10.2029473989502,-12.1825116652292,-9.61089335655727,-11.4220798974328,
      -20.0341064756271,-23.2536359481598,-2.36275181434061,
      0.460144595464939,
      -2.14029887020459,-4.82609774058353,-2.70594519955048,
      3.30747518557553,
      0.587954782588866,
      6.18191183927937,
      3.36387457618322,-2.06280776786471,
      0.587956935403795,-2.14029868274248,-4.63386748163269,-4.63386583937944,
      -7.13070328197701,-6.99207811195528,-9.19897157011223,-3.14195831999989,
      -3.64519252256125,-2.3627520637897,-2.70594700832372,-5.17507276414787,
      -4.82610304285986,
      0.460150741496946,-3.14196311869776,-5.63654756385652,
      -3.64520185400694,-6.17394669244874,-8.00396850825868,-8.59699405079168,
      -10.8837655691795,-10.2029707596418,-7.49633070217966,-7.13070952713393,
      -9.61090603137792,-9.19897547506015,
      3.30748372522119,
      6.18191835607867,
      -13.8427088661025,-13.0015690951557,-11.6078721017105,-16.8935377178769,
      -12.1825315733194,-11.4220880942172,-9.2385469347881,-6.75906521665908,
      -20.0341857529669,-23.2537283161095,
      2.3627518143406,
      2.70594519955047,
      5.17506280508884,
      4.82609774058353,
      2.14029887020457,-0.460144595464953,
      3.14195831999989,
      5.63653160475224,
      3.64519252256123,
      6.17392330432106,
      8.00394637277221,
      8.59696172948065,
      10.8837296617236,
      10.2029473989502,
      7.49631723973644,
      7.13070328197699,
      9.61089335655724,
      9.19897157011221,
      6.99207811195527,
      4.63386583937942,
      2.0628077678647,-0.587954782588881,
      4.63386748163266,
      2.14029868274247,-0.58795693540381,-3.30747518557554,
      -3.36387457618324,-6.18191183927938,
      13.8426583901452,
      16.8934725798298,
      15.9223053503881,
      13.0015348974795,
      11.6078221106207,
      20.0341064756271,
      18.9658815454352,
      23.2536359481598,
      22.1171553722244,
      17.8362165440761,
      20.8969893877295,
      19.5897275332219,
      16.6399009964131,
      14.9223754432616,
      12.1825116652291,
      13.8942379818111,
      11.4220798974328,
      9.23850311134387,
      6.75903309111601,
      21.2013252141636,
      22.6916683194935,
      19.5897471680497,
      18.1812864827968,
      22.6916451268636,
      24.0747280239709,
      20.8970316185081,
      25.3564924384403,
      22.1172222039464,
      17.836251495038,
      18.9659379379695,
      15.9223507215371,
      14.9224028622779,
      16.6399168785667,
      15.3508845748477,
      13.8942500364128,
      12.8045846004665,
      24.074679024582,
      25.3564161109517,
      13.8427088661025,
      11.6078721017105,
      10.8837655691795,
      13.0015690951557,
      16.8935377178769,
      9.23854693478809,
      8.59699405079166,
      6.75906521665907,
      6.17394669244871,
      8.00396850825865,
      5.63654756385648,
      5.17507276414786,
      7.49633070217965,
      10.2029707596418,
      12.1825315733194,
      9.61090603137791,
      11.4220880942171,
      20.0341857529669,
      23.2537283161095,
      2.36275206378967,
      4.82610304285983,
      2.7059470083237,-0.460150741496975,
      7.1307095271339,
      9.19897547506012,
      3.14196311869772,
      3.64520185400693,-3.30748372522122,
      -6.18191835607868,
      2.36250531696759,-0.460382624712111,
      2.14004984607826,
      4.82584193558306,
      5.17481022211452,
      2.70570287207175,-3.30770271116987,
      -0.588194858799611,-6.18212726493059,-3.36410393233878,
      2.06255777242384,
      -0.588197733500721,
      2.14004914881779,
      4.63361034239264,
      4.63360854729095,
      7.1304409396693,
      6.99181534201486,
      9.19870544402559,
      9.61062844004701,
      7.49605711030027,
      8.00369032316702,
      5.63628404896289,
      10.2026855680796,
      10.8834728859178,
      8.59671168901671,
      3.14172186451044,
      6.17368262425117,
      3.64496367337759,
      2.3625042577094,
      2.70570198169671,
      5.17482028597684,
      4.82584756775488,-0.460391086343066,
      3.14172166694735,
      5.63629918040654,
      3.64496449255071,
      6.17370322343052,
      8.00371408131463,
      8.59674498028174,
      10.8835117746791,
      10.2027115452621,
      7.49607204410015,
      7.13044802514592,
      9.6106428193653,
      9.19870993030894,-3.30771386035042,-6.18213569434712,
      13.8424580997376,
      16.8932921638093,
      15.9220975748171,
      13.0013117786683,
      11.607624856302,
      20.0339473612365,
      18.9656910304799,
      23.2534987826124,
      22.116983371097,
      17.8359973573542,
      20.8967847115569,
      19.5894936316579,
      16.6396570575547,
      14.9221434772796,
      12.1822691165003,
      13.8939860579814,
      11.4218222040814,
      9.23830404915032,
      6.75882718679303,
      21.2010740427381,
      22.6913982269519,
      19.5894722770224,
      18.1810279964661,
      22.691422992766,
      24.0744384045526,
      20.8967393646635,
      25.356183823502,
      22.1169126529245,
      17.8359591869216,
      18.9656304088877,
      15.9220480979857,
      14.9221130648593,
      16.6396394827988,
      15.3506208853661,
      13.8939725086301,
      12.8043179662091,
      24.0744900899729,
      25.3562632537542,
      13.842403644798,
      13.0012740391364,
      16.8932225438756,
      11.6075724111116,
      12.1822467407109,
      11.4218128721732,
      20.0338636607054,
      23.2534026130207,
      9.23826103774979,
      6.75880114848489,
      2.36252093981294,
      2.7057256654395,
      5.17481172501545,
      4.82583468083028,
      2.14005789471182,-0.46035127911172,
      3.14175158924773,
      5.63629425172059,
      3.64500014929618,
      6.17370158552463,
      8.00367911797605,
      8.59671066734177,
      10.8834502097693,
      10.2026520457841,
      7.49603614768702,
      7.13041042460691,
      9.61058510260455,
      9.19865301671362,
      6.9917747426633,
      4.63359215367018,
      2.06255760101428,-0.58816960915884,
      4.63358398615051,
      2.14003990907375,
      -0.588179347157663,-3.30765397694583,-3.3640595659257,-6.18205960202354,
      13.8423707202902,
      16.8931807618356,
      15.9219923173695,
      13.0012288598684,
      11.6075614950201,
      20.0338146760231,
      18.965565478338,
      23.2533483466792,
      22.1168404415116,
      17.8358802874517,
      20.8966510732374,
      19.5893704543584,
      16.6395492973241,
      14.9220452378989,
      12.182190983535,
      13.8938952769335,
      11.421748682464,
      9.23827058832023,
      6.75882890247694,
      21.2009499115277,
      22.6912776676179,
      19.5893604679305,
      18.1809159487092,
      22.6912869014611,
      24.0743253152133,
      20.8966316625425,
      25.3560814998605,
      22.1168123505404,
      17.8358596025081,
      18.9655349478031,
      15.9219601742983,
      14.9220240038515,
      16.6395388908591,
      15.3505229452304,
      13.893884954478,
      12.8042349869151,
      24.0743429316279,
      25.3561065393568,
      13.8423262547455,
      11.6075037600058,
      10.883405284822,
      13.0011961958793,
      16.8931381314253,
      9.23819863910002,
      8.59665253781768,
      6.75874189873547,
      6.17362934669171,
      8.0036353667215,
      5.63623750594522,
      5.17477097199681,
      7.49600704598795,
      10.2026202838962,
      12.1821702459332,
      9.61056645073171,
      11.4217393481963,
      20.0337749924217,
      23.2533124751378,
      2.36248507841674,
      4.82581018218787,
      2.70567219234121,
      -0.460380417477097,
      7.13039595024155,
      9.1986469357134,
      3.14168096735094,
      3.64491305381526,-3.3076747258696,-6.18207053701302,
      43.8733856420582,
      41.1770824370298,
      43.876439526249,
      46.4775502310723,
      46.532944853861,
      43.8306524949857,
      38.4243957412945,
      41.2030647346101,
      35.6084772106555,
      38.4463005258641,
      43.8729037678975,
      41.2030557237039,
      43.8764227600221,
      46.4265709254469,
      46.4265786228713,
      48.8773674926791,
      48.8021076228627,
      50.9961458295991,
      51.2962141766775,
      49.04215437451,
      49.1890817681223,
      46.5332094569869,
      51.6317290978337,
      51.8799101660526,
      49.2405096608857,
      43.7103290110658,
      46.428317238815,
      43.4790683492982,
      43.8733519882392,
      43.8306017742333,
      46.5329058071626,
      46.4775270117056,
      41.1770553757511,
      43.7102610718731,
      46.533154248271,
      43.4789831439447,
      46.4282456211336,
      49.1890384141689,
      49.240450830922,
      51.8798633783111,
      51.6316968056357,
      49.0421260120144,
      48.8773535369858,
      51.2961955616914,
      50.996139823075,
      38.4243765121568,
      35.6084670315139,
      54.6324027623486,
      57.4526060515025,
      57.0947636055766,
      54.3066200921347,
      51.9716646672251,
      60.3266923496132,
      59.9895524198469,
      63.2266542123134,
      62.9656332648461,
      59.3295556391943,
      62.315058208935,
      61.3110203319084,
      58.3793850796381,
      56.4818548234549,
      53.8044370743182,
      55.6506591362145,
      53.1964948065656,
      49.1442605507225,
      46.1812748759316,
      63.0112539733275,
      64.3916851114592,
      61.3110336940387,
      59.9912250906858,
      64.3916706744444,
      65.4017963964672,
      62.315085904556,
      65.9888406143155,
      62.9656759997719,
      59.3295814719931,
      59.9895925758046,
      57.0948013879143,
      56.4818788079341,
      58.3793974495127,
      57.1608371456949,
      55.650670386184,
      54.6145540515105,
      65.4017665487538,
      65.9887948306869,
      54.6324524132964,
      54.306655385725,
      57.4526583307443,
      51.9717265004141,
      53.8044588492264,
      53.1965043856376,
      60.3267473274223,
      63.2267122021789,
      49.1443351573838,
      46.1813629877594,
      43.8734983917283,
      41.177213546348,
      43.8765874269582,
      46.4776801237609,
      46.5330402235821,
      43.8307280806796,
      38.4245454622909,
      41.2032315201577,
      35.6086449493917,
      38.4464861399204,
      43.8730847289151,
      41.2032561409734,
      43.8766345924253,
      46.4267628480834,
      46.4267406421997,
      48.8775122092859,
      48.8022807174153,
      50.9963027440274,
      51.296344348913,
      49.0422679646504,
      49.1891612356295,
      46.5332679371454,
      51.6318285591738,
      51.8799753485459,
      49.2405522339263,
      43.7103656042455,
      46.4283367280029,
      43.4790644379556,
      43.8735921975234,
      43.8308672603196,
      46.5331507534788,
      46.4777466959294,
      41.177287048331,
      43.7105479075986,
      46.5334211440371,
      43.4792865240595,
      46.428530143993,
      49.1892844460292,
      49.2407153107785,
      51.8801071246616,
      51.6319215878353,
      49.0423499564224,
      48.8775529461667,
      51.2963987457839,
      50.996320416161,
      38.4245958629987,
      35.6086704602084,
      54.6326411876913,
      57.4528364061223,
      57.0949814681474,
      54.306842686661,
      51.9719231783581,
      60.3269120386552,
      59.9897633686046,
      63.226860613386,
      62.9658352866265,
      59.3297520987381,
      62.3152486394052,
      61.3111937629416,
      58.3795631867375,
      56.482055746194,
      53.8046404974178,
      55.6508407064019,
      53.1966779584205,
      49.1445386477299,
      46.1815717534647,
      63.0114016789001,
      64.3918033441845,
      61.3111585688905,
      59.9913781983126,
      64.3918384743813,
      65.4018807688108,
      62.315178642541,
      65.9888868859846,
      62.9657326222189,
      59.3296823661478,
      59.9896591408843,
      57.0948780012854,
      56.4819881232294,
      58.3795287856338,
      57.1609951349273,
      55.650808347327,
      54.6147163509619,
      65.4019495506544,
      65.9889858738245,
      54.632504694853,
      54.3067427328986,
      57.4526986401709,
      51.97175437261,
      53.8045775395053,
      53.1966499246753,
      60.326776089306,
      63.2267293645867,
      49.1443385172135,
      46.1813418199184,
      43.8735396885488,
      41.177231913963,
      43.8765935789983,
      46.4777074572865,
      46.5330990268641,
      43.8308014618472,
      38.4245360723041,
      41.2032113942235,
      35.6086038882321,
      38.4464355581227,
      43.8730532073561,
      41.2031952298081,
      43.8765633610942,
      46.4267201455009,
      46.4267340451933,
      48.8775250285595,
      48.8022617951255,
      50.9963014121599,
      51.296370236389,
      49.0423107723023,
      49.1892319060388,
      46.5333551989363,
      51.631881008706,
      51.8800524426937,
      49.2406478287445,
      43.7104674107585,
      46.428448767272,
      43.4791904326264,
      43.873479846331,
      43.8307133049119,
      46.5330304774984,
      46.4776659166964,
      41.1771837910817,
      43.7103530925031,
      46.5332610308365,
      43.4790529867393,
      46.428331285706,
      49.1891578252275,
      49.2405508736327,
      51.879975924756,
      51.6318263642835,
      49.0422610540911,
      48.8775001919927,
      51.2963379996724,
      50.9962908870136,
      38.4245022762605,
      35.6085864045254,
      54.6325071844626,
      57.4527013569844,
      57.0948785733489,
      54.3067428963443,
      51.9717564201306,
      60.3267777921237,
      59.9896586442266,
      63.2267292887722,
      62.9657300635243,
      59.3296784601134,
      62.315172426647,
      61.3111474859832,
      58.379520218325,
      56.4819853082647,
      53.8045741008765,
      55.6508009155575,
      53.1966417415765,
      49.1443379768534,
      46.1813367683643,
      63.011380746377,
      64.3918053298143,
      61.3111653576907,
      59.9913610311822,
      64.3917887886734,
      65.4019025191568,
      62.3152069075203,
      65.9889243517653,
      62.9657790116397,
      59.3297150794045,
      59.9897120835231,
      57.0949346307523,
      56.4820226090967,
      58.3795386939195,
      57.1609806661396,
      55.6508190632635,
      54.6147032190688,
      65.4018714964913,
      65.9888817710091,
      54.6325833035434,
      54.306799491662,
      57.4527745393555,
      51.9718530767523,
      53.8046102202627,
      53.1966580048742,
      60.3268457128869,
      63.2267896822992,
      49.1444553042909,
      46.1814743560015,
      -66.1130276870065,-66.1129772256301,-43.1111519400962,-32.7309232712084,
      -43.1113086732317,-66.1129742674013,-66.1129127848741,-43.1111063298533,
      -32.7308144724071,-43.1112086847257,-66.1129793387302,-66.113103005286,
      -43.1114206852333,-32.7309987298214,-43.1111631838856,-26.5371343610173,
      -26.5371657843049,-4.19352085474544,
      9.07955778011501,-4.19341815562177,
      -26.5372231954303,-26.5373298653725,-4.19347963671596,
      9.07964559858436,
      -4.19347782860905,-26.5375491126193,-26.5374451200633,-4.19369733081287,
      9.07944336340269,-4.19371267309459,-9.07944336340272,
      4.19369733081284,
      26.5374451200633,
      26.5375491126192,
      4.19371267309457,
      4.19347782860903,
      -9.07964559858438,
      4.19347963671595,
      26.5373298653725,
      26.5372231954303,
      -9.07955778011502,
      4.19352085474542,
      26.5371657843049,
      26.5371343610172,
      4.19341815562176,
      43.1112086847257,
      32.7308144724071,
      43.1111063298533,
      66.1129127848741,
      66.1129742674012,
      43.1111631838857,
      32.7309987298214,
      43.1114206852333,
      66.113103005286,
      66.1129793387302,
      43.1113086732317,
      32.7309232712084,
      43.1111519400962,
      66.1129772256301,
      66.1130276870065,
      -89.9999514999454,-48.1896931743393,-48.1898017423331,-48.1899538480726,
      -19.4711966635766,-19.4713062873501,-19.4712232182018,-19.4713497637055,
      -19.4715294670804,-19.4713604674297,
      19.4713604674297,
      19.4712232182018,
      19.4713062873501,
      19.4715294670804,
      19.4713497637055,
      19.4711966635766,
      48.1899538480726,
      48.1898017423331,
      48.1896931743393,
      89.9999514924312,
      -52.6227872291359,-52.6226347966897,-52.6228005542182,-10.8123115701816,
      -10.8123813031252,-10.8126486256819,
      10.8126486256819,
      10.8123813031252,
      10.8123115701816,
      52.6226347966897,
      52.6228005542182,
      52.6227872291359
    ),
    .Dim = c(4322L, 2L),
    .Dimnames = list(NULL, c("coords.x1",
                             
                             "coords.x2"))
  ),
  bbox = structure(
    c(
      -179.999433445547,-89.9999514999454,
      179.930783901266,
      89.9999514924312
    ),
    .Dim = c(2L, 2L),
    .Dimnames = list(c("coords.x1", "coords.x2"), c("min", "max"))
  ),
  proj4string = crsLL
)


llBorder = new(
  "SpatialPoints",
  coords = structure(
    c(
      -180,
      -172.8,
      -165.6,-158.4,
      -151.2,
      -144,
      -136.8,
      -129.6,
      -122.4,
      -115.2,
      -108,
      -100.8,-93.6,
      -86.4,
      -79.2,
      -72,
      -64.8,
      -57.6,
      -50.4,
      -43.2,
      -36,
      -28.8,-21.6,
      -14.4,
      -7.19999999999999,
      0,
      7.20000000000002,
      14.4,
      21.6,
      28.8,
      36,
      43.2,
      50.4,
      57.6,
      64.8,
      72,
      79.2,
      86.4,
      93.6,
      100.8,
      108,
      115.2,
      122.4,
      129.6,
      136.8,
      144,
      151.2,
      158.4,
      165.6,
      172.8,
      180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,
      -180,-180,
      -180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,
      180,-90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,-90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,-90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,-90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,
      -90,-89.9999514999454,
      -89.1,
      -88.2,
      -87.3,
      -86.4,
      -85.5,
      -84.6,-83.7,
      -83.0247876071577,
      -82.8,
      -81.9,
      -81,
      -80.1,
      -79.5386956295128,-79.2,
      -78.3,
      -77.4386418392484,
      -77.4,
      -76.5,
      -75.6,
      -74.8478628394576,-74.7,
      -73.8,
      -72.9,
      -72.7652431646884,
      -72,
      -71.6104921895808,-71.1,
      -70.2,
      -69.4435627190167,
      -69.3,
      -68.8292962120391,
      -68.4,-67.5814324446233,
      -67.5,
      -66.6,
      -65.9889341952948,
      -65.7,
      -65.4018621840883,-64.8,
      -63.9,
      -63.7191799136004,
      -63.0112930194267,
      -63,
      -62.3150879810862,-62.1,
      -61.2,
      -60.3268947939555,
      -60.3,
      -60.1132221153822,
      -59.4,-59.3296879928279,
      -58.5,
      -58.3793960640868,
      -57.6,
      -57.452682677638,-56.8879949713533,
      -56.7,
      -56.4818556868962,
      -55.8,
      -54.9,
      -54.7349008310696,-54.6147093647948,
      -54.1596599896612,
      -54,
      -53.3164675529527,-53.1,
      -52.4977604998514,
      -52.2,
      -51.8639159267858,
      -51.3076184705141,-51.3,
      -50.9871302228745,
      -50.4,
      -49.8386185975465,
      -49.5,
      -49.1443357099999,-48.8774885144531,
      -48.6,
      -48.3133865397664,
      -47.7,
      -46.8,
      -46.7915367468602,-46.4777098116051,
      -46.3610696456629,
      -45.9,
      -45.7237626787002,-45,
      -44.386611792244,
      -44.1,
      -43.8735365499905,
      -43.7103444231856,-43.2,
      -43.1111793821847,
      -42.3,
      -42.2560311420189,
      -41.4,
      -41.203062824298,-41.0455879217698,
      -40.7575047957595,
      -40.5,
      -39.9588151526594,-39.6,
      -38.8307741902173,
      -38.7,
      -38.424434946162,
      -38.0113221137767,-37.8,
      -37.6449464202301,
      -36.9,
      -36.7455334760604,
      -36,
      -35.9849226935251,-35.4297732382937,
      -35.2350367577223,
      -35.1,
      -34.3460921314719,-34.2,
      -34.0634615304908,
      -33.3,
      -32.7685708969502,
      -32.5870284604214,-32.4,
      -32.1717907666437,
      -31.8303972623042,
      -31.5,
      -30.8537488412512,-30.6,
      -30.0024129407417,
      -29.7257437162907,
      -29.7,
      -29.3567699081661,-28.8,
      -28.6638225670947,
      -28.1704512440741,
      -27.9,
      -27.5822749761105,-27,
      -26.8163514303505,
      -26.5113831896889,
      -26.1,
      -25.9354084025354,-25.4321002086696,
      -25.2,
      -24.9219070551641,
      -24.3,
      -24.0746921564182,-23.6388834752654,
      -23.4,
      -23.3577002723577,
      -22.8328479145783,-22.5,
      -22.2132686865404,
      -21.6584466024926,
      -21.6,
      -20.9740403647492,-20.7440568281192,
      -20.7,
      -20.2630132758031,
      -19.8,
      -19.5897415132193,-19.1821886725293,
      -18.9,
      -18.716461502389,
      -18,
      -17.8361858579351,-17.7481970679416,
      -17.1951794406168,
      -17.1,
      -16.8931384724686,-16.2985490142763,
      -16.2,
      -15.7077807430236,
      -15.3,
      -14.9819188892831,-14.7857944009904,
      -14.4791905721502,
      -14.4,
      -13.8942416464101,-13.5,
      -13.4963980548348,
      -12.9999716547391,
      -12.6,
      -12.3471230596688,-11.9039065115589,
      -11.7,
      -11.6078663027441,
      -11.3431446011897,-10.8834194811054,
      -10.8,
      -10.2663150117561,
      -9.89999999999999,-9.74957004282488,
      -9.21717502317465,
      -9.03235226469529,
      -9,-8.59945271932669,
      -8.09999999999999,
      -8.00395991968993,
      -7.67605605892665,-7.36949651384491,
      -7.2,
      -6.75898408584265,
      -6.3,
      -6.17393443706984,-5.89308204512594,
      -5.57429931689105,
      -5.39999999999999,
      -5.17479546407027,-4.76856410500276,
      -4.5,
      -4.19348194492561,
      -3.59999999999999,-3.35106993297335,
      -3.14196066176445,
      -2.70570216333323,
      -2.7,-2.36250523222694,
      -2.10315825911047,
      -1.8,
      -1.56498044356915,-0.899999999999991,
      -0.587971397219152,
      -0.460307962986935,
      -7.105427357601e-15,
      0,
      0.460307962986917,
      0.587971397219138,
      0.900000000000006,
      1.56498044356914,
      1.8,
      2.10315825911046,
      2.36250523222693,
      2.7,
      2.70570216333322,
      3.14196066176443,
      3.35106993297333,
      3.60000000000001,
      4.1934819449256,
      4.5,
      4.76856410500274,
      5.17479546407026,
      5.40000000000001,
      5.57429931689112,
      5.89308204512592,
      6.17393443706982,
      6.3,
      6.75898408584263,
      7.2,
      7.3694965138449,
      7.67605605892683,
      8.00395991968991,
      8.10000000000001,
      8.59945271932666,
      9,
      9.03235226469527,
      9.21717502317463,
      9.74957004282486,
      9.90000000000001,
      10.266315011756,
      10.8,
      10.8834194811054,
      11.3431446011897,
      11.607866302744,
      11.7,
      11.9039065115589,
      12.3471230596688,
      12.6,
      12.9999716547391,
      13.4963980548348,
      13.5,
      13.8942416464101,
      14.4,
      14.4791905721501,
      14.7857944009904,
      14.9819188892831,
      15.3,
      15.7077807430236,
      16.2,
      16.2985490142762,
      16.8931384724686,
      17.1,
      17.1951794406168,
      17.7481970679416,
      17.8361858579351,
      18,
      18.7164615023889,
      18.9,
      19.1821886725295,
      19.5897415132193,
      19.8,
      20.2630132758031,
      20.7,
      20.7440568281192,
      20.9740403647492,
      21.6,
      21.6584466024926,
      22.2132686865404,
      22.5,
      22.8328479145783,
      23.3577002723578,
      23.4,
      23.6388834752654,
      24.0746921564182,
      24.3,
      24.9219070551641,
      25.2,
      25.4321002086696,
      25.9354084025354,
      26.1,
      26.5113831896889,
      26.8163514303505,
      27,
      27.5822749761104,
      27.9,
      28.1704512440741,
      28.6638225670947,
      28.8,
      29.3567699081661,
      29.7,
      29.7257437162907,
      30.0024129407416,
      30.6,
      30.8537488412512,
      31.5,
      31.8303972623042,
      32.1717907666437,
      32.4,
      32.5870284604213,
      32.7685708969502,
      33.3,
      34.0634615304908,
      34.2,
      34.3460921314719,
      35.1,
      35.2350367577223,
      35.4297732382937,
      35.984922693525,
      36,
      36.7455334760604,
      36.9,
      37.6449464202301,
      37.8,
      38.0113221137766,
      38.424434946162,
      38.7,
      38.8307741902173,
      39.6,
      39.9588151526594,
      40.5,
      40.7575047957595,
      41.0455879217698,
      41.203062824298,
      41.4,
      42.2560311420189,
      42.3,
      43.1111793821847,
      43.2,
      43.7103444231856,
      43.8735365499905,
      44.1,
      44.386611792244,
      45,
      45.7237626787002,
      45.9,
      46.3610696456629,
      46.4777098116051,
      46.7915367468602,
      46.8,
      47.7,
      48.3133865397664,
      48.6,
      48.8774885144531,
      49.1443357099999,
      49.5,
      49.8386185975465,
      50.4,
      50.9871302228745,
      51.3,
      51.3076184705142,
      51.8639159267858,
      52.2,
      52.4977604998514,
      53.1,
      53.3164675529527,
      54,
      54.1596599896612,
      54.6147093647948,
      54.7349008310696,
      54.9,
      55.8,
      56.4818556868962,
      56.7,
      56.8879949713533,
      57.452682677638,
      57.6,
      58.3793960640868,
      58.5,
      59.3296879928279,
      59.4,
      60.1132221153822,
      60.3,
      60.3268947939555,
      61.2,
      62.1,
      62.3150879810862,
      63,
      63.0112930194267,
      63.7191799136004,
      63.9,
      64.8,
      65.4018621840883,
      65.7,
      65.9889341952948,
      66.6,
      67.5,
      67.5814324446233,
      68.4,
      68.829296212039,
      69.3,
      69.4435627190163,
      70.2,
      71.1,
      71.6104921895808,
      72,
      72.7652431646884,
      72.9,
      73.8,
      74.7,
      74.8478628394576,
      75.6,
      76.5,
      77.4,
      77.4386418392484,
      78.3,
      79.2,
      79.5386956295128,
      80.1,
      81,
      81.9,
      82.8,
      83.0247876071578,
      83.7,
      84.6,
      85.5,
      86.4,
      87.3,
      88.2,
      89.1,
      89.9999514924312,
      90,-90,
      -89.9999514999454,
      -89.1,
      -88.2,
      -87.3,
      -86.4,
      -85.5,
      -84.6,-83.7,
      -83.0247876071577,
      -82.8,
      -81.9,
      -81,
      -80.1,
      -79.5386956295128,-79.2,
      -78.3,
      -77.4386418392484,
      -77.4,
      -76.5,
      -75.6,
      -74.8478628394576,-74.7,
      -73.8,
      -72.9,
      -72.7652431646884,
      -72,
      -71.6104921895808,-71.1,
      -70.2,
      -69.4435627190167,
      -69.3,
      -68.8292962120391,
      -68.4,-67.5814324446233,
      -67.5,
      -66.6,
      -65.9889341952948,
      -65.7,
      -65.4018621840883,-64.8,
      -63.9,
      -63.7191799136004,
      -63.0112930194267,
      -63,
      -62.3150879810862,-62.1,
      -61.2,
      -60.3268947939555,
      -60.3,
      -60.1132221153822,
      -59.4,-59.3296879928279,
      -58.5,
      -58.3793960640868,
      -57.6,
      -57.452682677638,-56.8879949713533,
      -56.7,
      -56.4818556868962,
      -55.8,
      -54.9,
      -54.7349008310696,-54.6147093647948,
      -54.1596599896612,
      -54,
      -53.3164675529527,-53.1,
      -52.4977604998514,
      -52.2,
      -51.8639159267858,
      -51.3076184705141,-51.3,
      -50.9871302228745,
      -50.4,
      -49.8386185975465,
      -49.5,
      -49.1443357099999,-48.8774885144531,
      -48.6,
      -48.3133865397664,
      -47.7,
      -46.8,
      -46.7915367468602,-46.4777098116051,
      -46.3610696456629,
      -45.9,
      -45.7237626787002,-45,
      -44.386611792244,
      -44.1,
      -43.8735365499905,
      -43.7103444231856,-43.2,
      -43.1111793821847,
      -42.3,
      -42.2560311420189,
      -41.4,
      -41.203062824298,-41.0455879217698,
      -40.7575047957595,
      -40.5,
      -39.9588151526594,-39.6,
      -38.8307741902173,
      -38.7,
      -38.424434946162,
      -38.0113221137767,-37.8,
      -37.6449464202301,
      -36.9,
      -36.7455334760604,
      -36,
      -35.9849226935251,-35.4297732382937,
      -35.2350367577223,
      -35.1,
      -34.3460921314719,-34.2,
      -34.0634615304908,
      -33.3,
      -32.7685708969502,
      -32.5870284604214,-32.4,
      -32.1717907666437,
      -31.8303972623042,
      -31.5,
      -30.8537488412512,-30.6,
      -30.0024129407417,
      -29.7257437162907,
      -29.7,
      -29.3567699081661,-28.8,
      -28.6638225670947,
      -28.1704512440741,
      -27.9,
      -27.5822749761105,-27,
      -26.8163514303505,
      -26.5113831896889,
      -26.1,
      -25.9354084025354,-25.4321002086696,
      -25.2,
      -24.9219070551641,
      -24.3,
      -24.0746921564182,-23.6388834752654,
      -23.4,
      -23.3577002723577,
      -22.8328479145783,-22.5,
      -22.2132686865404,
      -21.6584466024926,
      -21.6,
      -20.9740403647492,-20.7440568281192,
      -20.7,
      -20.2630132758031,
      -19.8,
      -19.5897415132193,-19.1821886725293,
      -18.9,
      -18.716461502389,
      -18,
      -17.8361858579351,-17.7481970679416,
      -17.1951794406168,
      -17.1,
      -16.8931384724686,-16.2985490142763,
      -16.2,
      -15.7077807430236,
      -15.3,
      -14.9819188892831,-14.7857944009904,
      -14.4791905721502,
      -14.4,
      -13.8942416464101,-13.5,
      -13.4963980548348,
      -12.9999716547391,
      -12.6,
      -12.3471230596688,-11.9039065115589,
      -11.7,
      -11.6078663027441,
      -11.3431446011897,-10.8834194811054,
      -10.8,
      -10.2663150117561,
      -9.89999999999999,-9.74957004282488,
      -9.21717502317465,
      -9.03235226469529,
      -9,-8.59945271932669,
      -8.09999999999999,
      -8.00395991968993,
      -7.67605605892665,-7.36949651384491,
      -7.2,
      -6.75898408584265,
      -6.3,
      -6.17393443706984,-5.89308204512594,
      -5.57429931689105,
      -5.39999999999999,
      -5.17479546407027,-4.76856410500276,
      -4.5,
      -4.19348194492561,
      -3.59999999999999,-3.35106993297335,
      -3.14196066176445,
      -2.70570216333323,
      -2.7,-2.36250523222694,
      -2.10315825911047,
      -1.8,
      -1.56498044356915,-0.899999999999991,
      -0.587971397219152,
      -0.460307962986935,
      -7.105427357601e-15,
      0,
      0.460307962986917,
      0.587971397219138,
      0.900000000000006,
      1.56498044356914,
      1.8,
      2.10315825911046,
      2.36250523222693,
      2.7,
      2.70570216333322,
      3.14196066176443,
      3.35106993297333,
      3.60000000000001,
      4.1934819449256,
      4.5,
      4.76856410500274,
      5.17479546407026,
      5.40000000000001,
      5.57429931689112,
      5.89308204512592,
      6.17393443706982,
      6.3,
      6.75898408584263,
      7.2,
      7.3694965138449,
      7.67605605892683,
      8.00395991968991,
      8.10000000000001,
      8.59945271932666,
      9,
      9.03235226469527,
      9.21717502317463,
      9.74957004282486,
      9.90000000000001,
      10.266315011756,
      10.8,
      10.8834194811054,
      11.3431446011897,
      11.607866302744,
      11.7,
      11.9039065115589,
      12.3471230596688,
      12.6,
      12.9999716547391,
      13.4963980548348,
      13.5,
      13.8942416464101,
      14.4,
      14.4791905721501,
      14.7857944009904,
      14.9819188892831,
      15.3,
      15.7077807430236,
      16.2,
      16.2985490142762,
      16.8931384724686,
      17.1,
      17.1951794406168,
      17.7481970679416,
      17.8361858579351,
      18,
      18.7164615023889,
      18.9,
      19.1821886725295,
      19.5897415132193,
      19.8,
      20.2630132758031,
      20.7,
      20.7440568281192,
      20.9740403647492,
      21.6,
      21.6584466024926,
      22.2132686865404,
      22.5,
      22.8328479145783,
      23.3577002723578,
      23.4,
      23.6388834752654,
      24.0746921564182,
      24.3,
      24.9219070551641,
      25.2,
      25.4321002086696,
      25.9354084025354,
      26.1,
      26.5113831896889,
      26.8163514303505,
      27,
      27.5822749761104,
      27.9,
      28.1704512440741,
      28.6638225670947,
      28.8,
      29.3567699081661,
      29.7,
      29.7257437162907,
      30.0024129407416,
      30.6,
      30.8537488412512,
      31.5,
      31.8303972623042,
      32.1717907666437,
      32.4,
      32.5870284604213,
      32.7685708969502,
      33.3,
      34.0634615304908,
      34.2,
      34.3460921314719,
      35.1,
      35.2350367577223,
      35.4297732382937,
      35.984922693525,
      36,
      36.7455334760604,
      36.9,
      37.6449464202301,
      37.8,
      38.0113221137766,
      38.424434946162,
      38.7,
      38.8307741902173,
      39.6,
      39.9588151526594,
      40.5,
      40.7575047957595,
      41.0455879217698,
      41.203062824298,
      41.4,
      42.2560311420189,
      42.3,
      43.1111793821847,
      43.2,
      43.7103444231856,
      43.8735365499905,
      44.1,
      44.386611792244,
      45,
      45.7237626787002,
      45.9,
      46.3610696456629,
      46.4777098116051,
      46.7915367468602,
      46.8,
      47.7,
      48.3133865397664,
      48.6,
      48.8774885144531,
      49.1443357099999,
      49.5,
      49.8386185975465,
      50.4,
      50.9871302228745,
      51.3,
      51.3076184705142,
      51.8639159267858,
      52.2,
      52.4977604998514,
      53.1,
      53.3164675529527,
      54,
      54.1596599896612,
      54.6147093647948,
      54.7349008310696,
      54.9,
      55.8,
      56.4818556868962,
      56.7,
      56.8879949713533,
      57.452682677638,
      57.6,
      58.3793960640868,
      58.5,
      59.3296879928279,
      59.4,
      60.1132221153822,
      60.3,
      60.3268947939555,
      61.2,
      62.1,
      62.3150879810862,
      63,
      63.0112930194267,
      63.7191799136004,
      63.9,
      64.8,
      65.4018621840883,
      65.7,
      65.9889341952948,
      66.6,
      67.5,
      67.5814324446233,
      68.4,
      68.829296212039,
      69.3,
      69.4435627190163,
      70.2,
      71.1,
      71.6104921895808,
      72,
      72.7652431646884,
      72.9,
      73.8,
      74.7,
      74.8478628394576,
      75.6,
      76.5,
      77.4,
      77.4386418392484,
      78.3,
      79.2,
      79.5386956295128,
      80.1,
      81,
      81.9,
      82.8,
      83.0247876071578,
      83.7,
      84.6,
      85.5,
      86.4,
      87.3,
      88.2,
      89.1,
      89.9999514924312,
      90
    ),
    .Dim = c(955L, 2L),
    .Dimnames = list(NULL, c("lon", "lat"))
  ),
  bbox = structure(
    c(-180,-90, 180, 90),
    .Dim = c(2L, 2L),
    .Dimnames = list(c("lon", "lat"), c("min", "max"))
  ),
  proj4string = crsLL)