% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{indicators}
\alias{indicators}
\alias{register_indicator}
\alias{available_indicators}
\title{Register or list indicators in mapme.biodiversity}
\usage{
register_indicator(name = NULL, description = NULL, resources = NULL)

available_indicators(indicators = NULL)
}
\arguments{
\item{name}{A character vector indicating the name of the indicator.}

\item{description}{A character vector with a basic description}

\item{resources}{A character vector of the required resources
that need to be available to calculate the indicator. The names must
correspond with already registered resources.}

\item{indicators}{If \code{NULL} returns a list of all registered indicators
(default). Otherwise only the ones specified.}
}
\value{
\code{register_indicator()} is called for the side-effect of registering
an indicator

\code{available_resources()} returns a tibble listing available indicators.
}
\description{
\code{register_indicator()} is used to register a new indicator function with base
information to the package's internal environment used to inform users about
available indicators. Note, registering a custom indicator will
only have effect for the current R session.

\code{available_indicators()} returns a tibble of registered indicators with basic
information such as the required resources.
}
\examples{
\dontrun{
register_indicator(
  name = "treecover_area",
  description = "Area of forest cover by year",
  resources = c(
    "gfw_treecover",
    "gfw_lossyear"
  )
)
}
available_indicators()
}
