% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_burned_area.R
\name{burned_area}
\alias{burned_area}
\alias{calc_burned_area}
\title{Calculate Monthly Burned Area based on MODIS (MCD64A1)}
\usage{
calc_burned_area(engine = "extract")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
\value{
A function that returns an indicator tibble with variable burned
area and corresponding area (in ha) as values.
}
\description{
Calculates Monthly Burned Area based on the Terra and Aqua combined
MCD64A1 Version 6.1. which s a monthly, global gridded 500 meter (m)
product containing per-pixel burned-area information.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{mcd64a1}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_mcd64a1(years = 2010)) \%>\%
  calc_indicators(calc_burned_area(engine = "extract")) \%>\%
  portfolio_long()

aoi
}
}
\references{
Giglio, L., C. Justice, L. Boschetti, D. Roy. MODIS/Terra+Aqua
Burned Area Monthly L3 Global 500m SIN Grid V061. 2021, distributed by
NASA EOSDIS Land Processes Distributed Active Archive Center.
\doi{https://doi.org/10.5067/MODIS/MCD64A1.061}
}
\keyword{indicator}
