% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecoverloss_emissions.R
\docType{data}
\name{treecoverloss_emissions}
\alias{treecoverloss_emissions}
\title{Calculate emission statistics}
\format{
A tibble with a column for years and emissions (in Mg)
}
\description{
This functions allows to efficiently calculate emission statistics for
areas of interest. For each year in the analysis timeframe, the forest losses
from Hansen et al. (2013) are overlayed with the respective emission layer
from Harris et al. (2021) and area-wise emission statistics are calculated
for each year.
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
\item \link{gfw_emissions}.
}
}
\details{
The following arguments can be set:
\describe{
\item{min_size}{The minimum size of a forest patch to be considered as forest in ha.}
\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources(
    resources = c("gfw_treecover", "gfw_lossyear", "gfw_emissions"),
    vers_treecover = "GFC-2021-v1.9", vers_lossyear = "GFC-2021-v1.9"
  ) \%>\%
  calc_indicators("treecoverloss_emissions", min_size = 1, min_cover = 30) \%>\%
  tidyr::unnest(treecoverloss_emissions)

aoi
}
}
\keyword{indicator}
