% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_elevation.R
\docType{data}
\name{elevation}
\alias{elevation}
\title{Calculate elevation statistics}
\format{
A tibble with a column for elevation statistics (in meters)
}
\description{
This function allows to efficiently calculate elevation statistics for
polygons. For each polygon, the desired statistic/s (mean, median or sd)
is/are returned.
The required resources for this indicator are:
\itemize{
\item \link{nasa_srtm}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_elevation}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character.  Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
if (Sys.getenv("NOT_CRAN") == "true") {
  library(sf)
  library(mapme.biodiversity)

  temp_loc <- file.path(tempdir(), "mapme.biodiversity")
  if (!file.exists(temp_loc)) {
    dir.create(temp_loc)
    resource_dir <- system.file("res", package = "mapme.biodiversity")
    file.copy(resource_dir, temp_loc, recursive = TRUE)
  }

  (try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
    package = "mapme.biodiversity"
  ) \%>\%
    read_sf() \%>\%
    init_portfolio(
      years = 2000:2020,
      outdir = file.path(temp_loc, "res"),
      tmpdir = tempdir(),
      add_resources = FALSE,
      cores = 1,
      verbose = FALSE
    ) \%>\%
    get_resources("nasa_srtm") \%>\%
    calc_indicators("elevation",
      stats_elevation = c("mean", "median", "sd", "var"), engine = "extract"
    ) \%>\%
    tidyr::unnest(elevation)))
}
}
\keyword{indicator}
