% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leg_comp.R
\name{leg_comp}
\alias{leg_comp}
\title{Compose a map legend}
\usage{
leg_comp(
  leg,
  type,
  val,
  pal = "Inferno",
  col = "tomato4",
  inches = 0.3,
  symbol = "circle",
  self_adjust = FALSE,
  lwd = 0.7,
  border = "#333333",
  pch = 1:seq_along(val),
  cex = rep(1, length(val)),
  title = "Legend Title",
  val_rnd = 0,
  col_na = "white",
  cex_na = 1,
  pch_na = 4,
  no_data = FALSE,
  no_data_txt = "No Data",
  box_border = "333333",
  box_cex = c(1, 1),
  horiz = FALSE
)
}
\arguments{
\item{leg}{legend object}

\item{type}{type of legend:
\itemize{
\item \strong{prop} for proportional symbols,
\item \strong{choro} for choropleth maps,
\item \strong{cont} for continuous maps,
\item \strong{typo} for typology maps,
\item \strong{symb} for symbols maps,
\item \strong{prop_line} for proportional lines maps,
\item \strong{grad_line} for graduated lines maps.
}}

\item{val}{vector of value(s) (for "prop" and "prop_line", at least c(min, max)
for "cont"),
vector of categories (for "symb" and "typo"),
break labels (for "choro" and "grad_line").}

\item{pal}{a color palette name or a vector of colors}

\item{col}{color of the symbols (for "prop") or color of the lines (for
"prop_line" and "grad_line")}

\item{inches}{size of the largest symbol (radius for circles, half width
for squares) in inches}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{self_adjust}{if TRUE values are self-adjusted to keep min, max and
intermediate rounded values}

\item{lwd}{width(s) of the symbols borders (for "prop" and "symb"),
width of the largest line (for "prop_line"), vector of line width
(for "grad_line")}

\item{border}{symbol border color(s)}

\item{pch}{type(s) of the symbols (0:25)}

\item{cex}{size(s) of the symbols}

\item{title}{title of the legend}

\item{val_rnd}{number of decimal places of the values in
the legend}

\item{col_na}{color for missing values}

\item{cex_na}{size of the symbols for missing values}

\item{pch_na}{type of the symbols for missing values}

\item{no_data}{if TRUE a "missing value" box is plotted}

\item{no_data_txt}{label for missing values}

\item{box_border}{border color of legend boxes}

\item{box_cex}{width and height size expansion of boxes,
(or offset between circles for "prop" legends with horiz = TRUE)}

\item{horiz}{if TRUE plot an horizontal legend}
}
\value{
A list of legends parameters is returned.
}
\description{
Compose a map legend with several elements.
The "type" argument defines the
legend type.
Please note that some arguments are available for all types of legend and
some others are only relevant for specific legend types.
}
\examples{
# minimal example
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
box()
leg_comp(type = "prop", val = c(10, 50, 100)) |>
  leg_comp(type = "typo", val = c("A", "B", "C")) |>
  leg_draw()
}
