% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_grid.R
\name{add_grid}
\alias{add_grid}
\title{Add Grid}
\usage{
add_grid(map, data = get_map_data(map), lon = NULL, lat = NULL,
  polyline = NULL, colour_range = NULL, cell_size = 1000,
  extruded = TRUE, elevation_scale = 1, auto_highlight = FALSE,
  highlight_colour = "#AAFFFFFF", layer_id = NULL,
  update_view = TRUE, focus_layer = FALSE)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be in
Web Mercator Projection}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{optional column of \code{data} containing the polylines, if using encoded polylines}

\item{colour_range}{vector of 6 hex colours}

\item{cell_size}{size of each cell in meters}

\item{extruded}{logical indicating if cells are elevated or not}

\item{elevation_scale}{cell elevation multiplier}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}
}
\description{
The Grid Layer renders a grid heatmap based on an array of points.
It takes the constant size all each cell, projects points into cells.
The color and height of the cell is scaled by number of points it contains.
}
\details{
\code{add_grid} supports POINT and MULTIPOINT sf objects
}
\section{data}{


If the \code{data} is a simple feature object, the geometry column is automatically
detected. If the sf object contains more than one geometry column and you want to use a specific one,
you'll need to set the active geometry using \code{sf::st_geometry( x ) <- "your_column" },
where \code{"your_column"} is the name of the column you're activating. See \code{?sf::st_geometry}
}

\examples{
\donttest{
## You need a valid access token from Mapbox
key <- 'abc'

df <- read.csv(paste0(
'https://raw.githubusercontent.com/uber-common/deck.gl-data/master/',
'examples/3d-heatmap/heatmap-data.csv'
))

df <- df[ !is.na(df$lng ), ]

mapdeck( token = key, style = mapdeck_style("dark"), pitch = 45 ) \%>\%
add_grid(
  data = df
  , lat = "lat"
  , lon = "lng"
  , cell_size = 5000
  , elevation_scale = 50
  , layer_id = "grid_layer"
  , auto_highlight = TRUE
)

## using sf object
library(sf)
sf <- sf::st_as_sf( df, coords = c("lng", "lat"))

mapdeck( token = key, style = mapdeck_style("dark"), pitch = 45 ) \%>\%
add_grid(
  data = sf
  , cell_size = 5000
  , elevation_scale = 50
  , layer_id = "grid_layer"
  , auto_highlight = TRUE
)


}

}
