% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{leaflet.providersESP.df}
\alias{leaflet.providersESP.df}
\title{Public WMS and WMTS of Spain}
\format{
A data frame object with a list of the required parameters for calling
the service:
\itemize{
\item provider: Provider name.
\item field: Description of \code{value}.
\item value: INE code of each province.
}
}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.2.0}.
}
\description{
A data frame containing information of different public WMS and WMTS
providers of Spain

This function is a implementation of the javascript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.2.0}.
}
\details{
Providers available to be passed to \code{type} are:
\itemize{
\item \strong{IDErioja:} "IDErioja"
\item \strong{IGNBase:} "IGNBase.Todo", "IGNBase.Gris", "IGNBase.TodoNoFondo,
IGNBase.Orto"
\item \strong{MDT:} "MDT.Elevaciones", "MDT.Relieve", "MDT.CurvasNivel"
\item \strong{PNOA:} "PNOA.MaximaActualidad", "PNOA.Mosaico"
\item \strong{OcupacionSuelo:} "OcupacionSuelo.Ocupacion", "OcupacionSuelo.Usos"
\item \strong{LiDAR:} "LiDAR"
\item \strong{MTN:} "MTN"
\item \strong{Geofisica:} "Geofisica.Terremotos10dias",
"Geofisica.Terremotos30dias", "Geofisica.Terremotos365dias",
"Geofisica.VigilanciaVolcanica"
\item \strong{CaminoDeSantiago:} "CaminoDeSantiago.CaminoFrances",
"CaminoDeSantiago.CaminosTuronensis", "CaminoDeSantiago.CaminosGalicia",
"CaminoDeSantiago.CaminosDelNorte", "CaminoDeSantiago.CaminosAndaluces",
"CaminoDeSantiago.CaminosCentro", "CaminoDeSantiago.CaminosEste",
"CaminoDeSantiago.CaminosCatalanes", "CaminoDeSantiago.CaminosSureste",
"CaminoDeSantiago.CaminosInsulares", "CaminoDeSantiago.CaminosPiemonts",
"CaminoDeSantiago.CaminosTolosana", "CaminoDeSantiago.CaminosPortugueses"
\item \strong{Catastro:} "Catastro.Catastro", "Catastro.Parcela",
"Catastro.CadastralParcel", "Catastro.CadastralZoning",
"Catastro.Address", "Catastro.Building"
\item \strong{RedTransporte:} "RedTransporte.Carreteras",
"RedTransporte.Ferroviario", "RedTransporte.Aerodromo",
"RedTransporte.AreaServicio", "RedTransporte.EstacionesFerroviario",
"RedTransporte.Puertos"
\item \strong{Cartociudad:} "Cartociudad.CodigosPostales", "Cartociudad.Direcciones"
\item \strong{NombresGeograficos:} "NombresGeograficos"
\item \strong{UnidadesAdm:} "UnidadesAdm.Limites", "UnidadesAdm.Unidades"
\item \strong{Hidrografia:} "Hidrografia.MasaAgua", "Hidrografia.Cuencas",
"Hidrografia.Subcuencas", "Hidrografia.POI", "Hidrografia.ManMade",
"Hidrografia.LineaCosta", "Hidrografia.Rios", "Hidrografia.Humedales"
\item \strong{Militar:} "Militar.CEGET1M", "Militar.CEGETM7814",
"Militar.CEGETM7815", "Militar.CEGETM682", "Militar.CECAF1M"
\item \strong{ADIF:} "ADIF.Vias", "ADIF.Nodos", "ADIF.Estaciones"
\item \strong{LimitesMaritimos:} "LimitesMaritimos.LimitesMaritimos",
"LimitesMaritimos.LineasBase"
\item \strong{Copernicus:} "Copernicus.LandCover", "Copernicus.Forest",
"Copernicus.ForestLeaf", "Copernicus.WaterWet", "Copernicus.SoilSeal",
"Copernicus.GrassLand", "Copernicus.Local", "Copernicus.RiparianGreen",
"Copernicus.RiparianLandCover", "Copernicus.Natura2k",
"Copernicus.UrbanAtlas"
\item \strong{ParquesNaturales:} "ParquesNaturales.Limites",
"ParquesNaturales.ZonasPerifericas"
}
}
\seealso{
\code{\link[=esp_getTiles]{esp_getTiles()}}, \code{\link[=addProviderEspTiles]{addProviderEspTiles()}}.
}
\concept{datasets}
