% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_delta_med.R
\name{coef.delta_med}
\alias{coef.delta_med}
\title{Delta_Med in a
'delta_med'-Class Object}
\usage{
\method{coef}{delta_med}(object, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=delta_med]{delta_med()}}.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
A scalar: The estimate of Delta_Med.
}
\description{
Return the estimate of
Delta_Med in a 'delta_med'-class
object.
}
\details{
It just extracts and
returns the element \code{delta_med}
in the output of \code{delta_med()},
the estimate of the Delta_Med
proposed by Liu, Yuan, and Li (2023),
an \eqn{R^2}-like measure of indirect
effect.
}
\examples{

library(lavaan)
dat <- data_med
mod <-
"
m ~ x
y ~ m + x
"
fit <- sem(mod, dat)
dm <- delta_med(x = "x",
                y = "y",
                m = "m",
                fit = fit)
dm
print(dm, full = TRUE)
coef(dm)

}
\references{
Liu, H., Yuan, K.-H., & Li, H. (2023).
A systematic framework for defining
R-squared measures in mediation
analysis. \emph{Psychological Methods}.
Advance online publication.
https://doi.org/10.1037/met0000571
}
\seealso{
\code{\link[=delta_med]{delta_med()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
