% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pipeline.R
\name{pipeline-vis}
\alias{pipeline-vis}
\alias{show_pipeline}
\alias{save_pipeline}
\title{Visualise the Pipeline.}
\usage{
show_pipeline(pipeline = get_pipeline(), tooltips = NULL, labels = NULL, ...)

save_pipeline(
  file,
  pipeline = get_pipeline(),
  tooltips = NULL,
  labels = NULL,
  selfcontained = TRUE,
  background = "white",
  ...
)
}
\arguments{
\item{pipeline}{A pipeline. See \link{Pipeline} for more details.}

\item{tooltips}{A named character vector mapping nodes in the \code{pipeline} onto
tooltips to display on hover-over.}

\item{labels}{A named character vector mapping nodes in the \code{pipeline} onto
labels to display beside them.}

\item{...}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}

\item{file}{File to save HTML into}

\item{selfcontained}{Whether to save the HTML as a single self-contained
file (with external resources base64 encoded) or a file with external
resources placed in an adjacent directory.}

\item{background}{Text string giving the html background color of the widget.
Defaults to white.}
}
\description{
Produce an HTML flowchart visualisation of the pipeline.
}
\details{
Tooltips and labels must be supplied as named character vector where the
names correspond to the filepaths of nodes (i.e. \code{targets}, \code{dependencies},
or \code{source} scripts)
}
\examples{
\dontrun{
# Run pipeline
make_with_source(
  "recode.R",
  "data/0 raw_data.R",
  "data/1 data.R"
)
make_with_source(
  "merge.R",
  c("data/1 data.R", "data/0 raw_pop.R"),
  "data/2 data.R"
)

# Visualise pipeline with custom tooltips
show_pipeline(tooltips = c(
  "data/0 raw_data.R" = "Raw survey data",
  "data/0 raw_pop.R" = "Raw population data",
  "data/1 data.R" = "Survey data with recodes applied",
  "data/2 data.R" = "Survey data with demographic variables merged in"
))
}
}
\seealso{
Other pipeline: 
\code{\link{Pipeline}},
\code{\link{pipeline-accessors}}
}
\concept{pipeline}
