% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{retrieveJSON}
\alias{retrieveJSON}
\title{Download data from magma as a json, and convert to a list}
\usage{
retrieveJSON(
  target,
  projectName,
  modelName,
  recordNames = "all",
  attributeNames = "all",
  filter = "",
  page = NULL,
  pageSize = 10,
  hideTemplate = FALSE,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{modelName}{Single string. The name of the subset data structure within the project, which are referred to as 'model's in magma, to interact with.
For options, see \code{\link{retrieveModels}} or https://timur.ucsf.edu/<projectName>/map.}

\item{recordNames}{Single string or string vector indicating which particular sample/tube/etc. records to target.
Options are "all" or any combination of individual record names. To retrieve individual options, see \code{\link{retrieveIds}}.}

\item{attributeNames}{Single string or string vector indicating which features of the data to target.
Options are "all" or any combination of individual attribute names. To retrieve individual options, see \code{\link{retrieveAttributes}}.}

\item{filter}{String. Potential filter(s) of the data.
Example: "<targetAttributeName>~GYN" to filter to records where <targetAttributeName> contains "GYN".

Refer to \url{https://mountetna.github.io/magma.html#retrieve} for more details about options and format.}

\item{page}{Integer. For retrieving just a portion of the data, sets which slice to get.}

\item{pageSize}{Integer. For retrieving just a portion of the data, sets slice/page size, which is equivalent to the a number of rows.}

\item{hideTemplate}{Logical. Allows to leave out the project template from the return. Often this does not matter much, but the template can be bulky.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
A list
}
\description{
Analogous to the '/retrieve' function of magma, with \code{format = "json"}
}
\details{
This function makes a call to magma/retrieve with \code{format = "json"}.
Then, it converts the json output into a list which is more compatible with R.
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    # Now we can retrieve data as json (->list) with...
    json_out <- retrieveJSON(
        target = magma,
        projectName = "example",
        modelName = "rna_seq",
        recordNames = "all",
        attributeNames = "all",
        filter = "")
    # The return will be a nested list with data in a 'documents' element and
    #  some extra information about each attribute in a 'template' element.
    str(json_out, max.level = 4)

    # Often, the 'template' part is bulky but not needed, so its retrieval may
    #  be turned off by giving hideTemplaate = TRUE'
    json_out <- retrieveJSON(
        target = magma,
        projectName = "example",
        modelName = "rna_seq",
        recordNames = "all",
        attributeNames = "all",
        filter = "",
        hideTemplate = TRUE)
    str(json_out, max.level = 4)
}

}
\seealso{
\code{\link{retrieve}} for similar functionality, but where the call to magma/retrieve will be made with \code{format = "tsv"} and the output is a dataframe.

\code{\link{retrieveMatrix}} for matrix data-targeted utilization of this current \code{retreiveJSON} function, followed by automated restructuring of the return into a matrix format.

\url{https://mountetna.github.io/magma.html#retrieve} for documentation of the underlying magma/retrieve function.
}
