% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.magpie.R
\name{read.magpie}
\alias{read.magpie}
\title{Read MAgPIE-object from file}
\usage{
read.magpie(
  file_name,
  file_folder = "",
  file_type = NULL,
  as.array = FALSE,
  comment.char = "*",
  check.names = FALSE,
  ...
)
}
\arguments{
\item{file_name}{file name including file ending (wildcards are supported).
Optionally also the full path can be specified here (instead of splitting it
to file_name and file_folder)}

\item{file_folder}{folder the file is located in (alternatively you can also
specify the full path in file_name - wildcards are supported)}

\item{file_type}{format the data is stored in. Currently 13 formats are
available: "rds" (recommended compressed format),
"cs2" & "cs2b" (cellular standard MAgPIE format), "csv" (regional standard
MAgPIE format), "cs3" (multidimensional format compatible to GAMS), "cs4"
(alternative multidimensional format compatible to GAMS, in contrast to cs3
it can also handle sparse data), "cs5" (more generalized version of cs4),
"csvr", "cs2r", "cs3r" and "cs4r" which are
the same formats as the previous mentioned ones with the only difference
that they have a REMIND compatible format, "m" (binary MAgPIE format
"magpie"), "mz" (compressed binary MAgPIE format "magpie zipped") "put"
(format used primarily for the REMIND-MAgPIE coupling) and "asc",
(ASCII-Grid format as used by ArcGis) . If file_type=NULL the file ending
of the file_name is used as format. If format is different to the formats
mentioned standard MAgPIE format is assumed.}

\item{as.array}{Should the input be transformed to an array? This can be
useful for regional or global inputs, but all advantages of the magpie-class
are lost.}

\item{comment.char}{character: a character vector of length one containing a
single character or an empty string. Use "" to turn off the interpretation
of comments altogether. If a comment is found it will be stored in
attr(,"comment"). In text files the comment has to be at the beginning of
the file in order to be recognized by read.magpie.}

\item{check.names}{logical. If TRUE then the names of the variables in the
data frame are checked to ensure that they are syntactically valid variable
names. Same functionality as in read.table.}

\item{...}{additional arguments passed to specific read functions (e.g.
\code{varname} for specifying the variable to be read in from a multi-variable
NCDF file.)}
}
\value{
\item{x}{MAgPIE-object}
}
\description{
Reads a MAgPIE-file and converts it to a 3D array of the structure
(cells,years,datacolumn)
}
\details{
This function reads from 13 different MAgPIE file_types. "rds" is
a R-default format for storing R objects."cs2" or "cs2b" is the new standard
format for cellular data with or without
header and the first columns (year,regiospatial) or only (regiospatial),
"csv" is the standard format for regional data with or without header
and the first columns (year,region,cellnumber) or only (region,cellnumber).
"cs3" is a format similar to csv and cs2, but with the difference that it supports
multidimensional data in a format which can be read by GAMS, "put" is a
newly supported format which is mosty used for the REMIND-MAgPIE coupling.
This format is only partly supported at the moment.  "asc" is the AsciiGrid
format (for example used for Arc Gis data).  "nc" is the netCDF format (only
"nc" files written by write.magpie can be read).  All these variants are
read without further specification. "magpie" (.m) and "magpie zipped" (.mz)
are new formats developed to allow a less storage intensive management of
MAgPIE-data. The only difference between both formats is that .mz is gzipped
whereas .m is not compressed. So .mz needs less memory, whereas .m might
have a higher compatibility to other languages. \cr\cr Since library version
1.4 read.magpie can also read regional or global MAgPIE csv-files.
}
\note{
The binary MAgPIE formats .m and .mz have the following content/structure
(you only have to care for that if you want to implement
read.magpie/write.magpie functions in other languages): \cr \cr
[ FileFormatVersion | Current file format version number (currently 6) | integer | 2 Byte ] \cr
[ ncharComment | Number of character bytes of the file comment | integer | 4 Byte ] \cr
[ nbyteMetadata | Number of bytes of the serialized metadata | integer | 4 Byte ] \cr
[ ncharSets | Number of characters bytes of all regionnames + 2 delimiter | integer | 2 Byte] \cr
[ nyears | Number of years | integer | 2 Byte ]\cr
[ yearList | All years of the dataset (0, if year is not present) | integer | 2*nyears Byte ] \cr
[ ncells | Number of cells | integer | 4 Byte ]\cr
[ nchar_cell | Number of characters bytes of all regionnames + (nreg-1) for delimiters | integer | 4 Byte ] \cr
[ cells | Cell names saved as cell1\\cell2 (\\n is the delimiter) | character | 1*nchar_cell Byte ] \cr
[ nelem | Total number of data elements | integer | 4 Byte ] \cr
[ ncharData | Number of char. bytes of all datanames + (ndata - 1) for delimiters | integer | 4 Byte ] \cr
[ datanames | Names saved in the format data1\\ndata2 (\\n as del.) | character | 1*ncharData Byte ] \cr
[ data | Data of the MAgPIE array in vectorized form | numeric | 4*nelem Byte ] \cr
[ comment | Comment with additional information about the data | character | 1*ncharComment Byte ] \cr
[ sets | Set names with \\n as delimiter | character | 1*ncharSets Byte] \cr
[ metadata | serialized metadata information | bytes | 1*nbyteMetadata Byte] \cr
}
\seealso{
\code{"\linkS4class{magpie}"}, \code{\link{write.magpie}}
}
\author{
Jan Philipp Dietrich, Stephen Bi, Florian Humpenoeder
}
