% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNames.R
\name{getNames}
\alias{getNames}
\alias{getNames<-}
\title{Get dataset names}
\usage{
getNames(x, fulldim = FALSE, dim = NULL)

getNames(x, dim = NULL) <- value
}
\arguments{
\item{x}{MAgPIE object}

\item{fulldim}{specifies, how the object is treated. In case of FALSE, it is
assumed that x is 3 dimensional and dimnames(x)[[3]] is returned. In case of
TRUE, the dimnames of the real third dimension namesare returned}

\item{dim}{Argument to choose a specific data dimension either by name of
the dimension or by number of the data dimension.}

\item{value}{a vector of names current names should be replaced with. If
only one data element exists you can also set the name to NULL.}
}
\value{
getNames returns data names of the MAgPIE-object, whereas setNames
returns the MAgPIE object with the manipulated data names.
}
\description{
Extracts dataset names of a MAgPIE-object
}
\details{
setNames is a shortcut to use a MAgPIE object with manipulated data names.
The setNames method uses the variable names "object" and "nm" in order to be
consistent to the already existing function setNames.
}
\section{Functions}{
\itemize{
\item \code{getNames<-}: set names
}}

\examples{

 a <- as.magpie(1)
 getNames(a)
 setNames(a,"bla")
 
 x <- new.magpie("GLO",2000,c("a.o1","b.o1","a.o2"))
 getNames(x,dim=2)
 
 getSets(x,fulldim=FALSE)[3] <- "bla.blub"
 getNames(x,dim="bla")
 
 getSets(x)[4] <- "ble"
 getNames(x,dim="ble") <- c("Hi","Bye")
 x

}
\seealso{
\code{\link{setNames-methods}}, \code{\link{getRegions}}, \code{\link{getYears}},
\code{\link{getCPR}}, \code{\link{read.magpie}},
\code{\link{write.magpie}},\code{\link{ndata}},
\code{"\linkS4class{magpie}"}
}
\author{
Jan Philipp Dietrich
}
