% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCells.R, R/setCells.R
\name{getCells}
\alias{getCells}
\alias{getCells<-}
\alias{setCells}
\title{Get Cells}
\usage{
getCells(x)

getCells(x) <- value

setCells(object, nm = "GLO.1")
}
\arguments{
\item{x, object}{MAgPIE object}

\item{value, nm}{cell names the data should be set to.}
}
\value{
getCells returns cell names of the MAgPIE-object, whereas setCells
returns the MAgPIE object with the manipulated cell names.
}
\description{
Extracts cell names of a MAgPIE-object
}
\details{
setCells is a shortcut to use a MAgPIE object with manipulated cell names.
setCells uses the variable names "object" and "nm" in order to be consistent
to the already existing function setNames.
}
\section{Functions}{
\itemize{
\item \code{getCells<-}: set cell names

\item \code{setCells}: set cell names
}}

\examples{

 a <- as.magpie(1)
 getCells(a)
 setCells(a,"AFR.1")

}
\seealso{
\code{\link{getRegions}}, \code{\link{getNames}},
\code{\link{setNames}}, \code{\link{getCPR}}, \code{\link{read.magpie}},
\code{\link{write.magpie}}, \code{"\linkS4class{magpie}"}
}
\author{
Jan Philipp Dietrich
}
