% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_objective.r
\name{to_objective}
\alias{to_objective}
\title{Convert a madness object into an objective value with gradient}
\usage{
to_objective(X)
}
\arguments{
\item{X}{a \code{madness} object representing a scalar.}
}
\value{
A scalar numeric with a \code{gradient} attribute of the derivative.
}
\description{
Given a \code{madness} object representing a scalar value, strip out
that value and attach an attribute of its derivative as a gradient.
This is a convenience method that simplifies construction of objective
functions for optimization routines.
}
\note{
An error will be thrown if the value is not a scalar.
}
\examples{
# an objective function for matrix factorization with penalty:
fitfun <- function(R,L,Y,nu=-0.1) {
Rmad <- madness(R)
dim(Rmad) <- c(ncol(L),ncol(Y))
Err <- Y - L \%*\% Rmad
penalty <- sum(exp(nu * Rmad))
fit <- norm(Err,'f') + penalty
to_objective(fit)
}
set.seed(1234)
L <- array(runif(30*5),dim=c(30,5)) 
Y <- array(runif(nrow(L)*20),dim=c(nrow(L),20))
R0 <- array(runif(ncol(L)*ncol(Y)),dim=c(ncol(L),ncol(Y)))
obj0 <- fitfun(R0,L,Y)
fooz <- nlm(fitfun, R0, L, Y, iterlim=3)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}

