% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagRows.R
\name{lagRows}
\alias{lagRows}
\title{Create lagged variables}
\usage{
lagRows(data, var, by = NULL, lag_var = NULL)
}
\arguments{
\item{data}{Dataset}

\item{var}{Existing variable}

\item{by}{If specified, lagged variable is created grouped by this variable.
If not specified, it is created taking the whole variable.}

\item{lag_var}{name for lagged variable}
}
\value{
Modified Dataset
}
\description{
\code{lagRows()} creates lagged version of existing variables
}
\details{
This is often encountered in time-related analysis.
In a lagged variable, values from earlier points in time are placed in later
rows of dataset.
}
\note{
Before using \code{lagRows}, the dataset needs to be sorted by a id variable
or similar variable.
}
\examples{


## create a dataset with dates
df <- data.frame(
    hospid = 1:100,
    docid = round(runif(100, 1, 10)),
    dis_date = formatDate(runif(100, 42700, 42800))
)

## lagged dis_date, not specifed "by"
lagRows(df, dis_date)

## lagged dis_date by docid
## first we need to sort
df1 <- arrange(df, docid)
df1
lagRows(df1, dis_date, by = docid, lag_var = "lag_date")


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
