% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\title{Create a new variable}
\usage{
generate(data, var, .expr = NULL)
}
\arguments{
\item{data}{Dataset}

\item{var}{New variable}

\item{.expr}{value or Expression for simple arithmetic or logical operations:
See examples.}
}
\description{
\code{generate()} creates a new variable within the data frame
}
\details{
If the data is specified, it returns modified dataset with
newly created variable.
The value of the variable are specified by \code{expr} argument.
}
\examples{

## use infert data
data(infert)
codebook(infert)

## create a new variable induced2 with 0 and 1+2
infert.new <- generate(infert, induced2, as.numeric(induced == 0))
tab(infert.new, induced2)

## create a new variable with values the same as education
infert.new <- generate(infert, edu, education)
tab(infert.new, edu)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
