% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-older-than.R
\name{search_older_than}
\alias{search_older_than}
\title{Search Within seconds}
\usage{
search_older_than(imapconf, seconds, negate = FALSE, by = "MSN",
  flag = NULL, esearch = FALSE, return_imapconf = TRUE,
  retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{seconds}{An integer specifying the number of seconds to be used as
search criterion.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{flag}{Optional parameter that adds a flag filter to the search. Use
\link{flag_options} to list the common flags used by IMAP servers.
Default is \code{NULL}.}

\item{esearch}{A logical. Default is \code{FALSE}. If the IMAP server has
\code{ESEARCH} capability, it can be used to optimize search results. It
allows to condense results to message sets to cut down on transmission
costs, e.g. \code{1:5} instead of writing ids individually such as
\code{1,2,3,4,5}. It can be used along with buffersize to avoid results
stripping. Check if your IMAP server supports \code{SEARCH} with
\code{\link{list_server_capabilities}}.}

\item{return_imapconf}{A logical. If \code{TRUE}, the function returns a
\code{list} of length \code{2}, containing the \code{imapconf} object
(IMAP settings) and the search results as message ids (\code{"MSN"} or
\code{"UID"}). If \code{FALSE}, returns only the message ids as a numeric
vector. Default is \code{TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
Depending on the \code{return_imapconf} parameter, it can be a
    \code{list} of length \code{2} containing the \code{imapconf} object
    and message ids resulted from search, or a numeric vector containing
    only message ids.
}
\description{
Searches for messages within a number of seconds from the
    server’s current time to fetch messages.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# search
results <- imapconf \%>\%
    select_mailbox(mbox = "Smiles GOL") \%>\%
    search_older_than(seconds = 3600)

}

}
\seealso{
Other Within-search operations: \code{\link{custom_search}},
  \code{\link{search_younger_than}}
}
\concept{Within-search operations}
