% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/older-than.R
\name{older_than}
\alias{older_than}
\title{Criteria Helper Functions for Custom Search}
\usage{
older_than(seconds, negate = FALSE)
}
\arguments{
\item{seconds}{An integer specifying the number of seconds to be used as
search criterion.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}
}
\value{
A search string to be used as a \code{custom_request} parameter in
    \link{custom_search} function.
}
\description{
Criteria helper functions to be combined inside a operator helper
    function as a custom request in \link{custom_search}.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )

# search
result <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    custom_search(custom_request =
                 OR(string(
                       section_or_field = "from", string = "allanvcq@gmail.com"),
                    older_than(
                       seconds = 3600)
                   )
                 )
# searches for messages containing the string "allanvcq@gmail.com" in the
# field "FROM" OR messgaes that are "older" than one hour (messages arrived
# more than 3600 seconds ago).

}

}
\seealso{
Other customsearch helper functions: \code{\link{AND}},
  \code{\link{OR}}, \code{\link{before}},
  \code{\link{flag}}, \code{\link{larger_than}},
  \code{\link{on}}, \code{\link{sent_before}},
  \code{\link{sent_on}}, \code{\link{sent_since}},
  \code{\link{since}}, \code{\link{smaller_than}},
  \code{\link{string}}, \code{\link{younger_than}}
}
\concept{customsearch helper functions}
