% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\alias{plot_scatter}
\alias{plot_line}
\alias{plot_hist}
\alias{plot_qq}
\title{Quick plotting}
\usage{
plot_scatter(data, x, y, ...)

plot_line(data, x, y, ...)

plot_hist(data, x, bin_width = NULL, ...)

plot_qq(data, x, ...)
}
\arguments{
\item{data}{A data frame.}

\item{x, y}{x and y aesthetics as the bare (unquoted) name of a column in
\code{data}.}

\item{...}{Additional arguments to be passed to the \code{ggplot2::aes()}
function.}

\item{bin_width}{The width of the bins in a histogram. When \code{NULL}
(default), it uses the number of bins in \code{bins} (defaults to 30).
You can also use one of the character strings \code{"Sturges"},
\code{"scott"} or \code{"FD"} to use one of the methods to determine the
bin width as in \href{https://rdrr.io/r/grDevices/nclass.html}{\code{grDevices::nclass.*()}}}
}
\value{
A \code{ggplot} object.
}
\description{
These functions are intended to be used to quickly generate simple
exploratory plots using the package \code{ggplot2}.
}
\examples{
plot_scatter(mtcars, disp, mpg, color = factor(cyl))
plot_line(Orange, age, circumference, colour = Tree)
plot_hist(iris, Petal.Width, bin_width = "FD")
plot_qq(mtcars, mpg)
}
