% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryToCensoring.R
\name{BinaryToCensoring}
\alias{BinaryToCensoring}
\title{BinaryToCensoring}
\usage{
BinaryToCensoring(is.censored, is.uncensored)
}
\arguments{
\item{is.censored}{binary vector: 0=uncensored, 1=censored}

\item{is.uncensored}{binary vector: 0=censored, 1=uncensored}
}
\value{
an object of class "\code{factor}" with levels "censored" and
"uncensored"
}
\description{
Helper function for creating censoring columns as factors.
}
\details{
Exactly one of \code{is.censored} and \code{is.uncensored} must be specified
as a \emph{named} argument.  All elements of the input vector must be 0, 1,
or \code{NA}
}
\examples{

 BinaryToCensoring(is.censored=c(0, 1, 1, 0, NA))
 BinaryToCensoring(is.uncensored=c(1, 0, 0, 1, NA))   #the same
 
 \dontrun{
 BinaryToCensoring(c(0, 1))   #error because the input must be named
 }

}
\seealso{
\code{\link{factor}}
}
\author{
Joshua Schwab \email{joshuaschwab@yahoo.com}
}
