% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.lsm.R
\encoding{UTF-8}
\name{confint.lsm}
\alias{confint.lsm}
\title{Confidence Intervals for \code{lsm}  Objects}
\usage{
\method{confint}{lsm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The type of prediction required. The default is on the scale of the linear predictors. The alternative \code{response} gives the predicted probabilities.}

\item{parm}{calculate confidence intervals for the coefficients}

\item{level}{It gives the desired confidence level for the confidence interval. For example, a default value is level = 0.95, which will generate a 95% confidence interval."
The alternative \code{response} gives the predicted probabilities.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{lsm} returns an object of class "\code{lsm}".

 An object of class "\code{lsm}" is a list containing at least the
 following components:

\item{object}{a \code{lsm} object}
\item{parm}{calculate confidence intervals for the coefficients.}
\item{level}{confidence levels}
\item{\dots}{Additional arguments to be passed to methods.}
}
\description{
Provides a confint method for \code{lsm}  objects.
}
\details{
confint Method for lsm

The saturated model is characterized by the assumptions 1 and 2 presented in section 2.3 by Llinas (2006, ISSN:2389-8976).
}
\examples{
 # datos <- lsm::icu
 # attach(datos)
 # modelo <- lsm(STA~AGE + as.factor(RACE), data=icu)
 # confint(modelo)
}
\references{
[1] LLinás, H. J. (2006). Precisiones en la teoría de los modelos logísticos. Revista Colombiana de Estadística, 29(2), 239–265. https://revistas.unal.edu.co/index.php/estad/article/view/29310

[2] Hosmer, D.W., Lemeshow, S. and Sturdivant, R.X. (2013). Applied Logistic Regression, 3rd ed., New York: Wiley.

[3] Chambers, J. M. and Hastie, T. J. (1992). Statistical Models in S. Wadsworth & Brooks/Cole.
}
\author{
Jorge Villalba Acevedo [cre, aut], (Universidad Tecnológica de Bolívar, Cartagena-Colombia).
}
