% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignOneRateExact}
\alias{getDesignOneRateExact}
\title{Power and Sample Size for One-Sample Poisson Rate Exact Test}
\usage{
getDesignOneRateExact(
  beta = NA_real_,
  n = NA_real_,
  lambdaH0 = NA_real_,
  lambda = NA_real_,
  D = 1,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{lambdaH0}{The Poisson rate under the null hypothesis.}

\item{lambda}{The Poisson rate under the alternative hypothesis.}

\item{D}{The average exposure per subject.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
A data frame containing the following variables:
\itemize{
\item \code{alpha}: The specified significance level.
\item \code{attainedAlpha}: The attained type I error of the exact test.
\item \code{power}: The actual power of the exact test.
\item \code{n}: The sample size.
\item \code{lambdaH0}: The Poisson rate under the null hypothesis.
\item \code{lambda}: The Poisson rate under the alternative hypothesis.
\item \code{D}: The average exposure per subject.
\item \code{r}: The critical value of the number of events for rejecting
the null hypothesis. Reject H0 if \code{Y >= r} for upper-tailed
test, and reject H0 if \code{Y <= r} for lower-tailed test.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for one-sample Poisson rate.
}
\examples{

# Example 1: power calculation
(design1 <- getDesignOneRateExact(
  n = 525, lambdaH0 = 0.049, lambda = 0.012,
  D = 0.5, alpha = 0.025))

# Example 2: sample size calculation
(design2 <- getDesignOneRateExact(
  beta = 0.2, lambdaH0 = 0.2, lambda = 0.3,
  D = 1, alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
