% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsim}
\alias{lrsim}
\title{Log-rank test simulation}
\usage{
lrsim(
  kMax = NA_integer_,
  informationTime = NA_real_,
  criticalValues = NA_real_,
  futilityBounds = NA_real_,
  hazardRatioH0 = 1,
  allocation1 = 1L,
  allocation2 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  plannedTime = NA_real_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationTime}{Information time in terms of variance of
weighted log-rank test score statistic under the null hypothesis.
Same as \code{informationRates} in terms of number of events for
the conventional log-rank test. Use \code{caltime} and \code{lrstat}
to derive the information time for weighted log-rank tests.
Fixed prior to the trial. If left unspecified, it defaults to
\code{plannedEvents / plannedEvents[kMax]} when \code{plannedEvents} 
is provided and to \code{plannedTime / plannedTime[kMax]} otherwise.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocation1}{Number of subjects in the active treatment group in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in the control group in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout. A vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout. A vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of 
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of 
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number of events at each
stage.}

\item{plannedTime}{The calendar times for the analyses. To use calendar
time to plan the analyses, \code{plannedEvents} should be missing.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per stage
to extract. Defaults to 1.}

\item{seed}{The seed to reproduce the simulation results.
The computer clock will be used if left unspecified,}
}
\value{
A list of S3 class \code{lrsim} with 3 components:

* \code{overview} is a list containing incremental and cumulative
efficacy and futility stopping probabilities by stage, expected number
of events, number of dropouts, number of subjects, analysis time
by stage, overall rejection probability, overall expected number of
events, number of dropouts, number of subjects, study duration,
hazard ratio under H0, and whether the analyses are planned 
based on the number of events or calendar time.

* \code{sumdata} is a data frame of summary data by stage for each
iteration, containing at which stage the trial stops, whether the target
number of events is achieved, the analysis time, number of accrued
subjects overall and by treatment group, number of events overall and by
treatment group, number of dropouts overall and by treatment group,
numerator and variance of weighted log-rank score statistic, log-rank
test Z-statistic, and whether the trial stops for efficacy or futility
at the stage.


* \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
positive integer) is a data frame for subject-level data for selected
replications, containing the subject number, arrival time, stratum,
treatment group, survival time, dropout time, observation time when
the trial stops, time under observation, and event and dropout
indicators.
}
\description{
Performs simulation for two-arm group sequential
trials based on weighted log-rank test.
}
\examples{
# Example 1: analyses based on number of events

sim1 = lrsim(kMax = 2, informationTime = c(0.5, 1),
             criticalValues = c(2.797, 1.977),
             accrualIntensity = 11,
             lambda1 = 0.018, lambda2 = 0.030,
             accrualDuration = 12,
             plannedEvents = c(60, 120),
             maxNumberOfIterations = 1000,
             maxNumberOfRawDatasetsPerStage = 1,
             seed = 314159)

# summary statistics
sim1

# summary for each simulated data set
head(sim1$sumdata)

# raw data for selected replication
head(sim1$rawdata)


# Example 2: analyses based on calendar time have similar power

sim2 = lrsim(kMax = 2, informationTime = c(0.5, 1),
             criticalValues = c(2.797, 1.977),
             accrualIntensity = 11,
             lambda1 = 0.018, lambda2 = 0.030,
             accrualDuration = 12,
             plannedTime = c(31.9, 113.2),
             maxNumberOfIterations = 1000,
             maxNumberOfRawDatasetsPerStage = 1,
             seed = 314159)

# summary statistics
sim2

# summary for each simulated data set
head(sim2$sumdata)

}
