% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qtpwexp}
\alias{qtpwexp}
\title{Quantile function of truncated piecewise exponential distribution}
\usage{
qtpwexp(
  probability = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda = NA_real_,
  lowerBound = 0
)
}
\arguments{
\item{probability}{The probabilities corresponding to the quantiles.}

\item{piecewiseSurvivalTime}{A vector of starting times defining the time
pieces, must start with 0. Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates, one for each time interval.}

\item{lowerBound}{The left truncation time point for the survival time.
Defaults to 0 for no truncation.}
}
\value{
A vector of quantiles x such that
P(X > x | X > lowerBound) = 1 - probability.
}
\description{
Obtains the quantile of a piecewise expoenential distribution
given that it exceeds a specified lower bound.
}
\examples{
qtpwexp(probability = c(0.3, 0.5), piecewiseSurvivalTime = c(0, 6, 9, 15),
        lambda = c(0.025, 0.04, 0.015, 0.007))

}
