% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLMetaData_as.R
\name{as_list}
\alias{as_list}
\title{Coerce LPJmLMetaData to a list}
\usage{
as_list(x)
}
\arguments{
\item{x}{An \link{LPJmLMetaData} object}
}
\value{
A \link[base]{list}
}
\description{
Function to coerce (convert) an \code{\link{LPJmLMetaData}} object into a
\link[base]{list}.
}
\examples{
\dontrun{

vegc_meta <- read_meta(filename = "./vegc.bin.json")

# Returns one dimensional array with timeseries for cells `27410:27415`
as_list(vegc_meta)
# $sim_name
# [1] "lu_cf"
#
# $source
# [1] "LPJmL C Version 5.3.001"
#
# $variable
# [1] "vegc"
#
# $descr
# [1] "vegetation carbon"
#
# $unit
# [1] "gC/m2"
#
# $nbands
# [1] 1
#
# ...

}

}
