% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.lphom}
\alias{print.lphom}
\title{Print a summary of a lphom-family object}
\usage{
\method{print}{lphom}(x, ..., margins = TRUE, digits = 2)
}
\arguments{
\item{x}{An object output of a \strong{lphom} family algorithm.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{margins}{A TRUE/FALSE argument informing if the margins of the matrix should be displayed. Default TRUE.}

\item{digits}{Integer indicating the number of decimal places to be shown. Default, 2.}
}
\description{
Print method for objects obtained with an algorithm of the lphom-family (lphom, tslphom, nslphom, tslphom_dual, nslphom_joint, ....).
}
\examples{
mt.ns <- nslphom(France2017P[, 1:8] , France2017P[, 9:12], new_and_exit_voters= "raw")
print(mt.ns, digits = 2, margins = TRUE)

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
