################################################################################
#' @title lpdensity: Local Polynomial Density Estimation and Inference
#'
#' @description Without imposing stringent distributional assumptions or shape restrictions,
#'   nonparametric density estimation has been popular in economics and other social
#'   sciences for counterfactual analysis, program evaluation, and policy recommendations.
#'   This package implements a novel density estimator based on local polynomial
#'   regression, documented in \href{https://arxiv.org/abs/1811.11512}{Cattaneo, Jansson and Ma (2019a)}: \code{\link{lpdensity}}
#'   to construct local polynomial based density estimator; \code{\link{lpbwdensity}}
#'   to perform data-driven bandwidth selection; and \code{\link{lpdensity.plot}} for
#'   density plot with robust confidence interval.
#'
#'   The companion software article, \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{Cattaneo, Jansson and Ma (2019b)},
#'   provides further implementation details and illustrations with simulated data.
#'   For related \code{Stata}
#'   and \code{R} packages useful for nonparametric data analysis  and statistical inference,
#'   visit \url{https://sites.google.com/site/nppackages/}.
#'
#' @references
#' M. D. Cattaneo, M. Jansson and X. Ma. (2019a). \href{https://arxiv.org/abs/1811.11512}{Simple Local Polynomial Density Estimators}. Working paper.
#'
#' M. D. Cattaneo, M. Jansson and X. Ma. (2019b). \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{\code{lpdensity}: Local Polynomial Density Estimation and Inference}. Working paper.
#'
#' @author
#' Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.
#'
#' Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.
#'
#' Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
#'
#' @importFrom graphics legend
#' @importFrom graphics lines
#' @importFrom graphics plot
#' @importFrom graphics points
#' @importFrom stats qnorm
#' @importFrom stats quantile
#' @importFrom stats D
#' @importFrom stats integrate
#' @importFrom stats optimize
#' @importFrom stats pnorm
#' @importFrom stats dnorm
#' @importFrom stats sd
#' @import ggplot2
#'
#' @aliases lpdensity-package
"_PACKAGE"
