% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_getScaledData.R
\name{l_getScaledData}
\alias{l_getScaledData}
\title{Data Scaling}
\usage{
l_getScaledData(
  data,
  sequence = NULL,
  scaling = c("variable", "observation", "data", "none"),
  displayOrder = NULL,
  reserve = FALSE,
  as.data.frame = FALSE
)
}
\arguments{
\item{data}{A data frame}

\item{sequence}{vector with variable names that are scaled.
If \code{NULL}, it will be set as the whole column names (all data set will be scaled).}

\item{scaling}{one of 'variable', 'data', 'observation' or 'none' to specify how the data is scaled. See details}

\item{displayOrder}{the order of the display}

\item{reserve}{If \code{TRUE}, return the variables not shown in \code{sequence} as well;
else only return the variables defined in \code{sequence}.}

\item{as.data.frame}{Return a matrix or a data.frame}
}
\description{
Scaling the data set
}
\details{
The \code{scaling} state defines how the data is scaled. The axes
display 0 at one end and 1 at the other. For the following explanation
assume that the data is in a nxp dimensional matrix. The scaling options
are then
\tabular{ll}{
variable \tab per column scaling\cr
observation \tab per row scaling\cr
data \tab whole matrix scaling\cr
none \tab do not scale
}
}
\seealso{
\code{\link{l_serialaxes}}
}
