% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{lol.project.cpca}
\alias{lol.project.cpca}
\title{Class PCA}
\usage{
lol.project.cpca(X, Y, r, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{r}{the rank of the projection.}

\item{...}{trailing args.}
}
\value{
A list of class \code{embedding} containing the following:
\item{A}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{d}{\code{[r]} the signular values associated with the projection matrix \code{A}.}
\item{ylabs}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{centroids}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{priors}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{Xr}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{cr}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function that performs PCA on the class-centered data. Same as low-rank LDA.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.pca(X=X, Y=Y, r=2)  # use cpca to project into 2 dimensions
}
\author{
Eric Bridgeford
}
