% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_network.R
\name{generate_graphon}
\alias{generate_graphon}
\title{Generate a Graphon Probability Matrix}
\usage{
generate_graphon(size, graph_num = 1, sampling_on_u = TRUE, u_input = NULL)
}
\arguments{
\item{size}{An integer specifying the size of the network.}

\item{graph_num}{An integer (default is 1) indicating the graphon type to use. 
Acceptable values are from 1 to 6.}

\item{sampling_on_u}{A logical value determining if uniform sampling should be used for 'u'. 
Defaults to TRUE. If FALSE, a regular sequence from 0 to 1 is used.}

\item{u_input}{An optional numeric vector that provides specific values for 'u'.
If NULL (default), 'u' is generated based on 'sampling_on_u'.}
}
\value{
A matrix of probabilities is returned.
}
\description{
This function generates a graphon probability matrix based on a specified graphon type. 
Users can control the generation process through various parameters.
}
\examples{
# Generate a graphon probability matrix of size 100 using graphon setting 1
P = generate_graphon(100, 1)

}
