\name{TLmoms}
\alias{TLmoms}
\title{ The Sample Trimmed L-moments and L-moment Ratios }
\description{
Compute the sample trimmed L-moments (TL-moments) for a vector. The level of symmetrical trimming is specified. The mathematical expression for a TL-moment is seen under \code{\link{TLmom}}.  The \code{\link{TLmoms}} function loops across that expression and the \code{\link{TLmom}} function for each \code{nmom}=\eqn{r} set in the argument list.
}
\usage{
TLmoms(x, nmom, trim=NULL, leftrim=NULL, rightrim=NULL)
}
\arguments{
  \item{x}{A vector of data values.}
  \item{nmom}{The number of moments to compute. Default is 5.}
  \item{trim}{Level of symmetrical trimming to use in the computations. Although \code{NULL} is in the argument list, the default is 0---the usual L-moment is returned.}
  \item{leftrim}{Level of trimming of the left-tail of the sample, which should be left to \code{NULL} if no or symmetrical trimming is used.}
  \item{rightrim}{Level of trimming of the right-tail of the sample, which should be left to \code{NULL} if no or symmetrical trimming is used.}
}
\value{
  An \R \code{list} is returned.

  \item{lambdas}{Vector of the TL-moments. First element is
\eqn{\hat{\lambda}^{(t_1,t_2)}_1}, second element is \eqn{\hat{\lambda}^{(t_1,t_2)}_2}, and so on.}
  \item{ratios}{Vector of the L-moment ratios. Second element is
\eqn{\hat{\tau}^{(t_1,t_2)}}, third element is \eqn{\hat{\tau}^{(t_1,t_2)}_3} and so on.}
  \item{trim}{Level of symmetrical trimming used in the computation.}
  \item{leftrim}{Level of left-tail trimming used in the computation, which will equal \code{trim} if symmetrical trimming was used.}
  \item{rightrim}{Level of right-tail trimming used in the computation, which will equal \code{trim} if symmetrical trimming was used.}
  \item{source}{An attribute identifying the computational source of the L-moments: \dQuote{TLmoms}.}
}
\references{
Elamir, E.A.H., and Seheult, A.H., 2003, Trimmed L-moments: Computational statistics and data analysis, v. 43, pp. 299-314.
}
\author{ W.H. Asquith}

\seealso{\code{\link{TLmom}}, \code{\link{lmoms}}, and \code{\link{lmorph}}}
\examples{
X1 <- rcauchy(30)
TL <- TLmoms(X1,nmom=6,trim=1)
}
\keyword{L-moment (sample)}
\keyword{L-moment (trimmed sample)}
