% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-utils.R
\name{list_to_data.frame}
\alias{list_to_data.frame}
\title{Convert a list to a data frame}
\usage{
list_to_data.frame(l, name_variables = "names", values_variable = "values",
  stringsAsFactors = getOption("stringsAsFactors"))
}
\arguments{
\item{l}{A variable, probably a list.}

\item{name_variables}{A string. What should the columns formed from
the names of \code{l} be called?}

\item{values_variable}{A string. What should the columns formed from
the values of \code{l} be called?}

\item{stringsAsFactors}{Should character columns be converted to factors?}
}
\value{
\code{\link[base]{data.frame}}.
}
\description{
Converts a list to a data frame, with names in multiple columns.
}
\examples{
(l <- list(
  a = 1,
  2:3,                             # missing names are blank
  c = list(ca = 4:6, 7:10, list(cca = 11:15)),
  d = list()                       # empty elt's silently ignored
))
list_to_data.frame(l)

# Custom column names
list_to_data.frame(l, c("group", "subgroup", "element"), "amount")
}

