% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk-writer.r
\name{listdown}
\alias{listdown}
\title{Create a listdown Object}
\usage{
listdown(
  load_cc_expr,
  package = NULL,
  decorator = list(),
  init_expr = NULL,
  decorator_chunk_opts = list(),
  default_decorator = identity,
  ...,
  chunk_opts = NULL
)
}
\arguments{
\item{load_cc_expr}{either an unquoted expression or a character string
that will be turned into an unquoted expression via str2lang to load the 
presentation list.}

\item{package}{a quoted list of package required by the outputted document.}

\item{decorator}{a named list mapping the potential types of list elements
to a decorator function.}

\item{init_expr}{an initial expression that will be added to the outputted
document after the libraries have been called.}

\item{decorator_chunk_opts}{a named list mapping the potential types of list
elements to chunk options that should be included for those types.}

\item{default_decorator}{the decorator to use for list elements whose type
is not inherited from the decorator list. If NULL then the those
elements will not be included when the chunks are written. By default
this is identity, meaning that the elements will be passed directly
(through the identity() function).}

\item{...}{default options sent to the chunks of the outputted document.}

\item{chunk_opts}{a named list of options sent to the chunks of outputted
documents. Note: takes priority over argument provided to ...}
}
\description{
A listdown object provides information for how a presentation
list should be used to create an R Markdown document. It requires an
unquoted expression indicating how the presentation list will be loaded.
In addition, libraries required by the outputted document and other
parameters can be specified.
}
