## ---- echo = FALSE, message = FALSE-------------------------------------------
library(listcompr)

## -----------------------------------------------------------------------------
gen.vector(i, i = 1:10, i %% 3 == 0 || i %% 4 == 0)

## -----------------------------------------------------------------------------
gen.vector(i, i = 1:10, i %% 3 == 0 || i %% 4 == 0, i != 8)

## -----------------------------------------------------------------------------
gen.list(c(i, j), i = 1:3, j = 1:3, i <= j)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(i, j), i = 1:3, j = i:3)
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a = i, b = j), i = 1:3, j = i:3)
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(x = x, y = y), x = 1:20, y = 1:20, (x-2)*(y-2) == x*y/2)
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a_1, a_2, a_3), a_ = 1:4, a_1 < a_2, a_2 < a_3)
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a_1, ..., a_5), a_ = 1:5, a_1 + ... + a_5 == 6)
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a_1, ..., a_5), a_ = 1:5, sum(a_1, ..., a_5) == 10, 
                     gen.logical.and(a_i <= a_(i+1), i = 1:4))
knitr::kable(df)

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a_1, ..., a_4), a_ = 1:4, 
                     gen.logical.and(a_i != a_j, i = 1:4, j = (i+1):4))
knitr::kable(df[1:8,])

## ---- results='asis'----------------------------------------------------------
df <- gen.data.frame(c(a = a, sumdiv = sum(gen.vector(x, x = 1:(a-1), a %% x == 0))), a = 2:10)
knitr::kable(df)

## -----------------------------------------------------------------------------
gen.vector(a, a = 2:100, a == sum(gen.vector(x, x = 1:(a-1), a %% x == 0)))

## -----------------------------------------------------------------------------
gen.vector.char('size: {x}x{y} tiles, where {x*y/2} tiles are at the border/inner',
                x = 1:20, y = 1:20, (x-2)*(y-2) == x*y/2)

## -----------------------------------------------------------------------------
gen.named.list('divisors_of_{a}', gen.vector(x, x = 1:(a-1), a %% x == 0), a = 5:10)

