% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseConstraints.R
\name{sparse_constraints}
\alias{print.sparse_constraints}
\alias{sparseConstraints}
\alias{sparse_constraints}
\alias{sparse_constraints.data.frame}
\title{Generate sparse set of constraints.}
\usage{
sparse_constraints(object, ...)

sparseConstraints(object, ...)

\method{sparse_constraints}{data.frame}(object, b, neq = length(b),
  base = 1L, sorted = FALSE, ...)

\method{print}{sparse_constraints}(x, range = 1L:10L, ...)
}
\arguments{
\item{object}{R object to be translated to sparse_constraints format.}

\item{...}{options to be passed to other methods}

\item{b}{Constant vector}

\item{neq}{The first \code{new} equations are interpreted as equality constraints, the rest as '<='}

\item{base}{are the indices in \code{object[,1:2]} base 0 or base 1?}

\item{sorted}{is \code{object} sorted by the  first column?}

\item{x}{an object of class \code{sparse_constraints}}

\item{range}{integer vector stating which constraints to print}
}
\value{
Object of class \code{sparse_constraints} (see details).
}
\description{
Generate a constraint set to be used by \code{\link{sparse_project}}

Read sparse constraints from a \code{data.frame}

Print sparse_constraints object
}
\section{Note}{


As of version 0.1.1.0, \code{sparseConstraints} is deprecated. Use \code{sparse_constraints} instead.
}

\section{Details}{


The \code{sparse_constraints} objects holds coefficients of
\eqn{\boldsymbol{A}} and \eqn{\boldsymbol{b}} of the system
\eqn{\boldsymbol{Ax}\leq \boldsymbol{b}} in sparse format, outside of
\code{R}'s memory. It can be reused to find solutions for vectors to adjust.

In \code{R}, it is a \emph{reference object}. In particular, it is meaningless to
\itemize{
   \item{Copy the object. You only will only generate a pointer to physically the same object.}
   \item{Save the object. The physical object is destroyed when \code{R} closes, or when \code{R}'s
     garbage collector cleans up a removed \code{sparse_constraints} object.}
}
}

\section{The \code{$project} method}{


Once a \code{sparse_constraints} object \code{sc} is created, you can reuse it to optimize
several vectors by calling \code{sc$project()} with the following parameters:
\itemize{
  \item{\code{x}: \code{[numeric]} the vector to be optimized}
  \item{\code{w}: \code{[numeric]} the weight vector (of \code{length(x)}). By default all weights equal 1.}
  \item{\code{eps}: \code{[numeric]} desired tolerance. By default \eqn{10^{-2}} }
  \item{\code{maxiter}: \code{[integer]} maximum number of iterations. By default 1000.}
}
The return value of \code{$spa} is the same as that of \code{\link{sparse_project}}.
}
\examples{

# The following system of constraints, stored in
# row-column-coefficient format
#
# x1 + x8 ==  950,
# x3 + x4 ==  950 ,
# x6 + x7 == x8,
# x4 > 0
# 
A <- data.frame( 
   row = c( 1, 1, 2, 2, 3, 3, 3, 4)
   , col = c( 1, 2, 3, 4, 2, 5, 6, 4)
   , coef = c(-1,-1,-1,-1, 1,-1,-1,-1)
)
b <- c(-950, -950, 0,0) 

sc <- sparse_constraints(A, b, neq=3)

# Adjust the 0-vector minimally so all constraints are met:
sc$project(x=rep(0,8))

# Use the same object to adjust the 100*1-vector
sc$project(x=rep(100,8))

# use the same object to adjust the 0-vector, but with different weights
sc$project(x=rep(0,8),w=1:8)


}
\seealso{
\code{\link{sparse_project}}, \code{\link{project}}
}

