% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link2giKarim.R
\name{manuallyBuild}
\alias{manuallyBuild}
\title{Build package manually}
\usage{
manuallyBuild(dsn = getwd(), pkgDir = "H:/Dokumente", document = TRUE, ...)
}
\arguments{
\item{dsn}{'character'. Target folder containing source files; defaults to 
the current working directory.}

\item{pkgDir}{'character'. Target folder containing the result ing package of the invoked build process. According to Marburg University pools the default is set to pkgDir='H:/Dokumente'. If you want to use it in a different setting you may set pkgDir to whatever you want.}

\item{document}{'logical'. Determines whether or not to invoke 
\code{\link{roxygenize}} with default roclets for documentation purposes.}

\item{...}{Further arguments passed on to \code{\link[devtools]{build}}.}
}
\description{
This function was specifically designed to build a package from local source 
files manually, i.e., without using the package building functionality 
offered e.g. by RStudio.
}
\details{
NOTE the default setting are focussing HRZ environment at Marburg University
}
\examples{
\dontrun{
## when in a package directory, e.g. '~/link2GI' 
manuallyBuild()
}


}
\seealso{
\code{\link{roxygenize}}, \code{\link[devtools]{build}},\code{\link{install.packages}}.
}
\author{
Florian Detsch, Chris Reudenbach
}
\keyword{internal}
