% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkOTB.R
\name{linkOTB}
\alias{linkOTB}
\title{Locate and set up 'Orfeo ToolBox' API bindings}
\usage{
linkOTB(bin_OTB = NULL, root_OTB = NULL, type_OTB = NULL,
  searchLocation = NULL, ver_select = FALSE, quiet = TRUE)
}
\arguments{
\item{bin_OTB}{string contains path to where the otb binaries are located}

\item{root_OTB}{string provides the root folder of the \code{bin_OTB}}

\item{type_OTB}{string}

\item{searchLocation}{string hard drive letter default is \code{C:}}

\item{ver_select}{boolean default is FALSE. If there is more than one 'OTB' installation and \code{ver_select} = TRUE the user can select interactively the preferred 'OTB' version}

\item{quiet}{boolean  switch for supressing messages default is TRUE}
}
\value{
add otb pathes to the enviroment and creates global variables path_OTB
}
\description{
Locate and set up  \href{https://www.orfeo-toolbox.org/}{'Orfeo ToolBox'} API bindings
}
\details{
It looks for the \code{otb_cli.bat} file. If the file is found in a \code{bin} folder it is assumed to be a valid 'OTB' binary installation.

if called without any parameter \code{linkOTB()} it performs a full search over the hardrive \code{C:}. If it finds one or more 'OTB' binaries it will take the first hit. You have to set \code{ver_select = TRUE} for an interactive selection of the preferred version.
}
\note{
You may also set the path manually. Using a 'OSGeo4W64' \url{http://trac.osgeo.org/osgeo4w/} installation it is typically \code{C:/OSGeo4W64/bin/}
}
\examples{
\dontrun{
# call if you do not have any idea if and where OTB is installed
linkOTB()

# call it for a default OSGeo4W installation of the OTB
linkOTB("C:/OSGeo4W64/bin/")

# call it for a default Linux installation of the OTB
linkOTB("/usr/bin/")
}
}
\author{
Chris Reudenbach
}
