% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.feature.R
\name{map.feature}
\alias{map.feature}
\title{Create a map}
\usage{
map.feature(
  languages,
  features = "",
  label = "",
  popup = "",
  latitude = NA,
  longitude = NA,
  label.hide = TRUE,
  label.fsize = 15,
  label.font = "sans-serif",
  label.position = "right",
  label.emphasize = list(NULL, "black"),
  shape = NULL,
  shape.size = 20,
  pipe.data = NULL,
  shape.color = "black",
  stroke.features = NULL,
  density.estimation = NULL,
  density.method = "fixed distance",
  density.estimation.color = NULL,
  density.estimation.opacity = 0.6,
  density.points = TRUE,
  density.width = NULL,
  density.legend = TRUE,
  density.legend.opacity = 1,
  density.legend.position = "bottomleft",
  density.title = "",
  density.control = FALSE,
  isogloss = NULL,
  isogloss.color = "black",
  isogloss.opacity = 0.2,
  isogloss.line.width = 3,
  isogloss.width = NULL,
  color = NULL,
  stroke.color = NULL,
  image.url = NULL,
  image.width = 100,
  image.height = 100,
  image.X.shift = 0,
  image.Y.shift = 0,
  title = NULL,
  stroke.title = NULL,
  control = FALSE,
  legend = TRUE,
  legend.opacity = 1,
  legend.position = "topright",
  stroke.legend = TRUE,
  stroke.legend.opacity = 1,
  stroke.legend.position = "bottomleft",
  width = 5,
  stroke.radius = 9.5,
  opacity = 1,
  stroke.opacity = 1,
  scale.bar = TRUE,
  scale.bar.position = "bottomleft",
  minimap = FALSE,
  minimap.position = "bottomright",
  minimap.width = 150,
  minimap.height = 150,
  facet = NULL,
  tile = "OpenStreetMap.Mapnik",
  tile.name = NULL,
  zoom.control = FALSE,
  zoom.level = NULL,
  rectangle.lng = NULL,
  rectangle.lat = NULL,
  rectangle.color = "black",
  line.lng = NULL,
  line.lat = NULL,
  line.type = "standard",
  line.color = "black",
  line.opacity = 0.8,
  line.label = NULL,
  line.width = 3,
  graticule = NULL,
  minichart = "bar",
  minichart.data = NULL,
  minichart.time = NULL,
  minichart.labels = FALSE,
  map.orientation = "Pacific",
  radius = NULL
)
}
\arguments{
\item{languages}{character vector of languages (can be written in lower case)}

\item{features}{character vector of features}

\item{label}{character vector of strings that will appear near points}

\item{popup}{character vector of strings that will appear in pop-up window}

\item{latitude}{numeric vector of latitudes}

\item{longitude}{numeric vector of longitudes}

\item{label.hide}{logical. If FALSE, labels are displayed allways. If TRUE, labels are displayed on mouse over. By default is TRUE.}

\item{label.fsize}{numeric value of the label font size. By default is 14.}

\item{label.font}{string with values of generic family: "serif", "sans-serif", "monospace", or font name e. g. "Times New Roman"}

\item{label.position}{the position of labels: "left", "right", "top", "bottom"}

\item{label.emphasize}{is the list. First argument is a vector of points in datframe that should be emphasized. Second argument is a string with a color for emphasis.}

\item{shape}{\enumerate{ \item if TRUE, creates icons (up to five categories) for values in the \code{features} variable; \item it also could be a vector of any strings that represents the levels of the  \code{features} variable; \item it also could be a string vector that represents the number of observations in dataset.}}

\item{shape.size}{size of the \code{shape} icons}

\item{pipe.data}{this variable is important, when you use map.feature with dplyr pipes. Expected usage: pipe.data = .}

\item{shape.color}{color of the \code{shape} icons}

\item{stroke.features}{additional independent stroke features}

\item{density.estimation}{additional independent features, used for density estimation}

\item{density.method}{string with one of the two methods: "kernal density estimation" or "fixed distance" (default)}

\item{density.estimation.color}{vector of density polygons' colors}

\item{density.estimation.opacity}{a numeric vector of density polygons opacity.}

\item{density.points}{logical. If FALSE, it doesn't show points in polygones.}

\item{density.width}{for density.method = "fixed distance" it is a numeric measure (1 is 1km). For density.method = "kernal density estimation" it is a vector with two meausures (first is latitude, secong is longitude). Defaults are normal reference bandwidth (see \link{bandwidth.nrd}).}

\item{density.legend}{logical. If TRUE, function show legend for density features. By default is FALSE.}

\item{density.legend.opacity}{a numeric vector of density-legend opacity.}

\item{density.legend.position}{the position of the legend: "topright", "bottomright", "bottomleft","topleft"}

\item{density.title}{title of a density-feature legend}

\item{density.control}{logical. If TRUE, function show layer control buttons for density plot. By default is FALSE}

\item{isogloss}{dataframe with corresponding features}

\item{isogloss.color}{vector of isoglosses' colors}

\item{isogloss.opacity}{a numeric vector of density polygons opacity.}

\item{isogloss.line.width}{a numeric value for line width}

\item{isogloss.width}{for density.method = "fixed distance" it is a numeric measure (1 is 1km). For density.method = "kernal density estimation" it is a vector with two meausures (first is latitude, secong is longitude). Defaults are normal reference bandwidth (see \link{bandwidth.nrd}).}

\item{color}{vector of colors or palette. The color argument can be (1) a character vector of RGM or named colors; (2) the name of an RColorBrewer palette; (3) the full name of a viridis palette; (4) a function that receives a single value between 0 and 1 and returns a color. For more examples see \code{\link{colorNumeric}}}

\item{stroke.color}{vector of stroke colors}

\item{image.url}{character vector of URLs with an images}

\item{image.width}{numeric vector of image widths}

\item{image.height}{numeric vector of image heights}

\item{image.X.shift}{numeric vector of image's X axis shift relative to the latitude-longitude point}

\item{image.Y.shift}{numeric vector of image's Y axis shift relative to the latitude-longitude point}

\item{title}{title of a legend.}

\item{stroke.title}{title of a stroke-feature legend.}

\item{control}{logical. If TRUE, function show layer control buttons. By default is FALSE}

\item{legend}{logical. If TRUE, function show legend. By default is TRUE.}

\item{legend.opacity}{a numeric vector of legend opacity.}

\item{legend.position}{the position of the legend: "topright", "bottomright", "bottomleft","topleft"}

\item{stroke.legend}{logical. If TRUE, function show stroke.legend. By default is FALSE.}

\item{stroke.legend.opacity}{a numeric vector of stroke.legend opacity.}

\item{stroke.legend.position}{the position of the stroke.legend: "topright", "bottomright", "bottomleft","topleft"}

\item{width}{a numeric vector of radius for circles or width for barcharts in minicharts.}

\item{stroke.radius}{a numeric vector of stroke radii for the circles.}

\item{opacity}{a numeric vector of marker opacity.}

\item{stroke.opacity}{a numeric vector of stroke opacity.}

\item{scale.bar}{logical. If TRUE, function shows scale-bar. By default is TRUE.}

\item{scale.bar.position}{the position of the scale-bar: "topright", "bottomright", "bottomleft","topleft"}

\item{minimap}{logical. If TRUE, function shows mini map. By default is FALSE.}

\item{minimap.position}{the position of the minimap: "topright", "bottomright", "bottomleft","topleft"}

\item{minimap.width}{The width of the minimap in pixels.}

\item{minimap.height}{The height of the minimap in pixels.}

\item{facet}{character vector that provide a grouping variable. If it is no \code{NULL}, then as a result a list of leaflets for \code{sync} or \code{latticeView} functions from \code{mapview} package is returned.}

\item{tile}{a character verctor with a map tiles, popularized by Google Maps. See \href{https://leaflet-extras.github.io/leaflet-providers/preview/index.html}{here} for the complete set.}

\item{tile.name}{a character verctor with a user's map tiles' names.}

\item{zoom.control}{logical. If TRUE, function shows zoom controls. By default is FALSE.}

\item{zoom.level}{a numeric value of the zoom level.}

\item{rectangle.lng}{vector of two longitude values for rectangle.}

\item{rectangle.lat}{vector of two latitude values for rectangle.}

\item{rectangle.color}{vector of rectangle border color.}

\item{line.lng}{vector of two (or more) longitude values for line.}

\item{line.lat}{vector of two (or more) latitude values for line.}

\item{line.type}{a character string indicating which type of line is to be computed. One of "standard" (default), or "logit". The first one should be combined with the arguments line.lat and line.lng and provide simple lines. Other variant "logit" is the decision boundary of the logistic regression made using longitude and latitude coordinates (works only if feature argument have two levels).}

\item{line.color}{vector of line color.}

\item{line.opacity}{a numeric vector of line opacity.}

\item{line.label}{character vector that will appear near the line.}

\item{line.width}{a numeric vector of line width.}

\item{graticule}{a numeric vector for graticule spacing in map units between horizontal and vertical lines.}

\item{minichart}{citation from leaflet.minicharts package: "Possible values are "bar" for bar charts, "pie" for pie charts, "polar-area" and "polar-radius"."}

\item{minichart.data}{citation from leaflet.minicharts package: "A numeric matrix with number of rows equal to the number of elements in lng or lat and number of column equal to the number of variables to represent. If parameter time is set, the number of rows must be equal to the length of lng times the number of unique time steps in the data."}

\item{minichart.time}{citation from leaflet.minicharts package: "A vector with length equal to the number of rows in chartdata and containing either numbers representing time indices or dates or datetimes. Each unique value must appear as many times as the others. This parameter can be used when one wants to represent the evolution of some variables on a map."}

\item{minichart.labels}{citation from leaflet.minicharts package: "Should values be displayed above chart elements."}

\item{map.orientation}{a character verctor with values "Pacific" and "Atlantic". It distinguishes Pacific-centered and Atlantic-centered maps. By default is "Pacific".}

\item{radius}{deprecated argument}
}
\description{
Map a set of languages and color them by feature or two sets of features.
}
\examples{
map.feature(c("Adyghe", "Russian"))

}
\author{
George Moroz <agricolamz@gmail.com>
}
