% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.glottolog.R
\name{is.glottolog}
\alias{is.glottolog}
\title{Are these langoids in glottolog?}
\usage{
is.glottolog(x, response = FALSE)
}
\arguments{
\item{x}{A character vector of linguoids (can be written in lower case)or ISO codes}

\item{response}{logical. If TRUE, when languoid is absent, return warnings with a possible candidates.}
}
\description{
Takes any vector of linguoids or ISO codes and return a logical vector.
}
\examples{
is.glottolog(c("Adyghe", "Russsian"))

# Add warning message with sugestions
is.glottolog(c("Adyge", "Russian"), response = TRUE)
# > FALSE TRUE
# Warning message:
# In is.glottolog(c("Adyge", "Russian"), response = TRUE) :
# Languoid Adyge is absent in our database. Did you mean Aduge, Adyghe?

}
\author{
George Moroz <agricolamz@gmail.com>
}

