% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lost_tags_action.R
\name{lost_tags_action}
\alias{lost_tags_action}
\alias{get_lost_tags_action}
\title{Check and set behaviour for lost tags}
\usage{
lost_tags_action(
  x = NULL,
  action = c("warning", "error", "none"),
  quiet = FALSE
)

get_lost_tags_action()
}
\arguments{
\item{x}{either a \code{character}, or an optional \code{linelist} object; if a
\code{character}, it needs matching \code{warning} (default), \code{error} or \code{none} (see
below)}

\item{action}{a \code{character} indicating the behaviour to adopt when tagged
variables have been lost: "error" (default) will issue an error; "warning"
will issue a warning; "none" will do nothing}

\item{quiet}{a \code{logical} indicating if a message should be displayed; only
used outside pipelines}
}
\value{
if a a \code{linelist} is provided, it returns the object unchanged;
otherwise, returns \code{NULL}; the option itself is set in
\code{options("linelist")}
}
\description{
This function determines the behaviour to adopt when tagged variables of a
\code{linelist} are lost e.g. through subsetting. This is achieved using \code{options}
defined for the \code{linelist} package. The function can be used in isolation,
but it can also accept a dataset as first argument, so that it can be used in
pipelines as well.
}
\examples{
# reset default - done automatically at package loading
lost_tags_action()

# check current value
get_lost_tags_action()

# change to issue errors when tags are lost
lost_tags_action("error")
get_lost_tags_action()

# change to ignore when tags are lost
lost_tags_action("none")
get_lost_tags_action()

# reset to default: warning
lost_tags_action()
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
