% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_run.R
\name{run_model}
\alias{run_model}
\title{run_model}
\usage{
run_model(
  data = NULL,
  dv = NULL,
  ivs = NULL,
  trans_df = NULL,
  id_var = NULL,
  pool_var = NULL,
  model_table = NULL,
  verbose = FALSE,
  normalise_by_pool = FALSE,
  save_all_raw_data = TRUE,
  decompose = TRUE,
  tail_window = NULL,
  categories = NULL
)
}
\arguments{
\item{data}{\code{data.frame} containing variables included in the model specification}

\item{dv}{string of the dependent variable name}

\item{ivs}{character vector of the independent variables names}

\item{trans_df}{\code{data.frame} defining the non-linear transformations to apply}

\item{id_var}{string of id variable name (e.g. date)}

\item{pool_var}{string specifying the pool variable name (e.g. 'country')}

\item{model_table}{\code{data.frame} as created in the \code{build_model_table} function}

\item{verbose}{A boolean to specify whether to print warnings}

\item{normalise_by_pool}{A boolean to specify whether to apply the normalisation}

\item{save_all_raw_data}{A boolean to specify whether to save whole input data to the model object}

\item{decompose}{A boolean to specify whether to generate the model decomposition}

\item{tail_window}{for time series, length of tail in decomposition}

\item{categories}{\code{data.frame} mapping variables to groups}
}
\value{
Model object
}
\description{
Run a linear regression model
}
\details{
Run a linear regression model that captures the transformations applied in the \code{model_table} and the normalisation based on the \code{pool_var}.
A model can be run also by only supplying a dependent variable name \code{dv}, a vector of independent variable names dependent variable \code{ivs}, and the data that contains these.
}
\examples{

trans_df = data.frame(
    name = c('diminish', 'decay', 'hill', 'exp'),
    func = c(
      'linea::diminish(x,a)',
      'linea::decay(x,a)',
      "linea::hill_function(x,a,b,c)",
      '(x^a)'
    ),
    order = 1:4
)

data = read_xcsv("https://raw.githubusercontent.com/paladinic/data/main/ecomm_data.csv")
dv = 'ecommerce'
ivs = c('christmas','black.friday')

run_model(data = data,
          dv = dv,
          ivs = ivs,
          trans_df = trans_df)

run_model(data = mtcars,dv = 'mpg',ivs = c('disp','cyl'))

}
