% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_read_tsv.R
\name{ls_read_tsv}
\alias{ls_read_tsv}
\title{Read a LimeSurvey Tab-Separated Values file}
\usage{
ls_read_tsv(file, encoding = limonaid::opts$get("encoding"))
}
\arguments{
\item{file}{The filename to read.}

\item{encoding}{The encoding to use when reading the file.}
}
\value{
A dataframe.
}
\description{
Read a LimeSurvey Tab-Separated Values file
}
\examples{
### Get location of one of the example files
exampleFile <-
  system.file(
    "extdata",
    "export-of-survey-with-one-question-as-tsv.txt",
    package = "limonaid"
  );

### Import file
lsrv <- limonaid::ls_read_tsv(exampleFile);
}
