% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_intraday.R
\name{plot_intraday}
\alias{plot_intraday}
\title{Switch table to plot intraday variables.}
\usage{
plot_intraday(person, measure_var = "all", avg_to_get_typical_day = TRUE,
  ...)
}
\arguments{
\item{person}{An instance of the Person class}

\item{measure_var}{Character vector of length 1 denoting the variable of 
interest.  Options include: "steps", "floors", "distance", 
"caloriesBurned", "activeMin", "bpm" (heart rate), "weight".  By default, 
all are plotted.}

\item{avg_to_get_typical_day}{Logical vector of length 1.  If TRUE, plot 
gives an aggregate of the variable over the course of a typical day.  If 
FALSE, plot gives the variable at every interval over the range specified
 when the Person object was instantiated.}

\item{...}{Extra arguments used to specify unit for the distance and weight
plots.}
}
\value{
NULL, but plots print to screen
}
\description{
Plot one continuous intraday variable across time.  Users can 
    specify if they want to look at an aggregate of a variable over the 
    course of a day (avg_to_get_typical_day = TRUE) or look at that variable 
    at every interval (i.e. every 15 minutes for the entire date range).
}
\examples{
data(EX)
plot_intraday(EX, "steps")
plot_intraday(EX, "distance", unit = "km")
plot_intraday(EX, "caloriesBurned", FALSE)
plot_intraday(EX, "steps", FALSE)
plot_intraday(EX, "bpm")

}
\seealso{
\code{\link{plot_intraday}}
}
