% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lccall-subject.R
\name{is_valid_lc_call}
\alias{is_valid_lc_call}
\title{Check if LC Call Number is valid}
\usage{
is_valid_lc_call(x)
}
\arguments{
\item{x}{A Library of Congress call number (string)}
}
\value{
Returns either TRUE or FALSE based on whether the
        call number is valid
}
\description{
Takes a string representation of a Library of Congress
call number and returns either TRUE or FALSE based on
whether or not the input fits the canonical LC Call
Number pattern
}
\examples{

is_valid_lc_call("Q172.5.E77")
# TRUE
is_valid_lc_call("AF172.5.E77")
# FALSE

# vectorized
is_valid_lc_call(c("Q 172.5", "AF172", "PR6023.A93"))
# TRUE FALSE TRUE

}
